/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2012, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.qa.tools.arquillian.extension;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

import org.apache.log4j.Logger;


/**
 * Util functions used in extensions.
 * 
 * @author ochaloup
 */
public class ArquillianUtils {
    private static final Logger log = Logger.getLogger(ArquillianUtils.class);
    
    // General properties
    public static final String FS = System.getProperty("file.separator");    
       
    /**
     * A little hacky method for getting eap version.
     * The value is returned based on eap.version system property if it's defined or 
     * it's trying to check arquillian config file and it's name it's searching for version.
     * There is general problem that arquillian is (was) not able to return info about container that it's running on.
     * 
     * @return eap version as number (5, 6)
     */
    public static int getEAPVersion() {
        String eapVersion = System.getProperty("eap.version");
        if(eapVersion != null) {
            try {
                return Integer.valueOf(eapVersion);
            } catch (NumberFormatException nfe) {
                // nothing to do
            }
        }
        
        String arqConfigurationFile = System.getProperty("arquillian.xml");
        if (arqConfigurationFile != null && arqConfigurationFile.trim().length() > 0) {
            if (arqConfigurationFile.toLowerCase().contains("eap5")) {
                return 5;
            }
            if (arqConfigurationFile.toLowerCase().contains("eap6")) {
                return 6;
            }
        }
        return -1;
    }
    
    public static void copyFile(String sourceFile, String destFile) throws IOException {
        copyFile(new File(sourceFile), new File(destFile));
    }
    
    /**
     * Awkward way to copy a file in java.
     * http://stackoverflow.com/questions/106770/standard-concise-way-to-copy-a-file-in-java
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if(!destFile.exists()) {
        	log.debug("Destination file " + destFile + " does not exist - creating...");
            destFile.createNewFile();
        }

        FileChannel source = null;
        FileChannel destination = null;

        try {
        	log.debug("Copying " + sourceFile + " to " + destFile);
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            destination.transferFrom(source, 0, source.size());
        }
        finally {
            if(source != null) {
                source.close();
            }
            if(destination != null) {
                destination.close();
            }
        }
    }
}
