/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2012, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.qa.tools.arquillian.extension;

import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.as.arquillian.container.ManagementClient;

/**
 * Just a simple plugin interface for {@link ServerConfigurationExtension} extension.
 * The {@link ServerConfiguration} will take it and run it.
 * 
 * @author ochaloup
 */
public interface ServerConfigurationDefinition {
    /**
     * Will be run before server start.
     */
    void beforeStart(ManagementClient managementClient, ArquillianDescriptor descriptor);
    
    /**
     * Will be run after server start.
     */
    void afterStart(ManagementClient managementClient, ArquillianDescriptor descriptor);
    
    /**
     * Will be run before server stop.
     */
    void beforeShutdown(ManagementClient managementClient, ArquillianDescriptor descriptor);
    
    /**
     * Will be run after server shutdown.
     */
    void afterShutdown(ManagementClient managementClient, ArquillianDescriptor descriptor);
}
