package org.jboss.ejb._private;

import java.util.Locale;
import jakarta.ejb.NoSuchEJBException;
import java.lang.IllegalStateException;
import java.io.Serializable;
import java.util.Set;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.ejb.client.RequestSendFailedException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.net.URI;
import javax.naming.Name;
import java.lang.RuntimeException;
import java.lang.ReflectiveOperationException;
import org.jboss.ejb.client.StatelessEJBLocator;
import jakarta.transaction.SystemException;
import org.jboss.logging.BasicLogger;
import javax.naming.NamingException;
import java.io.InvalidObjectException;
import org.jboss.ejb.client.EJBLocator;
import java.util.concurrent.ExecutionException;
import org.wildfly.client.config.ConfigurationXMLStreamReader;
import java.lang.IllegalArgumentException;
import java.util.concurrent.TimeoutException;
import org.jboss.ejb.client.EJBMethodLocator;
import javax.annotation.processing.Generated;
import javax.naming.CommunicationException;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.remoting3.Channel;
import java.io.InvalidClassException;
import java.io.IOException;
import java.lang.Exception;
import java.util.concurrent.atomic.AtomicBoolean;
import jakarta.transaction.Transaction;
import java.util.concurrent.CancellationException;
import org.jboss.ejb.client.EJBClientInvocationContext;
import java.lang.Runnable;
import org.jboss.ejb.client.Affinity;
import java.lang.Throwable;
import java.lang.Class;
import java.lang.Object;
import java.util.Arrays;
import jakarta.transaction.NotSupportedException;
import jakarta.ejb.EJBException;
import org.jboss.ejb.client.EJBIdentifier;
import org.wildfly.client.config.ConfigXMLParseException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2024-02-07T16:18:01+0100")
public class Logs_$logger extends DelegatingBasicLogger implements Logs, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Logs_$logger.class.getName();
    public Logs_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void greeting(final String version) {
        super.log.logf(FQCN, INFO, null, greeting$str(), version);
    }
    protected String greeting$str() {
        return "JBoss EJB Client version %s";
    }
    protected String emptyModuleName$str() {
        return "Module name cannot be null or empty";
    }
    @Override
    public final IllegalArgumentException emptyModuleName() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), emptyModuleName$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String emptyBeanName$str() {
        return "EJBCLIENT000001: Bean name cannot be null or empty";
    }
    @Override
    public final IllegalArgumentException emptyBeanName() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), emptyBeanName$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullViewType$str() {
        return "EJBCLIENT000002: Bean interface type cannot be null";
    }
    @Override
    public final IllegalArgumentException nullViewType() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullViewType$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void incorrectMaxAllowedConnectedNodesValueForCluster(final String value, final String clusterName, final String fallbackDefaultValue) {
        super.log.logf(FQCN, INFO, null, incorrectMaxAllowedConnectedNodesValueForCluster$str(), value, clusterName, fallbackDefaultValue);
    }
    protected String incorrectMaxAllowedConnectedNodesValueForCluster$str() {
        return "EJBCLIENT000003: Incorrect max-allowed-connected-nodes value %s specified for cluster named %s. Defaulting to %s";
    }
    @Override
    public final void incorrectConnectionTimeoutValueForCluster(final String value, final String clusterName, final String fallbackDefaultValue) {
        super.log.logf(FQCN, INFO, null, incorrectConnectionTimeoutValueForCluster$str(), value, clusterName, fallbackDefaultValue);
    }
    protected String incorrectConnectionTimeoutValueForCluster$str() {
        return "EJBCLIENT000004: Incorrect connection timeout value %s specified for cluster named %s. Defaulting to %s";
    }
    @Override
    public final void incorrectConnectionTimeoutValueForNodeInCluster(final String value, final String nodeName, final String clusterName, final String fallbackDefaultValue) {
        super.log.logf(FQCN, INFO, null, incorrectConnectionTimeoutValueForNodeInCluster$str(), value, nodeName, clusterName, fallbackDefaultValue);
    }
    protected String incorrectConnectionTimeoutValueForNodeInCluster$str() {
        return "EJBCLIENT000005: Incorrect connection timeout value %s specified for node %s in cluster named %s. Defaulting to %s";
    }
    @Override
    public final void skippingConnectionCreationDueToMissingHostOrPort(final String connectionName) {
        super.log.logf(FQCN, INFO, null, skippingConnectionCreationDueToMissingHostOrPort$str(), connectionName);
    }
    protected String skippingConnectionCreationDueToMissingHostOrPort$str() {
        return "EJBCLIENT000006: No host/port configured for connection named %s. Skipping connection creation";
    }
    @Override
    public final void skippingConnectionCreationDueToInvalidPortNumber(final String port, final String connectionName) {
        super.log.logf(FQCN, INFO, null, skippingConnectionCreationDueToInvalidPortNumber$str(), port, connectionName);
    }
    protected String skippingConnectionCreationDueToInvalidPortNumber$str() {
        return "EJBCLIENT000007: Incorrect port value %s specified for connection named %s. Skipping connection creation";
    }
    @Override
    public final void incorrectConnectionTimeoutValueForConnection(final String value, final String connectionName, final String fallbackDefaultValue) {
        super.log.logf(FQCN, INFO, null, incorrectConnectionTimeoutValueForConnection$str(), value, connectionName, fallbackDefaultValue);
    }
    protected String incorrectConnectionTimeoutValueForConnection$str() {
        return "EJBCLIENT000008: Incorrect connection timeout value %s specified for connection named %s. Defaulting to %s";
    }
    @Override
    public final void incorrectInvocationTimeoutValue(final String value, final String fallbackDefaultValue) {
        super.log.logf(FQCN, INFO, null, incorrectInvocationTimeoutValue$str(), value, fallbackDefaultValue);
    }
    protected String incorrectInvocationTimeoutValue$str() {
        return "EJBCLIENT000009: Incorrect invocation timeout value %s specified. Defaulting to %s";
    }
    @Override
    public final void incorrectReconnectTasksTimeoutValue(final String value, final String fallbackDefaultValue) {
        super.log.logf(FQCN, INFO, null, incorrectReconnectTasksTimeoutValue$str(), value, fallbackDefaultValue);
    }
    protected String incorrectReconnectTasksTimeoutValue$str() {
        return "EJBCLIENT000010: Incorrect reconnect tasks timeout value %s specified. Defaulting to %s";
    }
    @Override
    public final void discardingInvocationResult(final short invocationId) {
        super.log.logf(FQCN, INFO, null, discardingInvocationResult$str(), invocationId);
    }
    protected String discardingInvocationResult$str() {
        return "EJBCLIENT000011: Discarding result for invocation id %s since no waiting context found";
    }
    @Override
    public final void cannotCreateEJBReceiverDueToUnknownTarget(final String clusterNode) {
        super.log.logf(FQCN, INFO, null, cannotCreateEJBReceiverDueToUnknownTarget$str(), clusterNode);
    }
    protected String cannotCreateEJBReceiverDueToUnknownTarget$str() {
        return "EJBCLIENT000012: Cannot create a EJB receiver for %s since there was no match for a target destination";
    }
    @Override
    public final void initialModuleAvailabilityReportNotReceived(final EJBReceiver ejbReceiver) {
        super.log.logf(FQCN, INFO, null, initialModuleAvailabilityReportNotReceived$str(), ejbReceiver);
    }
    protected String initialModuleAvailabilityReportNotReceived$str() {
        return "EJBCLIENT000015: Initial module availability report for %s wasn't received during the receiver context association";
    }
    @Override
    public final void channelCanNoLongerProcessMessages(final Channel channel) {
        super.log.logf(FQCN, INFO, null, channelCanNoLongerProcessMessages$str(), channel);
    }
    protected String channelCanNoLongerProcessMessages$str() {
        return "EJBCLIENT000016: Channel %s can no longer process messages";
    }
    @Override
    public final void receivedServerVersionAndMarshallingStrategies(final int version, final Set<String> marshallingStrategies) {
        super.log.logf(FQCN, INFO, null, receivedServerVersionAndMarshallingStrategies$str(), version, marshallingStrategies);
    }
    protected String receivedServerVersionAndMarshallingStrategies$str() {
        return "EJBCLIENT000017: Received server version %d and marshalling strategies %s";
    }
    protected String noEJBClientContextAvailable$str() {
        return "EJBCLIENT000022: No EJB client context is available";
    }
    @Override
    public final IllegalStateException noEJBClientContextAvailable() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noEJBClientContextAvailable$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noEJBReceiverAvailable$str() {
        return "EJBCLIENT000024: No EJB receiver available for handling destination \"%s\"";
    }
    @Override
    public final NoSuchEJBException noEJBReceiverAvailable(final URI locator) {
        final NoSuchEJBException result = new NoSuchEJBException(String.format(getLoggingLocale(), noEJBReceiverAvailable$str(), locator));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noEJBReceiverForNode$str() {
        return "EJBCLIENT000027: No EJBReceiver available for node name %s";
    }
    @Override
    public final IllegalStateException noEJBReceiverForNode(final String nodeName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noEJBReceiverForNode$str(), nodeName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noReceiverContextsInCluster$str() {
        return "EJBCLIENT000028: No EJB receiver contexts available in cluster %s";
    }
    @Override
    public final IllegalStateException noReceiverContextsInCluster(final String clusterName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noReceiverContextsInCluster$str(), clusterName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noClusterContextAvailable$str() {
        return "EJBCLIENT000029: No cluster context available for cluster named %s";
    }
    @Override
    public final IllegalStateException noClusterContextAvailable(final String clusterName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noClusterContextAvailable$str(), clusterName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sendRequestCalledDuringWrongPhase$str() {
        return "EJBCLIENT000030: sendRequest() called during wrong phase";
    }
    @Override
    public final IllegalStateException sendRequestCalledDuringWrongPhase() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), sendRequestCalledDuringWrongPhase$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noReceiverAssociatedWithInvocation$str() {
        return "EJBCLIENT000031: No receiver associated with invocation";
    }
    @Override
    public final IllegalStateException noReceiverAssociatedWithInvocation() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noReceiverAssociatedWithInvocation$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotRetryRequest$str() {
        return "EJBCLIENT000032: Cannot retry a request which hasn't previously been completed";
    }
    @Override
    public final IllegalStateException cannotRetryRequest() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotRetryRequest$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getResultCalledDuringWrongPhase$str() {
        return "EJBCLIENT000033: getResult() called during wrong phase";
    }
    @Override
    public final IllegalStateException getResultCalledDuringWrongPhase() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), getResultCalledDuringWrongPhase$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String discardResultCalledDuringWrongPhase$str() {
        return "EJBCLIENT000034: discardResult() called during wrong phase";
    }
    @Override
    public final IllegalStateException discardResultCalledDuringWrongPhase() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), discardResultCalledDuringWrongPhase$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedNamingOperation$str() {
        return "EJBCLIENT000035: Not supported";
    }
    @Override
    public final NamingException unsupportedNamingOperation() {
        final NamingException result = new NamingException(String.format(getLoggingLocale(), unsupportedNamingOperation$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedNamingOperationForReadOnlyContext$str() {
        return "EJBCLIENT000036: Read only naming context, operation not supported";
    }
    @Override
    public final NamingException unsupportedNamingOperationForReadOnlyContext() {
        final NamingException result = new NamingException(String.format(getLoggingLocale(), unsupportedNamingOperationForReadOnlyContext$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotLoadProxyClass$str() {
        return "EJBCLIENT000037: Could not load ejb proxy class %s";
    }
    @Override
    public final NamingException couldNotLoadProxyClass(final String viewClassName) {
        final NamingException result = new NamingException(String.format(getLoggingLocale(), couldNotLoadProxyClass$str(), viewClassName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String txEnlistmentDidNotYieldTxId$str() {
        return "EJBCLIENT000038: Transaction enlistment did not yield a transaction ID";
    }
    @Override
    public final IllegalStateException txEnlistmentDidNotYieldTxId() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), txEnlistmentDidNotYieldTxId$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotEnlistTx$str() {
        return "EJBCLIENT000039: Cannot enlist transaction";
    }
    @Override
    public final IllegalStateException cannotEnlistTx() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotEnlistTx$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String primaryKeyNotRelevantForSessionBeans$str() {
        return "EJBCLIENT000041: A session bean does not have a primary key class";
    }
    @Override
    public final RuntimeException primaryKeyNotRelevantForSessionBeans() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), primaryKeyNotRelevantForSessionBeans$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void failedToFindEjbClientConfigFileSpecifiedBySysProp(final String sysPropName, final Exception e) {
        super.log.logf(FQCN, WARN, null, failedToFindEjbClientConfigFileSpecifiedBySysProp$str(), sysPropName, e);
    }
    protected String failedToFindEjbClientConfigFileSpecifiedBySysProp$str() {
        return "EJBCLIENT000042: Failed to load EJB client configuration file specified in %s system property: %s";
    }
    protected String failedToReadEjbClientConfigFile$str() {
        return "EJBCLIENT000043: Error reading EJB client properties file %s";
    }
    @Override
    public final RuntimeException failedToReadEjbClientConfigFile(final Exception e, final String file) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failedToReadEjbClientConfigFile$str(), file), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noTxContextAvailable$str() {
        return "EJBCLIENT000044: No transaction context available";
    }
    @Override
    public final IllegalStateException noTxContextAvailable() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noTxContextAvailable$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String userTxNotSupportedByTxContext$str() {
        return "EJBCLIENT000045: User transactions not supported by this context";
    }
    @Override
    public final IllegalStateException userTxNotSupportedByTxContext() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), userTxNotSupportedByTxContext$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String txAlreadyAssociatedWithThread$str() {
        return "EJBCLIENT000046: A transaction is already associated with this thread";
    }
    @Override
    public final NotSupportedException txAlreadyAssociatedWithThread() {
        final NotSupportedException result = new NotSupportedException(String.format(getLoggingLocale(), txAlreadyAssociatedWithThread$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noTxAssociatedWithThread$str() {
        return "EJBCLIENT000047: A transaction is not associated with this thread";
    }
    @Override
    public final IllegalStateException noTxAssociatedWithThread() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noTxAssociatedWithThread$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String txNotActiveForThread$str() {
        return "EJBCLIENT000048: Transaction for this thread is not active";
    }
    @Override
    public final IllegalStateException txNotActiveForThread() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), txNotActiveForThread$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String txNodeIsExcludedForInvocation$str() {
        return "EJBCLIENT000049: Cannot proceed with invocation since transaction is pinned to node %s which has been excluded from handling invocation for the current invocation context %s";
    }
    @Override
    public final IllegalStateException txNodeIsExcludedForInvocation(final String nodeName, final EJBClientInvocationContext invocationContext) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), txNodeIsExcludedForInvocation$str(), nodeName, invocationContext));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nodeDoesNotAcceptLocator$str() {
        return "EJBCLIENT000050: Node of the current transaction %s does not accept %s";
    }
    @Override
    public final IllegalStateException nodeDoesNotAcceptLocator(final String nodeName, final EJBLocator<?> locator) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), nodeDoesNotAcceptLocator$str(), nodeName, locator));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String requiredNodeExcludedFromInvocation$str() {
        return "EJBCLIENT000051: Cannot proceed with invocation since the locator %s has an affinity on node %s which has been excluded from current invocation context %s";
    }
    @Override
    public final IllegalStateException requiredNodeExcludedFromInvocation(final EJBLocator<?> locator, final String nodeName, final EJBClientInvocationContext invocationContext) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), requiredNodeExcludedFromInvocation$str(), locator, nodeName, invocationContext));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedClusterNodeSelectorClassType$str() {
        return "EJBCLIENT000052: %s for cluster %s is not of type org.jboss.ejb.client.ClusterNodeSelector";
    }
    @Override
    public final RuntimeException unexpectedClusterNodeSelectorClassType(final Class<?> nodeSelectorClass, final String clusterName) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), unexpectedClusterNodeSelectorClassType$str(), nodeSelectorClass, clusterName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotCreateClusterNodeSelector$str() {
        return "EJBCLIENT000053: Could not create the cluster node selector for cluster %s";
    }
    @Override
    public final RuntimeException couldNotCreateClusterNodeSelector(final Exception e, final String clusterName) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), couldNotCreateClusterNodeSelector$str(), clusterName), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotSpecifyBothCallbackHandlerAndUserPass$str() {
        return "EJBCLIENT000054: Cannot specify both a callback handler and a username/password";
    }
    @Override
    public final IllegalStateException cannotSpecifyBothCallbackHandlerAndUserPass() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotSpecifyBothCallbackHandlerAndUserPass$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotDecodeBase64Password$str() {
        return "EJBCLIENT000055: Could not decode base64 encoded password";
    }
    @Override
    public final RuntimeException couldNotDecodeBase64Password(final Exception e) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), couldNotDecodeBase64Password$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotSpecifyBothPlainTextAndEncodedPassword$str() {
        return "EJBCLIENT000056: Cannot specify both a plain text and base64 encoded password";
    }
    @Override
    public final IllegalStateException cannotSpecifyBothPlainTextAndEncodedPassword() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotSpecifyBothPlainTextAndEncodedPassword$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotInstantiateDeploymentNodeSelector$str() {
        return "EJBCLIENT000058: Failed to instantiate deployment node selector class \"%s\"";
    }
    @Override
    public final IllegalArgumentException cannotInstantiateDeploymentNodeSelector(final String name, final ReflectiveOperationException e) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotInstantiateDeploymentNodeSelector$str(), name), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void failedToSendInvocationCancellationMessage(final short invocationId, final Exception e) {
        super.log.logf(FQCN, WARN, e, failedToSendInvocationCancellationMessage$str(), invocationId);
    }
    protected String failedToSendInvocationCancellationMessage$str() {
        return "EJBCLIENT000059: Could not send a message over remoting channel, to cancel invocation for invocation id %s";
    }
    protected String failedToCreateScopedEjbClientContext$str() {
        return "EJBCLIENT000060: Failed to create scoped EJB client context";
    }
    @Override
    public final RuntimeException failedToCreateScopedEjbClientContext(final Exception e) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failedToCreateScopedEjbClientContext$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void transactionRecoveryMessageNotSupported(final EJBReceiver receiver) {
        super.log.logf(FQCN, WARN, null, transactionRecoveryMessageNotSupported$str(), receiver);
    }
    protected String transactionRecoveryMessageNotSupported$str() {
        return "EJBCLIENT000061: Cannot send a transaction recovery message to the server since the protocol version of EJBReceiver %s doesn't support it";
    }
    protected String lookupFailed$str() {
        return "EJBCLIENT000062: Failed to look up \"%s\"";
    }
    @Override
    public final CommunicationException lookupFailed(final Name resolvedName, final Name name, final Exception e) {
        final CommunicationException result = new CommunicationException(String.format(getLoggingLocale(), lookupFailed$str(), name));
        result.initCause(e);
        _copyStackTraceMinusOne(result);
        result.setResolvedName(resolvedName);
        return result;
    }
    protected String ejbIsAlreadyStateful$str() {
        return "EJBCLIENT000063: EJB proxy is already stateful";
    }
    @Override
    public final IllegalArgumentException ejbIsAlreadyStateful() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), ejbIsAlreadyStateful$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void ejbURLContextFactoryDeprecated() {
        super.log.logf(FQCN, INFO, null, ejbURLContextFactoryDeprecated$str());
    }
    protected String ejbURLContextFactoryDeprecated$str() {
        return "EJBCLIENT000064: org.jboss.ejb.client.naming.ejb.ejbURLContextFactory is deprecated; new applications should use org.wildfly.naming.client.WildFlyInitialContextFactory instead";
    }
    protected String nullSessionCreated$str() {
        return "EJBCLIENT000065: Null session was created for \"%s\", affinity %s, identifier %s";
    }
    @Override
    public final CommunicationException nullSessionCreated(final Name resolvedName, final Name name, final Affinity affinity, final EJBIdentifier identifier) {
        final CommunicationException result = new CommunicationException(String.format(getLoggingLocale(), nullSessionCreated$str(), name, affinity, identifier));
        _copyStackTraceMinusOne(result);
        result.setResolvedName(resolvedName);
        return result;
    }
    protected String operationInterrupted$str() {
        return "EJBCLIENT000066: Operation interrupted";
    }
    @Override
    public final EJBException operationInterrupted() {
        final EJBException result = new EJBException(String.format(getLoggingLocale(), operationInterrupted$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotConvertToStateful$str() {
        return "EJBCLIENT000067: Cannot convert %s to stateful";
    }
    @Override
    public final IllegalArgumentException cannotConvertToStateful(final EJBLocator<?> locator) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotConvertToStateful$str(), locator));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotInstantiateCallbackHandler$str() {
        return "EJBCLIENT000068: Failed to instantiate callback handler class \"%s\"";
    }
    @Override
    public final IllegalArgumentException cannotInstantiateCallbackHandler(final String name, final ReflectiveOperationException e) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotInstantiateCallbackHandler$str(), name), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void legacyEJBPropertiesSecurityConfigurationInUse() {
        if (super.log.isEnabled(INFO) && legacyEJBPropertiesSecurityConfigurationInUse_$Once.compareAndSet(false, true)) {
            super.log.logf(FQCN, INFO, null, legacyEJBPropertiesSecurityConfigurationInUse$str());
        }
    }
    protected String legacyEJBPropertiesSecurityConfigurationInUse$str() {
        return "EJBCLIENT000069: Using legacy jboss-ejb-client.properties security configuration";
    }
    private static final AtomicBoolean legacyEJBPropertiesSecurityConfigurationInUse_$Once = new AtomicBoolean(false);
    @Override
    public final void legacyEJBPropertiesRemotingConfigurationInUse() {
        if (super.log.isEnabled(INFO) && legacyEJBPropertiesRemotingConfigurationInUse_$Once.compareAndSet(false, true)) {
            super.log.logf(FQCN, INFO, null, legacyEJBPropertiesRemotingConfigurationInUse$str());
        }
    }
    protected String legacyEJBPropertiesRemotingConfigurationInUse$str() {
        return "EJBCLIENT000070: Using legacy jboss-ejb-client.properties Remoting configuration";
    }
    private static final AtomicBoolean legacyEJBPropertiesRemotingConfigurationInUse_$Once = new AtomicBoolean(false);
    @Override
    public final void legacyEJBPropertiesDiscoveryConfigurationInUse() {
        if (super.log.isEnabled(INFO) && legacyEJBPropertiesDiscoveryConfigurationInUse_$Once.compareAndSet(false, true)) {
            super.log.logf(FQCN, INFO, null, legacyEJBPropertiesDiscoveryConfigurationInUse$str());
        }
    }
    protected String legacyEJBPropertiesDiscoveryConfigurationInUse$str() {
        return "EJBCLIENT000071: Using legacy jboss-ejb-client.properties discovery configuration";
    }
    private static final AtomicBoolean legacyEJBPropertiesDiscoveryConfigurationInUse_$Once = new AtomicBoolean(false);
    @Override
    public final void legacyEJBPropertiesEJBConfigurationInUse() {
        if (super.log.isEnabled(INFO) && legacyEJBPropertiesEJBConfigurationInUse_$Once.compareAndSet(false, true)) {
            super.log.logf(FQCN, INFO, null, legacyEJBPropertiesEJBConfigurationInUse$str());
        }
    }
    protected String legacyEJBPropertiesEJBConfigurationInUse$str() {
        return "EJBCLIENT000072: Using legacy jboss-ejb-client.properties EJB client configuration";
    }
    private static final AtomicBoolean legacyEJBPropertiesEJBConfigurationInUse_$Once = new AtomicBoolean(false);
    protected String failedToConstructEndpoint$str() {
        return "EJBCLIENT000073: Failed to construct Remoting endpoint";
    }
    @Override
    public final IllegalStateException failedToConstructEndpoint(final IOException e) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), failedToConstructEndpoint$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String selectorReturnedNull$str() {
        return "EJBCLIENT000074: Configured selector \"%s\" returned null";
    }
    @Override
    public final IllegalStateException selectorReturnedNull(final Object selector) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), selectorReturnedNull$str(), selector));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noTransportProvider$str() {
        return "EJBCLIENT000075: No transport provider available for URI scheme %2$s for locator %1$s";
    }
    @Override
    public final NoSuchEJBException noTransportProvider(final EJBLocator<?> locator, final String scheme) {
        final NoSuchEJBException result = new NoSuchEJBException(String.format(getLoggingLocale(), noTransportProvider$str(), locator, scheme));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String selectorReturnedUnknownNode$str() {
        return "EJBCLIENT000076: Configured selector \"%s\" returned unknown node \"%s\"";
    }
    @Override
    public final IllegalStateException selectorReturnedUnknownNode(final Object selector, final String nodeName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), selectorReturnedUnknownNode$str(), selector, nodeName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullSessionID$str() {
        return "EJBCLIENT000077: EJB receiver \"%s\" returned a null session ID for EJB \"%s\"";
    }
    @Override
    public final IllegalArgumentException nullSessionID(final EJBReceiver receiver, final StatelessEJBLocator<?> statelessLocator) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullSessionID$str(), receiver, statelessLocator));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String viewTypeMismatch$str() {
        return "EJBCLIENT000078: EJB receiver \"%s\" returned a stateful locator with the wrong view type (expected %s, but actual was %s)";
    }
    @Override
    public final IllegalArgumentException viewTypeMismatch(final EJBReceiver receiver, final Class<?> expectedType, final Class<?> actualType) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), viewTypeMismatch$str(), receiver, expectedType, actualType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noDestinationEstablished$str() {
        return "EJBCLIENT000079: Unable to discover destination for request for EJB %s";
    }
    @Override
    public final NoSuchEJBException noDestinationEstablished(final EJBLocator<?> locator) {
        final NoSuchEJBException result = new NoSuchEJBException(String.format(getLoggingLocale(), noDestinationEstablished$str(), locator));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String requestNotSent$str() {
        return "EJBCLIENT000080: Request not sent";
    }
    @Override
    public final IllegalStateException requestNotSent() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), requestNotSent$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotInstantiateClustertNodeSelector$str() {
        return "EJBCLIENT000081: Failed to instantiate cluster node selector class \"%s\"";
    }
    @Override
    public final IllegalArgumentException cannotInstantiateClustertNodeSelector(final String name, final ReflectiveOperationException e) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotInstantiateClustertNodeSelector$str(), name), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String outflowTransactionTimeoutElapsed$str() {
        return "EJBCLIENT000082: Cannot outflow the remote transaction \"%s\" as its timeout elapsed";
    }
    @Override
    public final SystemException outflowTransactionTimeoutElapsed(final Transaction transaction) {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), outflowTransactionTimeoutElapsed$str(), transaction));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownProxy$str() {
        return "EJBCLIENT000100: Object '%s' is not a valid proxy object";
    }
    @Override
    public final IllegalArgumentException unknownProxy(final Object proxy) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownProxy$str(), proxy));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String proxyNotOurs$str() {
        return "EJBCLIENT000101: Proxy object '%s' was not generated by %s";
    }
    @Override
    public final IllegalArgumentException proxyNotOurs(final Object proxy, final String className) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), proxyNotOurs$str(), proxy, className));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noAsyncInProgress$str() {
        return "EJBCLIENT000102: No asynchronous operation in progress";
    }
    @Override
    public final IllegalStateException noAsyncInProgress() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noAsyncInProgress$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noJBossModules$str() {
        return "EJBCLIENT000200: Cannot load from a module when jboss-modules is not available";
    }
    @Override
    public final ConfigXMLParseException noJBossModules(final ConfigurationXMLStreamReader streamReader) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), noJBossModules$str()), streamReader);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noInterceptorConstructor$str() {
        return "EJBCLIENT000300: No valid no-argument constructor on interceptor %s";
    }
    @Override
    public final IllegalArgumentException noInterceptorConstructor(final Class<?> type) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noInterceptorConstructor$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String interceptorConstructorNotAccessible$str() {
        return "EJBCLIENT000301: Constructor is not accessible on interceptor %s";
    }
    @Override
    public final IllegalArgumentException interceptorConstructorNotAccessible(final Class<?> type) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), interceptorConstructorNotAccessible$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String interceptorConstructorFailed$str() {
        return "EJBCLIENT000302: Construction of interceptor %s failed";
    }
    @Override
    public final IllegalStateException interceptorConstructorFailed(final Class<?> type, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), interceptorConstructorFailed$str(), type), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String remoteInvFailed$str() {
        return "EJBCLIENT000400: Remote invocation failed due to an exception";
    }
    @Override
    public final ExecutionException remoteInvFailed(final Throwable cause) {
        final ExecutionException result = new ExecutionException(String.format(getLoggingLocale(), remoteInvFailed$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String oneWayInvocation$str() {
        return "EJBCLIENT000401: Result was discarded (one-way invocation)";
    }
    @Override
    public final IllegalStateException oneWayInvocation() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), oneWayInvocation$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String requestCancelled$str() {
        return "EJBCLIENT000402: Remote invocation request was cancelled";
    }
    @Override
    public final CancellationException requestCancelled() {
        final CancellationException result = new CancellationException(String.format(getLoggingLocale(), requestCancelled$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String timedOut$str() {
        return "EJBCLIENT000403: Timed out";
    }
    @Override
    public final TimeoutException timedOut() {
        final TimeoutException result = new TimeoutException(String.format(getLoggingLocale(), timedOut$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String transactionNoLongerActive$str() {
        return "EJBCLIENT000408: Inflowed transaction is no longer active";
    }
    @Override
    public final SystemException transactionNoLongerActive() {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), transactionNoLongerActive$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noMoreDestinations$str() {
        return "EJBCLIENT000409: No more destinations are available";
    }
    @Override
    public final RequestSendFailedException noMoreDestinations() {
        final RequestSendFailedException result = new RequestSendFailedException(String.format(getLoggingLocale(), noMoreDestinations$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mismatchedMethodLocation$str() {
        return "EJBCLIENT000500: Protocol error: mismatched method location";
    }
    @Override
    public final InvalidObjectException mismatchedMethodLocation() {
        final InvalidObjectException result = new InvalidObjectException(String.format(getLoggingLocale(), mismatchedMethodLocation$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void invalidMessageReceived(final int code) {
        super.log.logf(FQCN, DEBUG, null, invalidMessageReceived$str(), code);
    }
    protected String invalidMessageReceived$str() {
        return "EJBCLIENT000501: Protocol error: invalid message ID %02x received";
    }
    protected String invalidTransactionType$str() {
        return "EJBCLIENT000502: Protocol error: invalid transaction type %02x received";
    }
    @Override
    public final IOException invalidTransactionType(final int type) {
        final IOException result = new IOException(String.format(getLoggingLocale(), invalidTransactionType$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToInflowTxn$str() {
        return "EJBCLIENT000503: Protocol error: unable to inflow remote transaction";
    }
    @Override
    public final IOException unableToInflowTxn(final Exception e) {
        final IOException result = new IOException(String.format(getLoggingLocale(), unableToInflowTxn$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noSessionCreated$str() {
        return "EJBCLIENT000504: Server error: no session was created";
    }
    @Override
    public final IllegalStateException noSessionCreated() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noSessionCreated$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noRemoteTransportOnEJBContext$str() {
        return "EJBCLIENT000505: No remote transport is present on the current EJB client context";
    }
    @Override
    public final IllegalStateException noRemoteTransportOnEJBContext() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noRemoteTransportOnEJBContext$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidViewTypeForInvocation$str() {
        return "EJBCLIENT000506: Server error (invalid view): %s";
    }
    @Override
    public final EJBException invalidViewTypeForInvocation(final String serverMessage) {
        final EJBException result = new EJBException(String.format(getLoggingLocale(), invalidViewTypeForInvocation$str(), serverMessage));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String internalSystemErrorWithTx$str() {
        return "EJBCLIENT000507: Internal server error occurred while processing a transaction";
    }
    @Override
    public final SystemException internalSystemErrorWithTx(final Throwable t) {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), internalSystemErrorWithTx$str()));
        result.initCause(t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void taskFailed(final Runnable runnable, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, taskFailed$str(), runnable);
    }
    protected String taskFailed$str() {
        return "EJBCLIENT000508: Failed to execute Runnable %s";
    }
    @Override
    public final void unexpectedException(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unexpectedException$str());
    }
    protected String unexpectedException$str() {
        return "EJBCLIENT000509: Unexpected exception processing EJB request";
    }
    protected String failedToConfigureSslContext$str() {
        return "EJBCLIENT000510: Failed to configure SSL context";
    }
    @Override
    public final IOException failedToConfigureSslContext(final Throwable cause) {
        final IOException result = new IOException(String.format(getLoggingLocale(), failedToConfigureSslContext$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotAddSessionID$str() {
        return "EJBCLIENT000511: Cannot automatically convert stateless EJB to stateful with this protocol version";
    }
    @Override
    public final IllegalArgumentException cannotAddSessionID() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotAddSessionID$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ejbNotStateful$str() {
        return "EJBCLIENT000512: Server error (remote EJB is not stateful): %s";
    }
    @Override
    public final EJBException ejbNotStateful(final String serverMessage) {
        final EJBException result = new EJBException(String.format(getLoggingLocale(), ejbNotStateful$str(), serverMessage));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void exceptionDuringTransportProviderClose(final Exception e) {
        super.log.logf(FQCN, ERROR, e, exceptionDuringTransportProviderClose$str());
    }
    protected String exceptionDuringTransportProviderClose$str() {
        return "EJBCLIENT000513: Exception occurred when trying to close the transport provider";
    }
    @Override
    public final void skippingHttpConnectionCreationDueToMissingUri(final String name) {
        super.log.logf(FQCN, INFO, null, skippingHttpConnectionCreationDueToMissingUri$str(), name);
    }
    protected String skippingHttpConnectionCreationDueToMissingUri$str() {
        return "EJBCLIENT000514: No URI configured for HTTP connection named %s. Skipping connection creation";
    }
    @Override
    public final void skippingHttpConnectionCreationDueToInvalidUri(final String uri) {
        super.log.logf(FQCN, INFO, null, skippingHttpConnectionCreationDueToInvalidUri$str(), uri);
    }
    protected String skippingHttpConnectionCreationDueToInvalidUri$str() {
        return "EJBCLIENT000515: HTTP connection was configured with invalid URI: %s .";
    }
    protected String cannotResolveFilteredClass$str() {
        return "EJBCLIENT000516: Exception resolving class %s for unmarshalling; it has either been blocklisted or not allowlisted";
    }
    @Override
    public final InvalidClassException cannotResolveFilteredClass(final String clazz) {
        final InvalidClassException result = new InvalidClassException(String.format(getLoggingLocale(), cannotResolveFilteredClass$str(), clazz));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void ioExceptionOnTransactionResponseWrite(final int invId, final Channel channel, final IOException e) {
        super.log.logf(FQCN, WARN, e, ioExceptionOnTransactionResponseWrite$str(), invId, channel);
    }
    protected String ioExceptionOnTransactionResponseWrite$str() {
        return "EJBCLIENT000517: Exception occurred when writing EJB transaction response to invocation %s over channel %s";
    }
    @Override
    public final void ioExceptionOnTransactionRecoveryResponseWrite(final int invId, final Channel channel, final IOException e) {
        super.log.logf(FQCN, WARN, e, ioExceptionOnTransactionRecoveryResponseWrite$str(), invId, channel);
    }
    protected String ioExceptionOnTransactionRecoveryResponseWrite$str() {
        return "EJBCLIENT000518: Exception occurred when writing EJB transaction recovery response for invocation %s over channel %s";
    }
    @Override
    public final void ioExceptionOnEJBResponseWrite(final int invId, final Channel channel, final IOException e) {
        super.log.logf(FQCN, WARN, e, ioExceptionOnEJBResponseWrite$str(), invId, channel);
    }
    protected String ioExceptionOnEJBResponseWrite$str() {
        return "EJBCLIENT000519: Exception occurred when writing EJB response to invocation %s over channel %s";
    }
    @Override
    public final void ioExceptionOnEJBSessionOpenResponseWrite(final int invId, final Channel channel, final IOException e) {
        super.log.logf(FQCN, WARN, e, ioExceptionOnEJBSessionOpenResponseWrite$str(), invId, channel);
    }
    protected String ioExceptionOnEJBSessionOpenResponseWrite$str() {
        return "EJBCLIENT000520: Exception occurred when writing EJB session open response to invocation %s over channel %s";
    }
    @Override
    public final void ioExceptionOnProceedAsyncResponseWrite(final int invId, final Channel channel, final IOException e) {
        super.log.logf(FQCN, WARN, e, ioExceptionOnProceedAsyncResponseWrite$str(), invId, channel);
    }
    protected String ioExceptionOnProceedAsyncResponseWrite$str() {
        return "EJBCLIENT000521: Exception occurred when writing proceed async response to invocation %s over channel %s";
    }
    @Override
    public final void ioExceptionOnEJBClusterMessageWrite(final Channel channel, final IOException e) {
        super.log.logf(FQCN, WARN, e, ioExceptionOnEJBClusterMessageWrite$str(), channel);
    }
    protected String ioExceptionOnEJBClusterMessageWrite$str() {
        return "EJBCLIENT000522: Exception occurred when writing EJB cluster message to channel %s";
    }
    @Override
    public final void ioExceptionOnModuleAvailabilityWrite(final Channel channel, final IOException e) {
        super.log.logf(FQCN, WARN, e, ioExceptionOnModuleAvailabilityWrite$str(), channel);
    }
    protected String ioExceptionOnModuleAvailabilityWrite$str() {
        return "EJBCLIENT000523: Exception occurred when writing module availability message, closing channel %s";
    }
    protected String remoteMessageNoSuchEJB$str() {
        return "No such EJB: %s";
    }
    @Override
    public final String remoteMessageNoSuchEJB(final EJBIdentifier ejbIdentifier) {
        return String.format(getLoggingLocale(), remoteMessageNoSuchEJB$str(), ejbIdentifier);
    }
    protected String remoteMessageEJBNotStateful$str() {
        return "EJB is not stateful: %s";
    }
    @Override
    public final String remoteMessageEJBNotStateful(final EJBIdentifier ejbIdentifier) {
        return String.format(getLoggingLocale(), remoteMessageEJBNotStateful$str(), ejbIdentifier);
    }
    protected String remoteMessageNoSuchMethod$str() {
        return "No such EJB method %s found on %s";
    }
    @Override
    public final String remoteMessageNoSuchMethod(final EJBMethodLocator methodLocator, final EJBIdentifier ejbIdentifier) {
        return String.format(getLoggingLocale(), remoteMessageNoSuchMethod$str(), methodLocator, ejbIdentifier);
    }
    protected String remoteMessageSessionNotActive$str() {
        return "Session is not active for invocation of method %s on %s";
    }
    @Override
    public final String remoteMessageSessionNotActive(final EJBMethodLocator methodLocator, final EJBIdentifier locator) {
        return String.format(getLoggingLocale(), remoteMessageSessionNotActive$str(), methodLocator, locator);
    }
    protected String remoteMessageBadViewType$str() {
        return "EJB view is not remote: %s";
    }
    @Override
    public final String remoteMessageBadViewType(final EJBIdentifier ejbIdentifier) {
        return String.format(getLoggingLocale(), remoteMessageBadViewType$str(), ejbIdentifier);
    }
    protected String returnedContextDataKeyOfWrongType$str() {
        return "Context data under org.jboss.private.data was not of type Set<String>";
    }
    @Override
    public final IllegalStateException returnedContextDataKeyOfWrongType() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), returnedContextDataKeyOfWrongType$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void javaeeToJakartaeeBackwardCompatibilityLayerInstalled() {
        super.log.logf(FQCN, DEBUG, null, javaeeToJakartaeeBackwardCompatibilityLayerInstalled$str());
    }
    protected String javaeeToJakartaeeBackwardCompatibilityLayerInstalled$str() {
        return "EJBCLIENT000524: JavaEE to JakartaEE backward compatibility layer have been installed";
    }
    protected String channelTimeoutOrClosed$str() {
        return "IO channel timed out or closed. Check server endpoint read or write timeout settings";
    }
    @Override
    public final EJBException channelTimeoutOrClosed(final Exception cause) {
        final EJBException result = new EJBException(String.format(getLoggingLocale(), channelTimeoutOrClosed$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
}
