/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2017 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.ejb.client.test.byteman;

import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.EJBClient;
import org.jboss.ejb.client.StatelessEJBLocator;
import org.jboss.ejb.client.legacy.JBossEJBProperties;
import org.jboss.ejb.client.test.AbstractEJBClientTestCase;
import org.jboss.ejb.client.test.ClassCallback;
import org.jboss.ejb.client.test.common.Echo;
import org.jboss.ejb.client.test.common.Result;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

import java.lang.reflect.Method;

/**
 * Tests basic features of proxies for invocation of a bean deployed on a single server node.
 *
 * The server environment consists of two singleton nodes:
 * on node1: beans StatefulEchoBean, StatelessEchoBean are deployed, non-clustered
 * on node2: beans StatefulEchoBean, StatelessEchoBean are deployed, non-clustered
 *
 * @author <a href="mailto:rachmato@redhat.com">Richard Achmatowicz</a>
 */
//@RunWith(BMUnitRunner.class)
//@BMScript(dir="target/test-classes")
public class DiscoveryDeadlockTestCase extends AbstractEJBClientTestCase {

//    private static final Logger logger = Logger.getLogger(DiscoveryDeadlockTestCase.class);
//    private static final String PROPERTIES_FILE = "jboss-ejb-client.properties";
//
//    public static Object discoveryAttempt;
//
//    /**
//     * Do any general setup here
//     * @throws Exception on errors
//     */
//    @BeforeClass
//    public static void beforeClass() throws Exception {
//        // trigger the static init of the correct properties file - this also depends on running in forkMode=always
//        JBossEJBProperties ejbProperties = JBossEJBProperties.fromClassPath(DiscoveryDeadlockTestCase.class.getClassLoader(), PROPERTIES_FILE);
//        JBossEJBProperties.getContextManager().setGlobalDefault(ejbProperties);
//
//        // Launch callback if needed
//        ClassCallback.beforeClassCallback();
//
//        // reset DISCOVERY_ADDITIONAL_TIMEOUT system property for slower machines
//        System.setProperty("org.jboss.ejb.client.discovery.additional-node-timeout", "0");
//    }
//
//    /**
//     * Do any test specific setup here
//     */
//    @Before
//    public void beforeTest() throws Exception {
//        startServer(1);
//        deployStateless(1);
//    }
//
//    /**
//     * Test SLSB invocation
//     *
//     * scenario:
//     *   invoked bean available on two targets, node1, node2
//     *   strong affinity is set to Affinity.NONE
//     * expected result:
//     *   the invocation occurs on either node1 or node2
//     */
//    @Test
//    public void testSLSBInvocation() throws Exception{
//        logger.info("=== Testing SLSB invocation ===");
//
//        Affinity expectedStrongAffinity = Affinity.NONE;
//
//        System.setProperty("canceller", "false");
//
//        // create a proxy for SLSB
//        final StatelessEJBLocator<Echo> statelessEJBLocator = StatelessEJBLocator.create(Echo.class, STATELESS_IDENTIFIER, expectedStrongAffinity);
//        Echo proxy = EJBClient.createProxy(statelessEJBLocator);
//        Assert.assertNotNull("Received a null proxy", proxy);
//
//        // invoke on the proxy
//        logger.info("Invoking on proxy...");
//        final String message = "hello!";
//
//        new Thread(){
//            @Override
//            public void run() {
//                proxy.asyncEcho(message);
//            }
//        }.start();
//
//        Thread.sleep(1000);
//        System.out.println("BAJOBONGO DISCOVERY ATTEMPT TO"+discoveryAttempt);
//
//
//        System.setProperty("canceller", "true");
//        Method cancel = discoveryAttempt.getClass().getMethod("cancel");
//        cancel.setAccessible(true);
//        cancel.invoke(discoveryAttempt);
//
//    }
//
//    /**
//      * Do any test-specific tear down here.
//     */
//    @After
//    public void afterTest() {
//        undeployStateless(1);
//        stopServer(1);
//    }
 }
