/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding;

import java.io.InputStream;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.StringTokenizer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSImplementation;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.jboss.logging.Logger;
import org.jboss.util.Classes;
import org.jboss.xb.binding.sunday.unmarshalling.LSInputAdaptor;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.XsdBinderTerminatingErrorHandler;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.Attributes;

public final class Util {
    public static final char HYPHEN_MINUS = '-';
    public static final char FULL_STOP = '.';
    public static final char COLLON = ':';
    public static final char LOW_LINE = '_';
    public static final char MIDDLE_DOT = '\u00b7';
    public static final char GREEK_ANO_TELEIA = '\u0387';
    public static final char ARABIC_END_OF_AYAH = '\u06dd';
    public static final char ARABIC_START_OF_RUB_EL_HIZB = '\u06de';
    private static final Logger log = Logger.getLogger(Util.class);
    private static XSImplementation xsImpl;

    public static String getPrefixedName(QName qName) {
        String result = "";
        if (qName != null) {
            String prefix = qName.getPrefix();
            result = prefix.length() > 0 ? prefix + ':' + qName.getLocalPart() : qName.getLocalPart();
        }
        return result;
    }

    public static String getPrefixedName(QName qName, NamespaceContext nc) {
        String result = "";
        if (qName != null) {
            String ns;
            String prefix = qName.getPrefix();
            result = prefix.length() > 0 ? prefix + ':' + qName.getLocalPart() : ((prefix = nc.getPrefix(ns = qName.getNamespaceURI())) != null && prefix.length() > 0 ? prefix + ':' + qName.getLocalPart() : qName.getLocalPart());
        }
        return result;
    }

    public static String xmlNameToClassName(String name, boolean ignoreLowLine) {
        return XMLNameToJavaIdentifierConverter.PARSER.parse(XMLNameToJavaIdentifierConverter.CLASS_NAME, name, ignoreLowLine);
    }

    public static String xmlNameToFieldName(String name, boolean ignoreLowLine) {
        return XMLNameToJavaIdentifierConverter.PARSER.parse(XMLNameToJavaIdentifierConverter.FIELD_NAME, name, ignoreLowLine);
    }

    public static String xmlNameToGetMethodName(String name, boolean ignoreLowLine) {
        return "get" + Util.xmlNameToClassName(name, ignoreLowLine);
    }

    public static String xmlNameToSetMethodName(String name, boolean ignoreLowLine) {
        return "set" + Util.xmlNameToClassName(name, ignoreLowLine);
    }

    public static String xmlNameToConstantName(String name) {
        return XMLNameToJavaIdentifierConverter.PARSER.parse(XMLNameToJavaIdentifierConverter.CONSTANT_NAME, name, true);
    }

    public static String xmlNamespaceToJavaPackage(String namespace) {
        if (namespace.length() == 0) {
            return namespace;
        }
        char[] src = namespace.toLowerCase().toCharArray();
        char[] dst = new char[namespace.length()];
        int srcInd = 0;
        while (src[srcInd++] != ':') {
        }
        while (src[srcInd] == '/') {
            ++srcInd;
        }
        if (src[srcInd] == 'w' && src[srcInd + 1] == 'w' && src[srcInd + 2] == 'w') {
            srcInd += 4;
        }
        int domainStart = srcInd;
        while (srcInd < src.length && src[srcInd] != '/') {
            ++srcInd;
        }
        int dstInd = 0;
        int start = srcInd - 1;
        int end = srcInd;
        while (true) {
            if (start == domainStart) {
                System.arraycopy(src, start, dst, dstInd, end - start);
                dstInd += end - start;
                break;
            }
            if (src[start] == '.') {
                System.arraycopy(src, start + 1, dst, dstInd, end - start - 1);
                dst[(dstInd += end - start) - 1] = 46;
                end = start;
            }
            --start;
        }
        while (srcInd < src.length) {
            char c;
            if ((c = src[srcInd++]) == '/') {
                if (srcInd >= src.length) continue;
                dst = Util.append(dst, dstInd++, '.');
                if (Character.isJavaIdentifierStart(src[srcInd])) continue;
                dst = Util.append(dst, dstInd++, '_');
                continue;
            }
            if (c == '.') break;
            dst = Util.append(dst, dstInd++, Character.isJavaIdentifierPart(c) ? c : (char)'_');
        }
        return String.valueOf(dst, 0, dstInd);
    }

    public static String xmlNameToClassName(String namespaceUri, String localName, boolean ignoreLowLine) {
        return namespaceUri == null || namespaceUri.length() == 0 ? Util.xmlNameToClassName(localName, ignoreLowLine) : Util.xmlNamespaceToJavaPackage(namespaceUri) + '.' + Util.xmlNameToClassName(localName, ignoreLowLine);
    }

    public static boolean isAttributeType(Class type) {
        return Classes.isPrimitive((Class)type) || type == String.class || type == Date.class;
    }

    public static String getSchemaLocation(Attributes attrs, String nsUri) {
        String location = null;
        String schemaLocation = attrs.getValue("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
        if (schemaLocation != null) {
            StringTokenizer tokenizer = new StringTokenizer(schemaLocation, " \t\n\r");
            while (tokenizer.hasMoreTokens()) {
                String namespace = tokenizer.nextToken();
                if (!namespace.equals(nsUri) || !tokenizer.hasMoreTokens()) continue;
                location = tokenizer.nextToken();
                break;
            }
        }
        return location;
    }

    public static XSModel loadSchema(String xsdURL, SchemaBindingResolver schemaResolver) {
        boolean trace = log.isTraceEnabled();
        long start = System.currentTimeMillis();
        if (trace) {
            log.trace((Object)("loading xsd: " + xsdURL));
        }
        if (xsImpl == null) {
            xsImpl = Util.getXSImplementation();
        }
        XSLoader schemaLoader = xsImpl.createXSLoader(null);
        if (schemaResolver != null) {
            Util.setResourceResolver(schemaLoader, schemaResolver);
        }
        Util.setDOMErrorHandler(schemaLoader);
        XSModel model = schemaLoader.loadURI(xsdURL);
        if (model == null) {
            throw new IllegalArgumentException("Invalid URI for schema: " + xsdURL);
        }
        if (trace) {
            log.trace((Object)("Loaded xsd: " + xsdURL + " in " + (System.currentTimeMillis() - start) + "ms"));
        }
        return model;
    }

    public static XSModel loadSchema(InputStream is, String encoding, SchemaBindingResolver schemaResolver) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"loading xsd from InputStream");
        }
        LSInputAdaptor input = new LSInputAdaptor(is, encoding);
        XSImplementation impl = Util.getXSImplementation();
        XSLoader schemaLoader = impl.createXSLoader(null);
        Util.setDOMErrorHandler(schemaLoader);
        if (schemaResolver != null) {
            Util.setResourceResolver(schemaLoader, schemaResolver);
        }
        return schemaLoader.load((LSInput)input);
    }

    public static XSModel loadSchema(Reader reader, String encoding, SchemaBindingResolver schemaResolver) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"loading xsd from Reader");
        }
        LSInputAdaptor input = new LSInputAdaptor(reader, encoding);
        XSImplementation impl = Util.getXSImplementation();
        XSLoader schemaLoader = impl.createXSLoader(null);
        Util.setDOMErrorHandler(schemaLoader);
        if (schemaResolver != null) {
            Util.setResourceResolver(schemaLoader, schemaResolver);
        }
        return schemaLoader.load((LSInput)input);
    }

    public static XSModel loadSchema(String data, String encoding) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"loading xsd from string");
        }
        LSInputAdaptor input = new LSInputAdaptor(data, encoding);
        XSImplementation impl = Util.getXSImplementation();
        XSLoader schemaLoader = impl.createXSLoader(null);
        Util.setDOMErrorHandler(schemaLoader);
        return schemaLoader.load((LSInput)input);
    }

    private static char[] append(char[] buf, int index, char ch) {
        if (index >= buf.length) {
            char[] tmp = buf;
            buf = new char[index + 4];
            System.arraycopy(tmp, 0, buf, 0, tmp.length);
        }
        buf[index] = ch;
        return buf;
    }

    private static void setResourceResolver(XSLoader schemaLoader, final SchemaBindingResolver schemaResolver) {
        DOMConfiguration config = schemaLoader.getConfig();
        config.setParameter("resource-resolver", new LSResourceResolver(){

            public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                if ("http://www.w3.org/2001/XMLSchema".equals(type)) {
                    String schemaLocation = systemId;
                    return schemaResolver.resolveAsLSInput(namespaceURI, baseURI, schemaLocation);
                }
                return null;
            }
        });
    }

    private static void setDOMErrorHandler(XSLoader schemaLoader) {
        DOMConfiguration config = schemaLoader.getConfig();
        DOMErrorHandler errorHandler = (DOMErrorHandler)config.getParameter("error-handler");
        if (errorHandler == null) {
            config.setParameter("error-handler", XsdBinderTerminatingErrorHandler.newInstance());
        }
    }

    private static XSImplementation getXSImplementation() {
        return (XSImplementation)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                XSImplementation impl;
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    String name = "org.apache.xerces.dom.DOMXSImplementationSourceImpl";
                    loader.loadClass(name);
                    System.setProperty("org.w3c.dom.DOMImplementationSourceList", name);
                }
                catch (ClassNotFoundException e) {
                    String name = "org.apache.xerces.dom.DOMXSImplementationSourceImpl";
                    System.setProperty("org.w3c.dom.DOMImplementationSourceList", name);
                }
                try {
                    DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
                    impl = (XSImplementation)registry.getDOMImplementation("XS-Loader");
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to create schema loader: " + e.getClass().getName() + " " + e.getMessage());
                }
                return impl;
            }
        });
    }

    static interface XMLNameToJavaIdentifierConverter {
        public static final byte IGNORE = 0;
        public static final byte APPEND = 1;
        public static final byte APPEND_WITH_LOW_LINE = 2;
        public static final byte APPEND_UPPER_CASED = 3;
        public static final byte APPEND_UPPER_CASED_WITH_LOW_LINE = 4;
        public static final XMLNameToJavaIdentifierConverter CLASS_NAME = new XMLNameToJavaIdentifierConverter(){

            public char firstCharacter(char ch, String str, int secondCharIndex) {
                return Character.toUpperCase(ch);
            }

            public byte commandForNext(char prev, char next, boolean ignoreLowLine) {
                int command = Character.isDigit(next) ? 1 : (next == '_' ? (ignoreLowLine ? 0 : 1) : (Character.isJavaIdentifierPart(next) ? (Character.isJavaIdentifierPart(prev) && !Character.isDigit(prev) ? (prev == '_' ? 3 : 1) : 3) : 0));
                return (byte)command;
            }
        };
        public static final XMLNameToJavaIdentifierConverter FIELD_NAME = new XMLNameToJavaIdentifierConverter(){

            public char firstCharacter(char ch, String str, int secondCharIndex) {
                if (Character.isLowerCase(ch)) {
                    return ch;
                }
                return str.length() > secondCharIndex && Character.isJavaIdentifierPart(str.charAt(secondCharIndex)) && Character.isUpperCase(str.charAt(secondCharIndex)) ? Character.toUpperCase(ch) : Character.toLowerCase(ch);
            }

            public byte commandForNext(char prev, char next, boolean ignoreLowLine) {
                return CLASS_NAME.commandForNext(prev, next, ignoreLowLine);
            }
        };
        public static final XMLNameToJavaIdentifierConverter CONSTANT_NAME = new XMLNameToJavaIdentifierConverter(){

            public char firstCharacter(char ch, String str, int secondCharIndex) {
                return Character.toUpperCase(ch);
            }

            public byte commandForNext(char prev, char next, boolean ignoreLowLine) {
                int command = Character.isDigit(next) ? (Character.isDigit(prev) ? 1 : 4) : (Character.isJavaIdentifierPart(next) ? (Character.isDigit(prev) ? 4 : (Character.isJavaIdentifierPart(prev) ? (Character.isUpperCase(next) ? (Character.isUpperCase(prev) ? 3 : 2) : 3) : 4)) : 0);
                return (byte)command;
            }
        };

        public byte commandForNext(char var1, char var2, boolean var3);

        public char firstCharacter(char var1, String var2, int var3);

        public static final class PARSER {
            static String parse(XMLNameToJavaIdentifierConverter converter, String xmlName, boolean ignoreLowLine) {
                if (xmlName == null || xmlName.length() == 0) {
                    throw new IllegalArgumentException("Bad XML name: " + xmlName);
                }
                char c = xmlName.charAt(0);
                int i = 1;
                if (!Character.isJavaIdentifierStart(c) || c == '_' && ignoreLowLine) {
                    while (i < xmlName.length() && (!Character.isJavaIdentifierStart(c = xmlName.charAt(i++)) || c == '_' && ignoreLowLine)) {
                    }
                    if (i == xmlName.length()) {
                        throw new IllegalArgumentException("XML name contains no valid character to start Java identifier: " + xmlName);
                    }
                }
                char[] buf = new char[xmlName.length() - i + 1];
                buf[0] = converter.firstCharacter(c, xmlName, i);
                int bufInd = 1;
                block8: while (i < xmlName.length()) {
                    char prev = c;
                    c = xmlName.charAt(i++);
                    byte command = converter.commandForNext(prev, c, ignoreLowLine);
                    switch (command) {
                        case 0: {
                            continue block8;
                        }
                        case 1: {
                            buf = Util.append(buf, bufInd++, c);
                            continue block8;
                        }
                        case 2: {
                            buf = Util.append(buf, bufInd++, '_');
                            buf = Util.append(buf, bufInd++, c);
                            continue block8;
                        }
                        case 3: {
                            buf = Util.append(buf, bufInd++, Character.toUpperCase(c));
                            continue block8;
                        }
                        case 4: {
                            buf = Util.append(buf, bufInd++, '_');
                            buf = Util.append(buf, bufInd++, Character.toUpperCase(c));
                            continue block8;
                        }
                    }
                    throw new IllegalArgumentException("Unexpected command: " + command);
                }
                return new String(buf, 0, bufInd);
            }
        }
    }
}

