/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.builder.runtime;

import java.util.Collection;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultElementHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ValueAdapter;
import org.jboss.xb.builder.runtime.AbstractPropertyHandler;
import org.jboss.xb.builder.runtime.ArrayWrapper;
import org.jboss.xb.builder.runtime.BuilderUtil;
import org.jboss.xb.builder.runtime.CollectionPropertyHandler;
import org.jboss.xb.spi.BeanAdapter;
import org.jboss.xb.spi.BeanAdapterFactory;
import org.xml.sax.Attributes;

public class BeanHandler
extends DefaultElementHandler {
    private final Logger log = Logger.getLogger(this.getClass());
    private boolean trace = this.log.isTraceEnabled();
    private String name;
    private BeanAdapterFactory beanAdapterFactory;

    public BeanHandler(String name, BeanAdapterFactory beanAdapterFactory) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (beanAdapterFactory == null) {
            throw new IllegalArgumentException("Null bean adapter factory");
        }
        this.name = name;
        this.beanAdapterFactory = beanAdapterFactory;
    }

    public BeanAdapterFactory getBeanAdapterFactory() {
        return this.beanAdapterFactory;
    }

    public Object startParticle(Object parent, QName elementName, ParticleBinding particle, Attributes attrs, NamespaceContext nsCtx) {
        if (this.trace) {
            this.log.trace((Object)(" startElement " + elementName + " bean=" + this.name + " parent=" + BuilderUtil.toDebugString(parent)));
        }
        BeanAdapter o = null;
        try {
            o = this.beanAdapterFactory.newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException("QName " + elementName + " error invoking beanAdapterFactory.newInstance() for bean=" + this.name, t);
        }
        if (o != null && particle.getTerm().isElement()) {
            ElementBinding element = (ElementBinding)particle.getTerm();
            attrs = element.getType().expandWithDefaultAttributes(attrs);
            this.attributes(o, elementName, element, attrs, nsCtx);
        }
        return o;
    }

    public void setParent(Object parent, Object o, QName qName, ParticleBinding particle, ParticleBinding parentParticle) {
        if (this.trace) {
            this.log.trace((Object)("setParent " + qName + " parent=" + BuilderUtil.toDebugString(parent) + " child=" + BuilderUtil.toDebugString(o)));
        }
        TermBinding term = particle.getTerm();
        ValueAdapter valueAdapter = null;
        if (term.isModelGroup()) {
            QName modelGroupName = ((ModelGroupBinding)term).getQName();
            if (modelGroupName != null) {
                qName = modelGroupName;
            }
        } else if (term.isElement()) {
            valueAdapter = ((ElementBinding)term).getValueAdapter();
        }
        if (parent != null && parent instanceof ArrayWrapper) {
            ArrayWrapper wrapper = (ArrayWrapper)parent;
            wrapper.add(o);
            wrapper.setChildParticle(particle);
            wrapper.setParentParticle(parentParticle);
            return;
        }
        BeanAdapter beanAdapter = parent instanceof ArrayWrapper ? (BeanAdapter)((ArrayWrapper)parent).getParent() : (BeanAdapter)parent;
        AbstractPropertyHandler propertyHandler = beanAdapter.getPropertyHandler(qName);
        if (propertyHandler == null) {
            AbstractPropertyHandler wildcardHandler = beanAdapter.getWildcardHandler();
            if (wildcardHandler != null && o != null && o instanceof ArrayWrapper) {
                ArrayWrapper wrapper = (ArrayWrapper)o;
                wildcardHandler.doHandle(beanAdapter, wrapper, wrapper.getElementName());
                return;
            }
            TermBinding element = term;
            if (element.getSchema().isStrictSchema()) {
                throw new RuntimeException("QName " + qName + " unknown property parent=" + BuilderUtil.toDebugString(parent) + " child=" + BuilderUtil.toDebugString(o) + " available=" + beanAdapter.getAvailable());
            }
            if (this.trace) {
                this.log.trace((Object)("QName " + qName + " unknown property parent=" + BuilderUtil.toDebugString(parent) + " child=" + BuilderUtil.toDebugString(o)));
            }
            return;
        }
        if (particle.isRepeatable() && propertyHandler instanceof CollectionPropertyHandler) {
            for (Object item : (Collection)o) {
                if (valueAdapter != null) {
                    item = valueAdapter.cast(item, null);
                }
                propertyHandler.doHandle(beanAdapter, item, qName);
            }
        } else {
            if (valueAdapter != null) {
                o = valueAdapter.cast(o, null);
            }
            propertyHandler.doHandle(beanAdapter, o, qName);
        }
    }

    public Object endParticle(Object o, QName qName, ParticleBinding particle) {
        if (this.trace) {
            this.log.trace((Object)("endElement " + qName + " o=" + BuilderUtil.toDebugString(o)));
        }
        BeanAdapter beanAdapter = (BeanAdapter)o;
        return beanAdapter.getValue();
    }
}

