/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.builder.runtime;

import javax.xml.namespace.QName;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.logging.Logger;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.builder.runtime.BuilderUtil;
import org.jboss.xb.spi.BeanAdapter;

public class ValueHandler
extends CharactersHandler {
    private final Logger log = Logger.getLogger(this.getClass());
    private boolean trace = this.log.isTraceEnabled();
    private PropertyInfo propertyInfo;
    private BeanInfo beanInfo;
    private String property;

    public ValueHandler(PropertyInfo propertyInfo) {
        if (propertyInfo == null) {
            throw new IllegalArgumentException("Null propertyInfo");
        }
        this.propertyInfo = propertyInfo;
    }

    public ValueHandler(PropertyInfo propertyInfo, BeanInfo beanInfo, String property) {
        if (propertyInfo == null) {
            throw new IllegalArgumentException("Null propertyInfo");
        }
        if (beanInfo == null) {
            throw new IllegalArgumentException("Null beanInfo");
        }
        if (property == null) {
            throw new IllegalArgumentException("Null property");
        }
        this.propertyInfo = propertyInfo;
        this.beanInfo = beanInfo;
        this.property = property;
    }

    public PropertyInfo getPropertyInfo() {
        return this.propertyInfo;
    }

    public void setValue(QName qName, ElementBinding element, Object owner, Object value) {
        if (this.trace) {
            this.log.trace((Object)("QName " + qName + " handle " + BuilderUtil.toDebugString(value) + " to " + BuilderUtil.toDebugString(owner)));
        }
        try {
            TypeInfo valueType;
            ClassInfo classInfo;
            TypeInfo typeInfo = this.propertyInfo.getType();
            value = typeInfo.convertValue(value, false);
            if (this.beanInfo != null && !(classInfo = this.beanInfo.getClassInfo()).isAssignableFrom(valueType = classInfo.getTypeInfoFactory().getTypeInfo(value.getClass()))) {
                Object wrapper = this.beanInfo.newInstance();
                this.beanInfo.setProperty(wrapper, this.property, value);
                value = wrapper;
            }
            BeanAdapter beanAdapter = (BeanAdapter)owner;
            beanAdapter.set(this.propertyInfo, value);
        }
        catch (Throwable t) {
            throw new RuntimeException("QName " + qName + " error setting characters " + this.propertyInfo.getName() + " with value " + BuilderUtil.toDebugString(value) + " to " + BuilderUtil.toDebugString(owner) + " property=" + this.propertyInfo.getName(), t);
        }
    }
}

