/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.xb.binding.GenericObjectModelFactory;
import org.jboss.xb.binding.ObjectModelBuilder;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.UnmarshallingContext;
import org.xml.sax.Attributes;

public class DelegatingObjectModelFactory
implements GenericObjectModelFactory {
    private final ObjectModelFactory typedFactory;
    private final Map addMethodsByParent = new HashMap();
    private boolean replaceProps;

    public DelegatingObjectModelFactory(ObjectModelFactory typedFactory) {
        this.typedFactory = typedFactory;
        this.replaceProps = DelegatingObjectModelFactory.isReplacePropertyRefs(typedFactory);
        Method[] methods = typedFactory.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!"addChild".equals(method.getName())) continue;
            Class<?> parent = method.getParameterTypes()[0];
            AddMethods addMethods = (AddMethods)this.addMethodsByParent.get(parent);
            if (addMethods == null) {
                addMethods = new AddMethods(parent);
                this.addMethodsByParent.put(parent, addMethods);
            }
            addMethods.addMethod(method);
        }
    }

    public void startDTD(String name, String publicId, String systemId) {
        try {
            Class[] sig = new Class[]{String.class, String.class, String.class};
            Method startDTD = this.typedFactory.getClass().getMethod("startDTD", sig);
            Object[] args = new Object[]{name, publicId, systemId};
            startDTD.invoke((Object)this.typedFactory, args);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public Object newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        return this.typedFactory.newRoot(root, navigator, namespaceURI, localName, attrs);
    }

    public Object newChild(Object parent, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        Class<?> objClass = parent.getClass();
        Class[] classes = new Class[]{objClass, UnmarshallingContext.class, String.class, String.class, Attributes.class};
        Method method = ObjectModelBuilder.getMethodForElement(this.typedFactory, "newChild", classes);
        while (method == null && objClass.getSuperclass() != Object.class) {
            objClass = objClass.getSuperclass();
            classes = new Class[]{objClass, UnmarshallingContext.class, String.class, String.class, Attributes.class};
            method = ObjectModelBuilder.getMethodForElement(this.typedFactory, "newChild", classes);
        }
        Object child = null;
        if (method != null) {
            Object[] objects = new Object[]{parent, navigator, namespaceURI, localName, attrs};
            child = ObjectModelBuilder.invokeFactory(this.typedFactory, method, objects);
        }
        return child;
    }

    public void addChild(Object parent, Object child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        Method method;
        AddMethods addMethods = (AddMethods)this.addMethodsByParent.get(parent.getClass());
        if (addMethods != null && (method = addMethods.getMethodForChild(child.getClass())) != null) {
            ObjectModelBuilder.invokeFactory(this.typedFactory, method, new Object[]{parent, child, navigator, namespaceURI, localName});
        }
    }

    public void setValue(Object o, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        Class<?> objClass = o.getClass();
        Class[] classes = new Class[]{objClass, UnmarshallingContext.class, String.class, String.class, String.class};
        Method method = ObjectModelBuilder.getMethodForElement(this.typedFactory, "setValue", classes);
        while (method == null && objClass.getSuperclass() != Object.class) {
            objClass = objClass.getSuperclass();
            classes = new Class[]{objClass, UnmarshallingContext.class, String.class, String.class, String.class};
            method = ObjectModelBuilder.getMethodForElement(this.typedFactory, "setValue", classes);
        }
        if (method != null) {
            if (this.replaceProps) {
                value = StringPropertyReplacer.replaceProperties((String)value);
            }
            Object[] objects = new Object[]{o, navigator, namespaceURI, localName, value};
            ObjectModelBuilder.invokeFactory(this.typedFactory, method, objects);
        }
    }

    public Object completeRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName) {
        return root;
    }

    static boolean isReplacePropertyRefs(ObjectModelFactory factory) {
        boolean replace = true;
        try {
            Class[] sig = new Class[]{};
            Method isReplace = factory.getClass().getMethod("isReplacePropertyRefs", sig);
            if (Boolean.class.isAssignableFrom(isReplace.getReturnType())) {
                Object[] args = new Object[]{};
                Boolean flag = (Boolean)isReplace.invoke((Object)factory, args);
                replace = flag;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return replace;
    }

    private static class AddMethods {
        private static final int DEFAULT_METHODS_SIZE = 10;
        public final Class parent;
        private Method[] methods = new Method[10];
        private int totalMethods;

        public AddMethods(Class parent) {
            this.parent = parent;
        }

        public void addMethod(Method m) {
            if (this.totalMethods == this.methods.length) {
                Method[] tmp = this.methods;
                this.methods = new Method[this.methods.length + 10];
                System.arraycopy(tmp, 0, this.methods, 0, tmp.length);
            }
            this.methods[this.totalMethods++] = m;
        }

        public Method getMethodForChild(Class child) {
            Class<?> closestParam = null;
            Method closestMethod = null;
            for (int i = 0; i < this.totalMethods; ++i) {
                Method method = this.methods[i];
                Class<?> param = method.getParameterTypes()[1];
                if (param == child) {
                    return method;
                }
                if (!param.isAssignableFrom(child) || closestParam != null && !closestParam.isAssignableFrom(param)) continue;
                closestParam = param;
                closestMethod = method;
            }
            return closestMethod;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AddMethods)) {
                return false;
            }
            AddMethods addMethods = (AddMethods)o;
            return this.parent.equals(addMethods.parent);
        }

        public int hashCode() {
            return this.parent.hashCode();
        }
    }
}

