/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.builder;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.bind.annotation.XmlAccessOrder;
import javax.xml.bind.annotation.XmlAccessorOrder;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.joinpoint.plugins.Config;
import org.jboss.logging.Logger;
import org.jboss.reflect.plugins.introspection.ParameterizedClassInfo;
import org.jboss.reflect.spi.ArrayInfo;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.EnumInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.PackageInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.TypeInfoFactory;
import org.jboss.xb.annotations.JBossXmlAdaptedType;
import org.jboss.xb.annotations.JBossXmlAdaptedTypes;
import org.jboss.xb.annotations.JBossXmlAttribute;
import org.jboss.xb.annotations.JBossXmlChild;
import org.jboss.xb.annotations.JBossXmlChildWildcard;
import org.jboss.xb.annotations.JBossXmlChildren;
import org.jboss.xb.annotations.JBossXmlCollection;
import org.jboss.xb.annotations.JBossXmlGroup;
import org.jboss.xb.annotations.JBossXmlGroupText;
import org.jboss.xb.annotations.JBossXmlGroupWildcard;
import org.jboss.xb.annotations.JBossXmlMapEntry;
import org.jboss.xb.annotations.JBossXmlMapKeyAttribute;
import org.jboss.xb.annotations.JBossXmlMapKeyElement;
import org.jboss.xb.annotations.JBossXmlMapValueAttribute;
import org.jboss.xb.annotations.JBossXmlMapValueElement;
import org.jboss.xb.annotations.JBossXmlModelGroup;
import org.jboss.xb.annotations.JBossXmlNoElements;
import org.jboss.xb.annotations.JBossXmlNsPrefix;
import org.jboss.xb.annotations.JBossXmlSchema;
import org.jboss.xb.annotations.JBossXmlType;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.jboss.xb.binding.sunday.unmarshalling.AllBinding;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ChoiceBinding;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultElementHandler;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultElementInterceptor;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SequenceBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ValueAdapter;
import org.jboss.xb.binding.sunday.unmarshalling.WildcardBinding;
import org.jboss.xb.builder.JBossXBBuilder;
import org.jboss.xb.builder.runtime.AbstractPropertyHandler;
import org.jboss.xb.builder.runtime.ArraySequenceBinding;
import org.jboss.xb.builder.runtime.BeanHandler;
import org.jboss.xb.builder.runtime.BuilderParticleHandler;
import org.jboss.xb.builder.runtime.BuilderSimpleParticleHandler;
import org.jboss.xb.builder.runtime.ChildCollectionInterceptor;
import org.jboss.xb.builder.runtime.ChildCollectionWildcardHandler;
import org.jboss.xb.builder.runtime.ChildWildcardHandler;
import org.jboss.xb.builder.runtime.CollectionPropertyHandler;
import org.jboss.xb.builder.runtime.CollectionPropertyWildcardHandler;
import org.jboss.xb.builder.runtime.DOMHandler;
import org.jboss.xb.builder.runtime.DefaultMapEntry;
import org.jboss.xb.builder.runtime.EnumValueAdapter;
import org.jboss.xb.builder.runtime.MapPropertyHandler;
import org.jboss.xb.builder.runtime.PropertyHandler;
import org.jboss.xb.builder.runtime.PropertyInterceptor;
import org.jboss.xb.builder.runtime.PropertyWildcardHandler;
import org.jboss.xb.builder.runtime.ValueHandler;
import org.jboss.xb.builder.runtime.WrapperBeanAdapterFactory;
import org.jboss.xb.spi.BeanAdapterBuilder;
import org.jboss.xb.spi.BeanAdapterFactory;
import org.jboss.xb.spi.DefaultBeanAdapterBuilder;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossXBNoSchemaBuilder {
    private static final Logger log = Logger.getLogger(JBossXBBuilder.class);
    private boolean trace = log.isTraceEnabled();
    private SchemaBinding schemaBinding;
    private ClassInfo root;
    private String defaultNamespace;
    private XmlNsForm attributeForm = XmlNsForm.UNSET;
    private XmlNsForm elementForm = XmlNsForm.UNSET;
    private Map<TypeInfo, TypeBinding> typeCache = new HashMap<TypeInfo, TypeBinding>();
    private Map<TypeInfo, ElementBinding> rootCache = new HashMap<TypeInfo, ElementBinding>();
    private Stack<Location> locations = new Stack();

    public JBossXBNoSchemaBuilder(ClassInfo root) {
        if (root == null) {
            throw new IllegalArgumentException("Null root");
        }
        this.root = root;
    }

    public SchemaBinding build() {
        this.initSchema();
        this.createRootElements();
        return this.schemaBinding;
    }

    protected void initSchema() {
        PackageInfo packageInfo;
        JBossXmlSchema jbossXmlSchema;
        this.schemaBinding = new SchemaBinding();
        JBossXBBuilder.initSchema(this.schemaBinding, this.root);
        if (this.trace) {
            log.trace((Object)("Building schema for " + this.root.getName() + " schemaBinding=" + this.schemaBinding));
        }
        if (this.defaultNamespace == null) {
            this.defaultNamespace = (String)this.schemaBinding.getNamespaces().iterator().next();
        }
        if ((jbossXmlSchema = (JBossXmlSchema)this.root.getUnderlyingAnnotation(JBossXmlSchema.class)) != null) {
            this.attributeForm = jbossXmlSchema.attributeFormDefault();
            this.elementForm = jbossXmlSchema.elementFormDefault();
        }
        if ((packageInfo = this.root.getPackage()) != null) {
            JBossXmlAdaptedType adaptedType;
            JBossXmlAdaptedTypes adaptedTypes;
            XmlSchema xmlSchema;
            jbossXmlSchema = (JBossXmlSchema)this.root.getUnderlyingAnnotation(JBossXmlSchema.class);
            if (jbossXmlSchema != null) {
                if (this.attributeForm == XmlNsForm.UNSET) {
                    this.attributeForm = jbossXmlSchema.attributeFormDefault();
                }
                if (this.elementForm == XmlNsForm.UNSET) {
                    this.elementForm = jbossXmlSchema.elementFormDefault();
                }
            }
            if ((xmlSchema = (XmlSchema)packageInfo.getUnderlyingAnnotation(XmlSchema.class)) != null) {
                String namespace = xmlSchema.namespace();
                if (!"##default".equals(xmlSchema) && "".equals(this.defaultNamespace)) {
                    this.defaultNamespace = namespace;
                    this.addNamespace(this.defaultNamespace, true);
                }
                if (this.attributeForm == XmlNsForm.UNSET) {
                    this.attributeForm = xmlSchema.attributeFormDefault();
                }
                if (this.elementForm == XmlNsForm.UNSET) {
                    this.elementForm = xmlSchema.elementFormDefault();
                }
            }
            if ((adaptedTypes = (JBossXmlAdaptedTypes)packageInfo.getUnderlyingAnnotation(JBossXmlAdaptedTypes.class)) != null) {
                for (JBossXmlAdaptedType adaptedType2 : adaptedTypes.value()) {
                    this.generateAdaptedType(adaptedType2);
                }
            }
            if ((adaptedType = (JBossXmlAdaptedType)packageInfo.getUnderlyingAnnotation(JBossXmlAdaptedType.class)) != null) {
                this.generateAdaptedType(adaptedType);
            }
        }
    }

    protected void createRootElements() {
        this.createRootElementBinding((TypeInfo)this.root);
    }

    protected void createRootElementBinding(TypeInfo typeInfo) {
        if (this.rootCache.containsKey(typeInfo)) {
            return;
        }
        this.rootCache.put(typeInfo, null);
        this.push(typeInfo);
        try {
            this.createElementBinding(typeInfo, typeInfo.getSimpleName(), true);
            this.pop();
        }
        catch (Exception e) {
            throw this.rethrowWithLocation(e);
        }
    }

    private ElementBinding createElementBinding(TypeInfo typeInfo, String name, boolean root) {
        TypeBinding typeBinding = this.resolveTypeBinding(typeInfo);
        return this.createElementBinding(typeInfo, typeBinding, name, root);
    }

    private ElementBinding createElementBinding(TypeInfo typeInfo, TypeBinding typeBinding, String name, boolean root) {
        ClassInfo classInfo;
        XmlRootElement xmlRootElement;
        String overrideNamespace = null;
        String overrideName = null;
        if (typeInfo instanceof ClassInfo && (xmlRootElement = (XmlRootElement)(classInfo = (ClassInfo)typeInfo).getUnderlyingAnnotation(XmlRootElement.class)) != null) {
            overrideNamespace = xmlRootElement.namespace();
            overrideName = xmlRootElement.name();
        }
        XmlNsForm form = this.elementForm;
        if (root) {
            form = XmlNsForm.QUALIFIED;
        }
        QName qName = this.generateXmlName(name, form, overrideNamespace, overrideName);
        return this.createElementBinding(typeInfo, typeBinding, qName, root);
    }

    private ElementBinding createElementBinding(TypeInfo typeInfo, TypeBinding typeBinding, QName qName, boolean root) {
        ClassInfo classInfo;
        XmlRootElement xmlRootElement;
        if (this.trace) {
            log.trace((Object)("creating element " + qName + " with type " + typeInfo.getName()));
        }
        if (typeInfo instanceof ClassInfo && (xmlRootElement = (XmlRootElement)(classInfo = (ClassInfo)typeInfo).getUnderlyingAnnotation(XmlRootElement.class)) != null) {
            root = true;
        }
        ElementBinding elementBinding = new ElementBinding(this.schemaBinding, qName, typeBinding);
        if (this.trace) {
            log.trace((Object)("created  element " + qName + " element=" + elementBinding + " rootElement=" + root));
        }
        if (root) {
            this.schemaBinding.addElement(elementBinding);
            ParticleBinding particleBinding = this.schemaBinding.getElementParticle(qName);
            particleBinding.setMinOccurs(1);
            particleBinding.setMaxOccurs(1);
            this.rootCache.put(typeInfo, elementBinding);
        }
        return elementBinding;
    }

    protected void process(TypeInfo typeInfo) {
        if (!typeInfo.isPrimitive() && typeInfo.isEnum() && typeInfo.isAnnotation() && !Object.class.getName().equals(typeInfo.getName())) {
            XmlRootElement xmlRootElement;
            ClassInfo classInfo = (ClassInfo)typeInfo;
            this.resolveTypeBinding(typeInfo);
            if (!this.rootCache.containsKey(typeInfo) && (xmlRootElement = (XmlRootElement)classInfo.getUnderlyingAnnotation(XmlRootElement.class)) != null) {
                this.createRootElementBinding(typeInfo);
            }
        }
    }

    protected TypeBinding resolveTypeBinding(TypeInfo typeInfo) {
        TypeBinding result;
        if (this.trace) {
            log.trace((Object)("resolving type " + typeInfo.getName()));
        }
        if ((result = this.typeCache.get(typeInfo)) == null) {
            result = this.generateTypeBinding(typeInfo);
            this.typeCache.put(typeInfo, result);
        }
        if (this.trace) {
            log.trace((Object)("resolved  type " + typeInfo.getName() + " binding=" + result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TypeBinding generateTypeBinding(TypeInfo typeInfo) {
        try {
            if (typeInfo.isEnum()) {
                TypeBinding typeBinding = this.generateEnum((EnumInfo)typeInfo);
                return typeBinding;
            }
            if (typeInfo.isAnnotation()) {
                TypeBinding typeBinding = this.generateAnnotation((ClassInfo)typeInfo);
                return typeBinding;
            }
            if (typeInfo.isArray()) {
                TypeBinding typeBinding = this.generateArray((ArrayInfo)typeInfo);
                return typeBinding;
            }
            if (typeInfo.isCollection()) {
                TypeBinding typeBinding = this.generateCollection((ClassInfo)typeInfo);
                return typeBinding;
            }
            if (typeInfo.isMap()) {
                TypeBinding typeBinding = this.generateMap((ClassInfo)typeInfo);
                return typeBinding;
            }
            TypeBinding typeBinding = this.isSimpleType(typeInfo);
            if (typeBinding != null) {
                TypeBinding typeBinding2 = typeBinding;
                return typeBinding2;
            }
            TypeBinding typeBinding3 = this.generateBean((ClassInfo)typeInfo);
            return typeBinding3;
        }
        finally {
            if (!typeInfo.isPrimitive()) {
                ClassInfo superClass;
                ClassInfo classInfo = (ClassInfo)typeInfo;
                TypeInfo[] typeArgs = classInfo.getActualTypeArguments();
                if (typeArgs != null) {
                    for (int i = 0; i < typeArgs.length; ++i) {
                        this.process(typeArgs[i]);
                    }
                }
                if ((superClass = classInfo.getGenericSuperclass()) != null) {
                    this.process((TypeInfo)superClass);
                }
            }
        }
    }

    public TypeBinding generateEnum(EnumInfo typeInfo) {
        String overrideNamespace = null;
        String overrideName = null;
        boolean root = false;
        XmlType xmlType = (XmlType)typeInfo.getUnderlyingAnnotation(XmlType.class);
        if (xmlType != null) {
            root = true;
            overrideNamespace = xmlType.namespace();
            overrideName = xmlType.name();
        }
        Class xmlEnumValue = String.class;
        XmlEnum xmlEnum = (XmlEnum)typeInfo.getUnderlyingAnnotation(XmlEnum.class);
        if (xmlEnum != null) {
            xmlEnumValue = xmlEnum.value();
        }
        TypeInfo enumType = typeInfo.getTypeInfoFactory().getTypeInfo(xmlEnumValue);
        TypeBinding parent = this.getSimpleType(enumType);
        QName qName = null;
        TypeBinding typeBinding = null;
        if (root) {
            qName = this.generateXmlName((TypeInfo)typeInfo, XmlNsForm.QUALIFIED, overrideNamespace, overrideName);
            typeBinding = new TypeBinding(qName, parent);
        } else {
            typeBinding = new TypeBinding(null, parent);
        }
        typeBinding.setValueAdapter(new EnumValueAdapter(qName, typeInfo, enumType));
        if (this.trace) {
            log.trace((Object)("Created enum=" + typeInfo.getName() + " type=" + typeBinding + " rootType=" + root));
        }
        if (root) {
            this.schemaBinding.addType(typeBinding);
        } else {
            typeBinding.setSchemaBinding(this.schemaBinding);
        }
        return typeBinding;
    }

    public TypeBinding generateAdaptedType(JBossXmlAdaptedType adaptedType) {
        String overrideNamespace = adaptedType.namespace();
        String overrideName = adaptedType.name();
        Class<?> type = adaptedType.type();
        Class<? extends ValueAdapter> adapter = adaptedType.valueAdapter();
        try {
            TypeInfo typeInfo = JBossXBBuilder.configuration.getTypeInfo(type);
            BeanInfo adapterInfo = JBossXBBuilder.configuration.getBeanInfo(adapter);
            ValueAdapter valueAdapter = (ValueAdapter)adapterInfo.newInstance();
            QName qName = this.generateXmlName(typeInfo, XmlNsForm.QUALIFIED, overrideNamespace, overrideName);
            TypeInfo parentType = typeInfo.getTypeInfoFactory().getTypeInfo(String.class);
            TypeBinding parent = this.getSimpleType(parentType);
            TypeBinding typeBinding = new TypeBinding(qName, parent);
            typeBinding.setValueAdapter(valueAdapter);
            if (this.trace) {
                log.trace((Object)("Created adapted type=" + typeInfo.getName() + " typeBinding=" + typeBinding + " adapter=" + adapter.getName()));
            }
            this.typeCache.put(typeInfo, typeBinding);
            this.schemaBinding.addType(typeBinding);
            return typeBinding;
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to adapt type " + type.getName() + " with " + adapter.getName(), t);
        }
    }

    public TypeBinding generateAnnotation(ClassInfo typeInfo) {
        throw new UnsupportedOperationException("generateAnnotation");
    }

    public TypeBinding generateArray(ArrayInfo typeInfo) {
        return this.resolveTypeBinding(typeInfo.getComponentType());
    }

    public TypeBinding generateCollection(ClassInfo typeInfo) {
        if (typeInfo instanceof ParameterizedClassInfo) {
            ParameterizedClassInfo parameterizedClassInfo = (ParameterizedClassInfo)typeInfo;
            TypeInfo[] actualTypes = parameterizedClassInfo.getActualTypeArguments();
            TypeInfo elementType = actualTypes[0];
            return this.resolveTypeBinding(elementType);
        }
        return this.generateBean(typeInfo);
    }

    public TypeBinding generateMap(ClassInfo typeInfo) {
        return this.generateBean(typeInfo);
    }

    public TypeBinding isSimpleType(TypeInfo typeInfo) {
        QName qName = SimpleTypeBindings.typeQName(typeInfo.getType());
        if (qName == null) {
            return null;
        }
        TypeBinding result = this.schemaBinding.getType(qName);
        if (result == null) {
            throw new IllegalStateException("SimpleType is not bound in the schema: " + qName + " for " + typeInfo.getName());
        }
        result.setHandler(BuilderSimpleParticleHandler.SIMPLE_INSTANCE);
        return result;
    }

    public TypeBinding getSimpleType(TypeInfo typeInfo) {
        TypeBinding result = this.isSimpleType(typeInfo);
        if (result == null) {
            throw new IllegalStateException(typeInfo.getName() + " does not map to a simple type.");
        }
        return result;
    }

    public TypeBinding generateBean(ClassInfo typeInfo) {
        return this.generateBean(typeInfo, false);
    }

    public TypeBinding generateBean(ClassInfo typeInfo, boolean root) {
        return this.generateType(typeInfo, root);
    }

    public TypeBinding generateType(ClassInfo typeInfo, boolean root) {
        JBossXmlChildWildcard childWildcard;
        JBossXmlNoElements jbossXmlNoElements;
        PackageInfo pkg;
        XmlAccessorOrder accessorOrder;
        JBossXmlType jbossXmlType;
        String overrideNamespace = null;
        String overrideName = null;
        ClassInfo factoryClassInfo = typeInfo;
        String factoryMethod = null;
        String[] propertyOrder = new String[]{""};
        XmlAccessOrder accessOrder = XmlAccessOrder.UNDEFINED;
        Class beanAdapterBuilderClass = DefaultBeanAdapterBuilder.class;
        XmlType xmlType = (XmlType)typeInfo.getUnderlyingAnnotation(XmlType.class);
        if (xmlType != null) {
            Class factoryClass;
            root = true;
            overrideNamespace = xmlType.namespace();
            overrideName = xmlType.name();
            if (overrideName.length() == 0) {
                root = false;
            }
            if ((factoryClass = xmlType.factoryClass()) != XmlType.DEFAULT.class) {
                factoryClassInfo = (ClassInfo)typeInfo.getTypeInfoFactory().getTypeInfo(factoryClass);
            }
            factoryMethod = xmlType.factoryMethod();
            propertyOrder = xmlType.propOrder();
        }
        if ((jbossXmlType = (JBossXmlType)typeInfo.getUnderlyingAnnotation(JBossXmlType.class)) != null) {
            beanAdapterBuilderClass = jbossXmlType.beanAdapterBuilder();
        }
        if ((accessorOrder = (XmlAccessorOrder)typeInfo.getUnderlyingAnnotation(XmlAccessorOrder.class)) == null && (pkg = typeInfo.getPackage()) != null) {
            accessorOrder = (XmlAccessorOrder)pkg.getUnderlyingAnnotation(XmlAccessorOrder.class);
        }
        if (accessorOrder != null) {
            accessOrder = accessorOrder.value();
        }
        TypeBinding typeBinding = null;
        if (root) {
            QName qName = this.generateXmlName((TypeInfo)typeInfo, XmlNsForm.QUALIFIED, overrideNamespace, overrideName);
            typeBinding = new TypeBinding(qName);
        } else {
            typeBinding = new TypeBinding();
        }
        this.typeCache.put((TypeInfo)typeInfo, typeBinding);
        MethodInfo factory = null;
        if (factoryMethod != null && factoryMethod.length() > 0) {
            factory = Config.findMethodInfo((ClassInfo)factoryClassInfo, (String)factoryMethod, null, (boolean)true, (boolean)true);
        }
        BeanInfo beanInfo = JBossXBBuilder.configuration.getBeanInfo((TypeInfo)typeInfo);
        BeanAdapterFactory beanAdapterFactory = this.createAdapterFactory(beanAdapterBuilderClass, beanInfo, factory);
        BeanHandler handler = new BeanHandler(beanInfo.getName(), beanAdapterFactory);
        typeBinding.setHandler(handler);
        if (this.trace) {
            log.trace((Object)("Created BeanHandler for type=" + beanInfo.getName() + " factory=" + factory));
        }
        boolean noElements = (jbossXmlNoElements = (JBossXmlNoElements)typeInfo.getUnderlyingAnnotation(JBossXmlNoElements.class)) != null;
        PropertyInfo valueProperty = null;
        PropertyInfo wildcardProperty = null;
        boolean allBinding = propertyOrder.length == 0;
        boolean determinePropertyOrder = allBinding || propertyOrder.length == 1 && propertyOrder[0].length() == 0;
        ArrayList<String> propertyNames = new ArrayList<String>();
        Set properties = beanInfo.getProperties();
        if (properties != null && !properties.isEmpty()) {
            boolean seenXmlAnyElement = false;
            for (PropertyInfo property : properties) {
                XmlAttribute xmlAttribute;
                XmlValue xmlValue;
                this.push((TypeInfo)typeInfo, property.getName());
                if (this.trace) {
                    log.trace((Object)("Checking property " + property.getName() + " for " + beanInfo.getName() + " type=" + property.getType().getName()));
                }
                if ((xmlValue = (XmlValue)property.getUnderlyingAnnotation(XmlValue.class)) != null) {
                    if (this.trace) {
                        log.trace((Object)("Seen @XmlValue for type=" + beanInfo.getName() + " property=" + property.getName()));
                    }
                    if (valueProperty != null) {
                        throw new RuntimeException("@XmlValue seen on two properties: " + property.getName() + " and " + valueProperty.getName());
                    }
                    valueProperty = property;
                }
                boolean ignoreXmlAnyElement = false;
                XmlAnyElement xmlAnyElement = (XmlAnyElement)property.getUnderlyingAnnotation(XmlAnyElement.class);
                if (xmlAnyElement != null) {
                    if (this.trace) {
                        log.trace((Object)("Seen @XmlAnyElement for type=" + beanInfo.getName() + " property=" + property.getName()));
                    }
                    if (wildcardProperty != null && seenXmlAnyElement) {
                        throw new RuntimeException("@XmlAnyElement seen on two properties: " + property.getName() + " and " + wildcardProperty.getName());
                    }
                    wildcardProperty = property;
                    seenXmlAnyElement = true;
                    if (property.getUnderlyingAnnotation(XmlElements.class) == null && property.getUnderlyingAnnotation(XmlElementRefs.class) == null) {
                        ignoreXmlAnyElement = true;
                    }
                } else if (!seenXmlAnyElement && wildcardProperty == null && property.getType().getName().equals(Element.class.getName())) {
                    if (this.trace) {
                        log.trace((Object)("Using type=" + beanInfo.getName() + " property=" + property.getName() + " as the base wildcard"));
                    }
                    if (wildcardProperty != null) {
                        throw new RuntimeException("@XmlAnyElement seen on two properties: " + property.getName() + " and " + wildcardProperty.getName());
                    }
                    wildcardProperty = property;
                }
                if ((xmlAttribute = (XmlAttribute)property.getUnderlyingAnnotation(XmlAttribute.class)) != null) {
                    JBossXmlAttribute jbossXmlAttribute = (JBossXmlAttribute)property.getUnderlyingAnnotation(JBossXmlAttribute.class);
                    QName qName = this.generateXmlName(property.getName(), this.attributeForm, xmlAttribute.namespace(), xmlAttribute.name());
                    TypeInfo attributeTypeInfo = property.getType();
                    if (jbossXmlAttribute != null && jbossXmlAttribute.type() != Object.class) {
                        attributeTypeInfo = attributeTypeInfo.getTypeInfoFactory().getTypeInfo(jbossXmlAttribute.type());
                    }
                    TypeBinding attributeType = this.resolveTypeBinding(attributeTypeInfo);
                    PropertyHandler attributeHandler = new PropertyHandler(property, attributeTypeInfo);
                    AttributeBinding attribute = new AttributeBinding(this.schemaBinding, qName, attributeType, attributeHandler);
                    attribute.setRequired(xmlAttribute.required());
                    typeBinding.addAttribute(attribute);
                    if (this.trace) {
                        log.trace((Object)("Bound attribute " + qName + " type=" + beanInfo.getName() + " property=" + property.getName() + " propertyType=" + attributeTypeInfo));
                    }
                }
                if (determinePropertyOrder) {
                    if (xmlValue != null) {
                        if (this.trace) {
                            log.trace((Object)("Ignore not element @XmlValue for type=" + beanInfo.getName() + " property=" + property.getName()));
                        }
                        this.pop();
                        continue;
                    }
                    if (ignoreXmlAnyElement) {
                        if (this.trace) {
                            log.trace((Object)("Ignore not element @XmlAnyElement for type=" + beanInfo.getName() + " property=" + property.getName()));
                        }
                        this.pop();
                        continue;
                    }
                    if (xmlAttribute != null) {
                        if (this.trace) {
                            log.trace((Object)("Ignore not element @XmlAttribute for type=" + beanInfo.getName() + " property=" + property.getName()));
                        }
                        this.pop();
                        continue;
                    }
                    XmlTransient xmlTransient = (XmlTransient)property.getUnderlyingAnnotation(XmlTransient.class);
                    if (xmlTransient != null) {
                        if (this.trace) {
                            log.trace((Object)("Ignore not element @XmlTransient for type=" + beanInfo.getName() + " property=" + property.getName()));
                        }
                        this.pop();
                        continue;
                    }
                    String name = property.getName();
                    if ("class".equals(name)) {
                        this.pop();
                        continue;
                    }
                    if (noElements) {
                        this.pop();
                        continue;
                    }
                    if (this.trace) {
                        log.trace((Object)("Element for type=" + beanInfo.getName() + " property=" + property.getName()));
                    }
                    propertyNames.add(property.getName());
                }
                this.pop();
            }
            if (determinePropertyOrder) {
                if (accessOrder == XmlAccessOrder.ALPHABETICAL) {
                    Collections.sort(propertyNames);
                }
                propertyOrder = propertyNames.toArray(new String[propertyNames.size()]);
            }
        }
        if (valueProperty != null) {
            ValueHandler charactersHandler = new ValueHandler(valueProperty);
            typeBinding.setSimpleType(charactersHandler);
        } else if (this.trace) {
            log.trace((Object)("No value for type=" + beanInfo.getName()));
        }
        if (this.trace) {
            log.trace((Object)("PropertyOrder " + Arrays.asList(propertyOrder) + " for type=" + beanInfo.getName()));
        }
        typeBinding.setSimple(false);
        ModelGroupBinding model = null;
        if (allBinding) {
            if (this.trace) {
                log.trace((Object)("AllBinding for type=" + beanInfo.getName()));
            }
            model = new AllBinding(this.schemaBinding);
        } else {
            if (this.trace) {
                log.trace((Object)("SequenceBinding for type=" + beanInfo.getName()));
            }
            model = new SequenceBinding(this.schemaBinding);
        }
        model.setHandler(BuilderParticleHandler.INSTANCE);
        ParticleBinding typeParticle = new ParticleBinding(model);
        typeParticle.setMinOccurs(1);
        typeParticle.setMaxOccurs(1);
        typeBinding.setParticle(typeParticle);
        if (typeInfo.isCollection()) {
            typeParticle.setMinOccurs(0);
            typeParticle.setMaxOccursUnbounded(true);
            TypeInfo memberBaseType = typeInfo.getComponentType();
            JBossXmlModelGroup xmlModelGroup = (JBossXmlModelGroup)((ClassInfo)memberBaseType).getUnderlyingAnnotation(JBossXmlModelGroup.class);
            if (xmlModelGroup != null && xmlModelGroup.particles().length > 0) {
                ParticleBinding choiceParticle;
                if (this.trace) {
                    log.trace((Object)("Item base type for " + typeInfo.getName() + " is " + memberBaseType.getName() + " and bound to repeatable choice"));
                }
                ModelGroupBinding choiceGroup = null;
                QName choiceName = null;
                if (!"##default".equals(xmlModelGroup.name())) {
                    choiceName = new QName(this.defaultNamespace, xmlModelGroup.name());
                    choiceGroup = this.schemaBinding.getGroup(choiceName);
                }
                if (choiceGroup == null) {
                    choiceGroup = new ChoiceBinding(this.schemaBinding);
                    choiceGroup.setHandler(BuilderParticleHandler.INSTANCE);
                    if (choiceName != null) {
                        choiceGroup.setQName(choiceName);
                        this.schemaBinding.addGroup(choiceGroup.getQName(), choiceGroup);
                    }
                    choiceParticle = new ParticleBinding(choiceGroup, 0, 1, true);
                    model.addParticle(choiceParticle);
                    for (JBossXmlModelGroup.Particle member : xmlModelGroup.particles()) {
                        XmlElement element = member.element();
                        QName memberQName = this.generateXmlName(element.name(), XmlNsForm.QUALIFIED, element.namespace(), null);
                        TypeInfo memberTypeInfo = typeInfo.getTypeInfoFactory().getTypeInfo(member.type());
                        boolean isCol = false;
                        if (memberTypeInfo.isCollection()) {
                            memberTypeInfo = ((ClassInfo)memberTypeInfo).getComponentType();
                            isCol = true;
                        }
                        TypeBinding memberTypeBinding = this.resolveTypeBinding(memberTypeInfo);
                        ElementBinding memberElement = this.createElementBinding(memberTypeInfo, memberTypeBinding, memberQName, false);
                        memberElement.setNillable(true);
                        ParticleBinding memberParticle = new ParticleBinding(memberElement, 0, 1, isCol);
                        choiceGroup.addParticle(memberParticle);
                        typeBinding.pushInterceptor(memberQName, ChildCollectionInterceptor.SINGLETON);
                    }
                } else {
                    choiceParticle = new ParticleBinding(choiceGroup, 0, 1, true);
                    model.addParticle(choiceParticle);
                }
                if (this.trace) {
                    log.trace((Object)("choices for " + typeBinding.getQName() + ": " + choiceGroup.getParticles()));
                }
            }
        }
        AbstractPropertyHandler wildcardHandler = null;
        if (wildcardProperty != null) {
            TypeInfo wildcardType = wildcardProperty.getType();
            wildcardHandler = wildcardType.isCollection() ? new CollectionPropertyWildcardHandler(wildcardProperty, wildcardType) : new PropertyWildcardHandler(wildcardProperty, wildcardType);
        }
        for (String name : propertyOrder) {
            this.push((TypeInfo)typeInfo, name);
            PropertyInfo property = beanInfo.getProperty(name);
            this.bindProperty(property, typeBinding, model, beanAdapterFactory, propertyOrder);
            this.pop();
        }
        JBossXmlChild[] children = null;
        JBossXmlChildren jbossXmlChildren = (JBossXmlChildren)typeInfo.getUnderlyingAnnotation(JBossXmlChildren.class);
        if (jbossXmlChildren != null) {
            children = jbossXmlChildren.value();
        } else {
            JBossXmlChild jbossXmlChild = (JBossXmlChild)typeInfo.getUnderlyingAnnotation(JBossXmlChild.class);
            if (jbossXmlChild != null) {
                children = new JBossXmlChild[]{jbossXmlChild};
            }
        }
        if (children != null && children.length > 0) {
            for (JBossXmlChild child : children) {
                QName qName = this.generateXmlName(child.name(), this.elementForm, child.namespace(), child.name());
                TypeInfo childType = JBossXBBuilder.configuration.getTypeInfo(child.type());
                TypeBinding elementTypeBinding = this.resolveTypeBinding(childType);
                ElementBinding elementBinding = this.createElementBinding(childType, elementTypeBinding, qName, false);
                ParticleBinding particle = new ParticleBinding(elementBinding, child.minOccurs(), child.maxOccurs(), child.unbounded());
                model.addParticle(particle);
                if (childType.isMap()) {
                    this.bindMapProperty(null, (ClassInfo)childType, elementTypeBinding.getQName(), (ModelGroupBinding)elementTypeBinding.getParticle().getTerm());
                }
                DefaultElementInterceptor interceptor = null;
                if (typeInfo.isCollection()) {
                    interceptor = ChildCollectionInterceptor.SINGLETON;
                } else {
                    PropertyInfo property = beanInfo.getProperty("value");
                    if (property == null) {
                        throw new UnsupportedOperationException("Expected a value property for non-collection type with JBossXmlChildren");
                    }
                    TypeInfo propertyType = property.getType();
                    interceptor = new PropertyInterceptor(property, propertyType);
                }
                typeBinding.pushInterceptor(qName, interceptor);
                if (!this.trace) continue;
                log.trace((Object)("Added interceptor " + qName + " for type=" + childType + " interceptor=" + interceptor));
            }
        }
        if (wildcardProperty != null) {
            XmlAnyElement xmlAnyElement;
            TypeInfo wildcardType;
            if (this.trace) {
                log.trace((Object)("Processing WildcardProperty for type=" + beanInfo.getName() + " property=" + wildcardProperty.getName()));
            }
            ModelGroupBinding localModel = model;
            TypeInfo type = wildcardType = wildcardProperty.getType();
            if (wildcardType.isArray()) {
                localModel = this.createArray(localModel);
                type = ((ArrayInfo)wildcardType).getComponentType();
                if (this.trace) {
                    log.trace((Object)("Wildcard " + wildcardProperty.getName() + " is an array of type " + type.getName()));
                }
            } else if (wildcardType.isCollection()) {
                localModel = this.createCollection(localModel);
                type = ((ClassInfo)wildcardProperty.getType()).getComponentType();
                if (this.trace) {
                    log.trace((Object)("Wildcard " + wildcardProperty.getName() + " is a collection of type " + type.getName()));
                }
            }
            boolean isLax = (xmlAnyElement = (XmlAnyElement)wildcardProperty.getUnderlyingAnnotation(XmlAnyElement.class)) == null ? true : xmlAnyElement.lax();
            WildcardBinding wildcard = new WildcardBinding(this.schemaBinding);
            if (isLax) {
                wildcard.setProcessContents((short)3);
            } else {
                wildcard.setProcessContents((short)1);
            }
            if (Element.class.getName().equals(type.getName())) {
                wildcard.setUnresolvedElementHandler(DOMHandler.INSTANCE);
                wildcard.setUnresolvedCharactersHandler(DOMHandler.INSTANCE);
            }
            ParticleBinding particleBinding = new ParticleBinding(wildcard);
            particleBinding.setMinOccurs(0);
            particleBinding.setMaxOccurs(1);
            localModel.addParticle(particleBinding);
            typeBinding.getWildcard().setWildcardHandler((ParticleHandler)((Object)wildcardHandler));
            beanAdapterFactory.setWildcardHandler(wildcardHandler);
        }
        if ((childWildcard = (JBossXmlChildWildcard)typeInfo.getUnderlyingAnnotation(JBossXmlChildWildcard.class)) != null) {
            if (beanAdapterFactory.getWildcardHandler() != null) {
                throw new RuntimeException("Cannot have both @JBossXmlChildWildcard and @XmlAnyElement");
            }
            ChildCollectionWildcardHandler childWildcardHandler = null;
            if (typeInfo.isCollection()) {
                if (childWildcard.wrapper() != Object.class) {
                    BeanInfo wrapperInfo = JBossXBBuilder.configuration.getBeanInfo(childWildcard.wrapper());
                    childWildcardHandler = new ChildCollectionWildcardHandler(wrapperInfo, childWildcard.property());
                } else {
                    childWildcardHandler = ChildCollectionWildcardHandler.SINGLETON;
                }
            } else {
                throw new UnsupportedOperationException("TODO");
            }
            WildcardBinding wildcard = new WildcardBinding(this.schemaBinding);
            if (childWildcard.lax()) {
                wildcard.setProcessContents((short)3);
            } else {
                wildcard.setProcessContents((short)1);
            }
            ParticleBinding particleBinding = new ParticleBinding(wildcard);
            particleBinding.setMinOccurs(0);
            particleBinding.setMaxOccurs(1);
            model.addParticle(particleBinding);
            typeBinding.getWildcard().setWildcardHandler(childWildcardHandler);
        }
        if (this.trace) {
            log.trace((Object)("Created type=" + typeInfo.getName() + " typeBinding=" + typeBinding + " rootType=" + root));
        }
        if (root) {
            this.schemaBinding.addType(typeBinding);
        } else {
            typeBinding.setSchemaBinding(this.schemaBinding);
        }
        return typeBinding;
    }

    private void bindProperty(PropertyInfo property, TypeBinding typeBinding, ModelGroupBinding model, BeanAdapterFactory beanAdapterFactory, String[] propertyOrder) {
        XmlTransient xmlTransient;
        TypeInfo propertyType = property.getType();
        if (this.trace) {
            log.trace((Object)("Processing type=" + property.getBeanInfo().getName() + " property=" + property.getName()));
        }
        if ((xmlTransient = (XmlTransient)property.getUnderlyingAnnotation(XmlTransient.class)) != null && propertyOrder != null) {
            throw new RuntimeException("Property " + property.getName() + " in property order " + Arrays.asList(propertyOrder) + " is marked @XmlTransient");
        }
        ModelGroupBinding localModel = model;
        if (propertyType.isArray()) {
            if (this.trace) {
                log.trace((Object)("Property " + property.getName() + " is an array"));
            }
            localModel = this.createArray(localModel);
        } else if (propertyType.isCollection()) {
            if (this.trace) {
                log.trace((Object)("Property " + property.getName() + " is a collection"));
            }
            localModel = this.createCollection(localModel);
            JBossXmlCollection xmlCol = (JBossXmlCollection)property.getUnderlyingAnnotation(JBossXmlCollection.class);
            if (xmlCol != null) {
                propertyType = propertyType.getTypeInfoFactory().getTypeInfo(xmlCol.type());
            }
        } else if (!property.getType().isPrimitive()) {
            JBossXmlModelGroup xmlModelGroup;
            ClassInfo propClassInfo = (ClassInfo)property.getType();
            XmlElement propXmlElement = (XmlElement)property.getUnderlyingAnnotation(XmlElement.class);
            if (propXmlElement != null) {
                propClassInfo = (ClassInfo)propClassInfo.getTypeInfoFactory().getTypeInfo(propXmlElement.type());
            }
            if ((xmlModelGroup = (JBossXmlModelGroup)propClassInfo.getUnderlyingAnnotation(JBossXmlModelGroup.class)) != null && xmlModelGroup.particles().length == 0) {
                if (this.trace) {
                    log.trace((Object)("Property " + property.getName() + " is bound to " + xmlModelGroup.kind()));
                }
                ModelGroupBinding propertyGroup = null;
                QName groupName = null;
                if (!"##default".equals(xmlModelGroup.name())) {
                    groupName = new QName(xmlModelGroup.name());
                }
                if (groupName != null) {
                    propertyGroup = this.schemaBinding.getGroup(groupName);
                }
                if (propertyGroup == null) {
                    if (xmlModelGroup.kind().equals("sequence")) {
                        propertyGroup = new SequenceBinding(this.schemaBinding);
                    } else if (xmlModelGroup.kind().equals("choice")) {
                        propertyGroup = new ChoiceBinding(this.schemaBinding);
                    } else if (xmlModelGroup.kind().equals("all")) {
                        propertyGroup = new AllBinding(this.schemaBinding);
                    } else {
                        throw new IllegalStateException("Unexpected JBossXmlModelGroup.kind=" + xmlModelGroup.kind());
                    }
                    if (groupName != null) {
                        propertyGroup.setQName(groupName);
                        this.schemaBinding.addGroup(propertyGroup.getQName(), propertyGroup);
                    }
                    propertyGroup.setSkip(Boolean.FALSE);
                    BeanInfo propBeanInfo = JBossXBBuilder.configuration.getBeanInfo((TypeInfo)propClassInfo);
                    BeanAdapterFactory propBeanAdapterFactory = this.createAdapterFactory(DefaultBeanAdapterBuilder.class, propBeanInfo, null);
                    BeanHandler propHandler = new BeanHandler(propBeanInfo.getName(), propBeanAdapterFactory);
                    propertyGroup.setHandler(propHandler);
                    String[] memberOrder = xmlModelGroup.propOrder();
                    if (memberOrder.length == 0 || memberOrder[0].length() == 0) {
                        ArrayList<String> propNames = new ArrayList<String>();
                        for (PropertyInfo prop : propBeanInfo.getProperties()) {
                            propNames.add(prop.getName());
                        }
                        memberOrder = propNames.toArray(new String[propNames.size()]);
                    }
                    if (this.trace) {
                        log.trace((Object)("Property order for " + xmlModelGroup.kind() + " property " + property.getName() + ": " + Arrays.asList(memberOrder)));
                    }
                    for (String memberPropName : memberOrder) {
                        if ("class".equals(memberPropName)) continue;
                        PropertyInfo memberProp = propBeanInfo.getProperty(memberPropName);
                        TypeInfo memberTypeInfo = memberProp.getType();
                        String memberNamespace = null;
                        JBossXmlNsPrefix nsPrefix = (JBossXmlNsPrefix)memberProp.getUnderlyingAnnotation(JBossXmlNsPrefix.class);
                        if (nsPrefix != null && (memberNamespace = this.schemaBinding.getNamespace(nsPrefix.prefix())) == null && nsPrefix.schemaTargetIfNotMapped()) {
                            throw new IllegalStateException("Prefix '" + nsPrefix.prefix() + "' is not mapped to any namespace!");
                        }
                        String memberName = null;
                        XmlElement memberXmlElement = (XmlElement)memberProp.getUnderlyingAnnotation(XmlElement.class);
                        if (memberXmlElement != null) {
                            if (!XmlElement.DEFAULT.class.equals((Object)memberXmlElement.type())) {
                                memberTypeInfo = memberTypeInfo.getTypeInfoFactory().getTypeInfo(memberXmlElement.type());
                            }
                            if (memberNamespace == null) {
                                memberNamespace = memberXmlElement.namespace();
                            }
                            memberName = memberXmlElement.name();
                        }
                        if (memberNamespace == null) {
                            memberNamespace = this.defaultNamespace;
                        }
                        boolean isCol = false;
                        AbstractPropertyHandler memberPropertyHandler = null;
                        if (memberProp.getType().isCollection()) {
                            memberPropertyHandler = new CollectionPropertyHandler(memberProp, memberProp.getType());
                            isCol = true;
                            if (memberXmlElement == null || XmlElement.DEFAULT.class.equals((Object)memberXmlElement.type())) {
                                JBossXmlCollection jbossXmlCollection = (JBossXmlCollection)memberProp.getUnderlyingAnnotation(JBossXmlCollection.class);
                                if (jbossXmlCollection != null) {
                                    memberTypeInfo = memberTypeInfo.getTypeInfoFactory().getTypeInfo(jbossXmlCollection.type());
                                }
                                memberTypeInfo = ((ClassInfo)memberTypeInfo).getComponentType();
                            }
                        } else if (memberTypeInfo.isCollection()) {
                            memberPropertyHandler = new CollectionPropertyHandler(memberProp, memberTypeInfo);
                            isCol = true;
                            memberTypeInfo = ((ClassInfo)memberTypeInfo).getComponentType();
                        } else {
                            memberPropertyHandler = new PropertyHandler(memberProp, memberTypeInfo);
                        }
                        QName memberQName = this.generateXmlName(memberProp.getName(), this.elementForm, memberNamespace, memberName);
                        propBeanAdapterFactory.addProperty(memberQName, memberPropertyHandler);
                        XBValueAdapter valueAdapter = null;
                        XmlJavaTypeAdapter xmlTypeAdapter = (XmlJavaTypeAdapter)memberProp.getUnderlyingAnnotation(XmlJavaTypeAdapter.class);
                        if (xmlTypeAdapter != null) {
                            valueAdapter = new XBValueAdapter(xmlTypeAdapter.value(), memberTypeInfo.getTypeInfoFactory());
                            memberTypeInfo = valueAdapter.getAdaptedTypeInfo();
                        }
                        TypeBinding memberTypeBinding = this.resolveTypeBinding(memberTypeInfo);
                        ElementBinding memberElement = this.createElementBinding(memberTypeInfo, memberTypeBinding, memberQName, false);
                        memberElement.setNillable(true);
                        memberElement.setValueAdapter(valueAdapter);
                        ParticleBinding memberParticle = new ParticleBinding(memberElement, 0, 1, isCol);
                        propertyGroup.addParticle(memberParticle);
                        if (!this.trace) continue;
                        log.trace((Object)("added " + memberParticle + " to " + xmlModelGroup.kind() + ", property " + property.getName()));
                    }
                }
                model.addParticle(new ParticleBinding(propertyGroup));
                AbstractPropertyHandler propertyHandler = null;
                propertyHandler = propertyType.isCollection() ? new CollectionPropertyHandler(property, (TypeInfo)propClassInfo) : new PropertyHandler(property, (TypeInfo)propClassInfo);
                beanAdapterFactory.addProperty(propertyGroup.getQName(), propertyHandler);
                return;
            }
        }
        XmlElement[] elements = null;
        XmlElement xmlElement = (XmlElement)property.getUnderlyingAnnotation(XmlElement.class);
        if (xmlElement != null) {
            elements = new XmlElement[]{xmlElement};
        } else {
            XmlElements xmlElements = (XmlElements)property.getUnderlyingAnnotation(XmlElements.class);
            if (xmlElements != null) {
                elements = xmlElements.value();
            }
        }
        if (elements == null || elements.length == 0) {
            elements = new XmlElement[1];
        }
        JBossXmlNsPrefix xmlNsPrefix = (JBossXmlNsPrefix)property.getUnderlyingAnnotation(JBossXmlNsPrefix.class);
        XmlElementWrapper xmlWrapper = (XmlElementWrapper)property.getUnderlyingAnnotation(XmlElementWrapper.class);
        if (xmlWrapper != null) {
            String wrapperNamespace = xmlWrapper.namespace();
            String wrapperName = xmlWrapper.name();
            QName wrapperQName = this.generateXmlName(property.getName(), this.elementForm, wrapperNamespace, wrapperName);
            localModel = this.bindXmlElementWrapper(propertyType, localModel, xmlWrapper.nillable(), wrapperQName);
            beanAdapterFactory.addProperty(wrapperQName, new PropertyHandler(property, propertyType));
            if (this.trace) {
                log.trace((Object)("Added property " + wrapperQName + " for type=" + property.getBeanInfo().getName() + " property=" + property.getName() + " as a wrapper element"));
            }
        }
        if (elements.length > 1) {
            ChoiceBinding choice = new ChoiceBinding(this.schemaBinding);
            choice.setHandler(BuilderParticleHandler.INSTANCE);
            ParticleBinding particleBinding = new ParticleBinding(choice);
            particleBinding.setMinOccurs(0);
            particleBinding.setMaxOccurs(1);
            localModel.addParticle(particleBinding);
            localModel = choice;
            if (this.trace) {
                log.trace((Object)("XmlElements seen adding choice for type=" + property.getBeanInfo().getName() + " property=" + property.getName()));
            }
        }
        for (int i = 0; i < elements.length; ++i) {
            XmlElement element = elements[i];
            if (this.trace) {
                log.trace((Object)("Processing " + element + " for type=" + property.getBeanInfo().getName() + " property=" + property.getName()));
            }
            String overrideNamespace = null;
            String overrideName = null;
            boolean nillable = false;
            boolean required = false;
            TypeInfo localPropertyType = propertyType;
            if (element != null) {
                overrideNamespace = element.namespace();
                overrideName = element.name();
                nillable = element.nillable();
                required = element.required();
                Class elementType = element.type();
                if (elementType != XmlElement.DEFAULT.class) {
                    localPropertyType = propertyType.getTypeInfoFactory().getTypeInfo(elementType);
                }
            }
            if (xmlNsPrefix != null && (overrideNamespace = this.schemaBinding.getNamespace(xmlNsPrefix.prefix())) == null) {
                if (xmlNsPrefix.schemaTargetIfNotMapped()) {
                    overrideNamespace = this.defaultNamespace;
                } else {
                    throw new IllegalStateException("Prefix '" + xmlNsPrefix.prefix() + "' is not mapped to any namespace!");
                }
            }
            QName propertyQName = this.generateXmlName(property.getName(), this.elementForm, overrideNamespace, overrideName);
            JBossXmlGroup jbossXmlGroup = null;
            if (!propertyType.isPrimitive()) {
                jbossXmlGroup = (JBossXmlGroup)((ClassInfo)propertyType).getUnderlyingAnnotation(JBossXmlGroup.class);
            }
            if (element == null && jbossXmlGroup != null) {
                JBossXmlChild[] children;
                if (this.trace) {
                    log.trace((Object)("Processing group for property " + property.getName() + " in " + property.getBeanInfo().getName() + " " + jbossXmlGroup));
                }
                if ((children = jbossXmlGroup.value()) == null || children.length <= 0) continue;
                TypeBinding elementTypeBinding = new TypeBinding();
                JBossXmlGroupText groupText = (JBossXmlGroupText)((ClassInfo)propertyType).getUnderlyingAnnotation(JBossXmlGroupText.class);
                if (groupText != null && groupText.wrapper() != Object.class) {
                    ParticleHandler particleHandler;
                    BeanInfo wrapperInfo = JBossXBBuilder.configuration.getBeanInfo(groupText.wrapper());
                    TypeBinding wrapperTypeBinding = this.resolveTypeBinding((TypeInfo)wrapperInfo.getClassInfo());
                    Collection otherAttributes = wrapperTypeBinding.getAttributes();
                    if (otherAttributes != null) {
                        for (AttributeBinding other : otherAttributes) {
                            elementTypeBinding.addAttribute(other);
                        }
                    }
                    if (!((particleHandler = wrapperTypeBinding.getHandler()) instanceof BeanHandler)) {
                        throw new IllegalStateException("Cannot wrap " + wrapperInfo.getName() + " not a bean type " + particleHandler);
                    }
                    BeanHandler beanHandler = (BeanHandler)particleHandler;
                    WrapperBeanAdapterFactory wrapperFactory = new WrapperBeanAdapterFactory(beanHandler.getBeanAdapterFactory(), propertyType.getType());
                    elementTypeBinding.setHandler(new BeanHandler(wrapperInfo.getName(), wrapperFactory));
                    elementTypeBinding.setSimpleType(wrapperTypeBinding.getSimpleType());
                } else {
                    elementTypeBinding.setHandler(BuilderParticleHandler.INSTANCE);
                }
                elementTypeBinding.setSchemaBinding(this.schemaBinding);
                ElementBinding elementBinding = this.createElementBinding(localPropertyType, elementTypeBinding, propertyQName, false);
                ParticleBinding particle = new ParticleBinding(elementBinding, 1, 1, false);
                if (!required) {
                    particle.setMinOccurs(0);
                }
                localModel.addParticle(particle);
                ChoiceBinding childModel = new ChoiceBinding(this.schemaBinding);
                childModel.setHandler(BuilderParticleHandler.INSTANCE);
                ParticleBinding particleBinding = new ParticleBinding(childModel);
                particleBinding.setMinOccurs(0);
                particleBinding.setMaxOccurs(1);
                elementTypeBinding.setParticle(particleBinding);
                for (JBossXmlChild child : children) {
                    ChildWildcardHandler groupWildcardHandler;
                    QName childName = this.generateXmlName(child.name(), this.elementForm, child.namespace(), child.name());
                    TypeInfo childType = JBossXBBuilder.configuration.getTypeInfo(child.type());
                    TypeBinding childTypeBinding = this.resolveTypeBinding(childType);
                    ElementBinding childBinding = this.createElementBinding(childType, childTypeBinding, childName, false);
                    childBinding.setNillable(nillable);
                    particle = new ParticleBinding(childBinding, child.minOccurs(), child.maxOccurs(), child.unbounded());
                    particle.setMinOccurs(0);
                    childModel.addParticle(particle);
                    if (childType.isMap()) {
                        this.bindMapProperty(property, (ClassInfo)childType, childName, (ModelGroupBinding)childTypeBinding.getParticle().getTerm());
                    }
                    PropertyInterceptor interceptor = new PropertyInterceptor(property, propertyType);
                    elementTypeBinding.pushInterceptor(childName, interceptor);
                    if (this.trace) {
                        log.trace((Object)("Added interceptor " + childName + " for type=" + property.getBeanInfo().getName() + " property=" + property.getName() + " interceptor=" + interceptor + " " + childType.getName()));
                    }
                    beanAdapterFactory.addProperty(propertyQName, new PropertyHandler(property, propertyType));
                    JBossXmlGroupWildcard groupWildcard = (JBossXmlGroupWildcard)((ClassInfo)propertyType).getUnderlyingAnnotation(JBossXmlGroupWildcard.class);
                    if (groupWildcard == null) continue;
                    if (groupWildcard.wrapper() != Object.class) {
                        BeanInfo wrapperInfo = JBossXBBuilder.configuration.getBeanInfo(groupWildcard.wrapper());
                        groupWildcardHandler = new ChildWildcardHandler(property, wrapperInfo, groupWildcard.property());
                    } else {
                        groupWildcardHandler = new ChildWildcardHandler(property);
                    }
                    WildcardBinding wildcard = new WildcardBinding(this.schemaBinding);
                    if (groupWildcard.lax()) {
                        wildcard.setProcessContents((short)3);
                    } else {
                        wildcard.setProcessContents((short)1);
                    }
                    particleBinding = new ParticleBinding(wildcard);
                    particleBinding.setMinOccurs(0);
                    particleBinding.setMaxOccurs(1);
                    childModel.addParticle(particleBinding);
                    elementTypeBinding.getWildcard().setWildcardHandler(groupWildcardHandler);
                }
                continue;
            }
            XBValueAdapter valueAdapter = null;
            XmlJavaTypeAdapter xmlTypeAdapter = (XmlJavaTypeAdapter)property.getUnderlyingAnnotation(XmlJavaTypeAdapter.class);
            if (xmlTypeAdapter != null) {
                valueAdapter = new XBValueAdapter(xmlTypeAdapter.value(), propertyType.getTypeInfoFactory());
                localPropertyType = valueAdapter.getAdaptedTypeInfo();
            }
            ModelGroupBinding targetGroup = localModel;
            boolean isCol = false;
            boolean isMap = false;
            AbstractPropertyHandler propertyHandler = null;
            if (propertyType.isCollection() && ((ClassInfo)propertyType).getUnderlyingAnnotation(XmlType.class) == null) {
                JBossXmlChild xmlChild;
                isCol = true;
                propertyHandler = new CollectionPropertyHandler(property, propertyType);
                TypeInfo typeArg = ((ClassInfo)property.getType()).getComponentType();
                if (typeArg != null && ((ClassInfo)typeArg).getUnderlyingAnnotation(JBossXmlModelGroup.class) == null && (xmlChild = (JBossXmlChild)((ClassInfo)propertyType).getUnderlyingAnnotation(JBossXmlChild.class)) == null && localPropertyType.equals(propertyType)) {
                    localPropertyType = typeArg;
                }
            } else if (localPropertyType.isCollection() && ((ClassInfo)localPropertyType).getUnderlyingAnnotation(XmlType.class) == null) {
                propertyHandler = valueAdapter != null ? new PropertyHandler(property, localPropertyType) : new CollectionPropertyHandler(property, localPropertyType);
                isCol = true;
                localPropertyType = ((ClassInfo)localPropertyType).getComponentType();
            } else if (localPropertyType.isMap()) {
                QName boundQName;
                TypeBinding wrapperType = null;
                if (elements.length > 1) {
                    wrapperType = this.resolveTypeBinding(localPropertyType);
                    ElementBinding elementBinding = this.createElementBinding(localPropertyType, wrapperType, propertyQName, false);
                    elementBinding.setNillable(nillable);
                    elementBinding.setValueAdapter(valueAdapter);
                    ParticleBinding particle = new ParticleBinding(elementBinding, 0, 1, isCol);
                    if (!required) {
                        particle.setMinOccurs(0);
                    }
                    targetGroup.addParticle(particle);
                    targetGroup = (ModelGroupBinding)wrapperType.getParticle().getTerm();
                }
                if ((boundQName = this.bindMapProperty(property, (ClassInfo)localPropertyType, propertyQName, targetGroup)) != null) {
                    if (wrapperType != null) {
                        BeanAdapterFactory wrapperBeanFactory = ((BeanHandler)wrapperType.getHandler()).getBeanAdapterFactory();
                        Map<QName, AbstractPropertyHandler> properties = wrapperBeanFactory.getProperties();
                        if (!properties.containsKey(boundQName)) {
                            propertyHandler = new MapPropertyHandler(JBossXBBuilder.configuration, property, localPropertyType, true);
                            wrapperBeanFactory.addProperty(boundQName, propertyHandler);
                        }
                        propertyHandler = new PropertyHandler(property, localPropertyType);
                    } else {
                        propertyQName = boundQName;
                        propertyHandler = new MapPropertyHandler(JBossXBBuilder.configuration, property, localPropertyType, false);
                    }
                    isMap = true;
                } else {
                    propertyHandler = new PropertyHandler(property, localPropertyType);
                }
            } else {
                propertyHandler = new PropertyHandler(property, localPropertyType);
            }
            if (!isMap && !Element.class.getName().equals(propertyType.getName())) {
                TypeBinding elementTypeBinding = this.resolveTypeBinding(localPropertyType);
                ElementBinding elementBinding = this.createElementBinding(localPropertyType, elementTypeBinding, propertyQName, false);
                elementBinding.setNillable(nillable);
                elementBinding.setValueAdapter(valueAdapter);
                ParticleBinding particle = new ParticleBinding(elementBinding, 1, 1, isCol);
                if (!required) {
                    particle.setMinOccurs(0);
                }
                targetGroup.addParticle(particle);
            }
            beanAdapterFactory.addProperty(propertyQName, propertyHandler);
            if (!this.trace) continue;
            log.trace((Object)("Added property " + propertyQName + " for type=" + property.getBeanInfo().getName() + " property=" + property.getName() + " handler=" + propertyHandler));
        }
    }

    private SequenceBinding bindXmlElementWrapper(TypeInfo propertyType, ModelGroupBinding parentModel, boolean wrapperNillable, QName wrapperQName) {
        TypeBinding wrapperType = new TypeBinding();
        SequenceBinding seq = new SequenceBinding(this.schemaBinding);
        seq.setHandler(BuilderParticleHandler.INSTANCE);
        ParticleBinding particle = new ParticleBinding(seq);
        wrapperType.setParticle(particle);
        wrapperType.setHandler(new DefaultElementHandler());
        ElementBinding wrapperElement = this.createElementBinding(propertyType, wrapperType, wrapperQName, false);
        wrapperElement.setNillable(wrapperNillable);
        wrapperElement.setSkip(Boolean.TRUE);
        particle = new ParticleBinding(wrapperElement, 1, 1, false);
        parentModel.addParticle(particle);
        return seq;
    }

    private BeanAdapterFactory createAdapterFactory(Class<? extends BeanAdapterBuilder> beanAdapterBuilderClass, BeanInfo beanInfo, MethodInfo factory) {
        try {
            BeanInfo adapterBuilderInfo = JBossXBBuilder.configuration.getBeanInfo(beanAdapterBuilderClass);
            BeanAdapterBuilder adapterBuilder = (BeanAdapterBuilder)adapterBuilderInfo.newInstance();
            return adapterBuilder.newFactory(beanInfo, factory);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error creating BeanAdapterFactory for " + beanAdapterBuilderClass.getName(), t);
        }
    }

    private ModelGroupBinding createArray(ModelGroupBinding localModel) {
        SequenceBinding sequenceBinding = new SequenceBinding(this.schemaBinding);
        sequenceBinding.setHandler(BuilderParticleHandler.INSTANCE);
        ArraySequenceBinding arraySequenceBinding = new ArraySequenceBinding(this.schemaBinding);
        arraySequenceBinding.setHandler(BuilderParticleHandler.INSTANCE);
        ParticleBinding particle = new ParticleBinding(sequenceBinding);
        particle.setMinOccurs(0);
        particle.setMaxOccursUnbounded(true);
        arraySequenceBinding.addParticle(particle);
        particle = new ParticleBinding(arraySequenceBinding);
        localModel.addParticle(particle);
        return sequenceBinding;
    }

    private ModelGroupBinding createCollection(ModelGroupBinding localModel) {
        SequenceBinding sequenceBinding = new SequenceBinding(this.schemaBinding);
        sequenceBinding.setHandler(BuilderParticleHandler.INSTANCE);
        ParticleBinding particle = new ParticleBinding(sequenceBinding);
        particle.setMinOccurs(0);
        particle.setMaxOccursUnbounded(true);
        localModel.addParticle(particle);
        return sequenceBinding;
    }

    private void addNamespace(String namespace, boolean erase) {
        HashSet<String> namespaces = this.schemaBinding.getNamespaces();
        if (erase && namespaces.size() <= 1) {
            namespaces = new HashSet<String>(Collections.singleton(namespace));
        }
        namespaces.add(namespace);
        this.schemaBinding.setNamespaces(namespaces);
    }

    protected QName generateXmlName(TypeInfo typeInfo, XmlNsForm form, String namespace, String name) {
        return this.generateXmlName(typeInfo.getSimpleName(), form, namespace, name);
    }

    protected QName generateXmlName(String localName, XmlNsForm form, String namespace, String name) {
        String nsUri = "";
        if (form == XmlNsForm.QUALIFIED) {
            nsUri = this.defaultNamespace;
        }
        if (namespace != null && !"##default".equals(namespace)) {
            nsUri = namespace;
        }
        localName = name != null && !"##default".equals(name) ? name : JBossXBBuilder.generateXMLNameFromJavaName(localName, true, this.schemaBinding.isIgnoreLowLine());
        return new QName(nsUri, localName);
    }

    private void push(TypeInfo typeInfo) {
        this.push(typeInfo, null);
    }

    private void push(TypeInfo typeInfo, String joinpoint) {
        this.locations.push(new Location(typeInfo, joinpoint));
    }

    private void pop() {
        this.locations.pop();
    }

    private RuntimeException rethrowWithLocation(Throwable t) {
        StringBuilder message = new StringBuilder();
        message.append(t.getMessage());
        message.append("\n");
        while (!this.locations.isEmpty()) {
            Location location = this.locations.pop();
            location.append(message);
            if (this.locations.isEmpty()) continue;
            message.append('\n');
        }
        throw new RuntimeException(message.toString(), t);
    }

    private QName bindMapProperty(PropertyInfo prop, ClassInfo propType, QName propertyQName, ModelGroupBinding targetGroup) {
        QName boundQName = null;
        JBossXmlMapEntry entryElement = null;
        if (prop != null) {
            entryElement = (JBossXmlMapEntry)prop.getUnderlyingAnnotation(JBossXmlMapEntry.class);
        }
        if (entryElement == null) {
            entryElement = (JBossXmlMapEntry)propType.getUnderlyingAnnotation(JBossXmlMapEntry.class);
        }
        JBossXmlMapKeyElement keyElement = null;
        if (prop != null) {
            keyElement = (JBossXmlMapKeyElement)prop.getUnderlyingAnnotation(JBossXmlMapKeyElement.class);
        }
        if (keyElement == null) {
            keyElement = (JBossXmlMapKeyElement)propType.getUnderlyingAnnotation(JBossXmlMapKeyElement.class);
        }
        JBossXmlMapKeyAttribute keyAttribute = null;
        if (prop != null) {
            keyAttribute = (JBossXmlMapKeyAttribute)prop.getUnderlyingAnnotation(JBossXmlMapKeyAttribute.class);
        }
        if (keyAttribute == null) {
            keyAttribute = (JBossXmlMapKeyAttribute)propType.getUnderlyingAnnotation(JBossXmlMapKeyAttribute.class);
        }
        if (keyElement != null || keyAttribute != null) {
            ParticleBinding particle;
            JBossXmlMapValueElement valueElement = null;
            if (prop != null) {
                valueElement = (JBossXmlMapValueElement)prop.getUnderlyingAnnotation(JBossXmlMapValueElement.class);
            }
            if (valueElement == null) {
                valueElement = (JBossXmlMapValueElement)propType.getUnderlyingAnnotation(JBossXmlMapValueElement.class);
            }
            JBossXmlMapValueAttribute valueAttribute = null;
            if (prop != null) {
                valueAttribute = (JBossXmlMapValueAttribute)prop.getUnderlyingAnnotation(JBossXmlMapValueAttribute.class);
            }
            if (valueAttribute == null) {
                valueAttribute = (JBossXmlMapValueAttribute)propType.getUnderlyingAnnotation(JBossXmlMapValueAttribute.class);
            }
            TypeInfo keyType = propType.getKeyType();
            TypeInfo valueType = propType.getValueType();
            BeanAdapterFactory entryAdapterFactory = null;
            BeanInfo entryInfo = JBossXBBuilder.configuration.getBeanInfo(DefaultMapEntry.class);
            entryAdapterFactory = this.createAdapterFactory(DefaultBeanAdapterBuilder.class, entryInfo, null);
            BeanHandler entryHandler = new BeanHandler(entryInfo.getName(), entryAdapterFactory);
            TypeBinding entryType = null;
            TypeInfo entryTypeInfo = null;
            if (entryElement != null && !"##default".equals(entryElement.name())) {
                PropertyHandler attributeHandler;
                TypeBinding attributeType;
                String ns = entryElement.namespace();
                if ("##default".equals(ns)) {
                    ns = this.defaultNamespace;
                }
                QName entryName = new QName(ns, entryElement.name());
                entryType = new TypeBinding();
                entryType.setSchemaBinding(this.schemaBinding);
                entryType.setHandler(entryHandler);
                entryTypeInfo = JBossXBBuilder.configuration.getTypeInfo(DefaultMapEntry.class);
                ElementBinding entryElementBinding = this.createElementBinding(entryTypeInfo, entryType, entryName, false);
                ParticleBinding entryParticle = new ParticleBinding(entryElementBinding, 0, -1, true);
                targetGroup.addParticle(entryParticle);
                propertyQName = entryName;
                if (keyAttribute != null) {
                    attributeType = this.resolveTypeBinding(keyType);
                    attributeHandler = new PropertyHandler(entryInfo.getProperty("key"), keyType);
                    String attrNs = keyAttribute.namespace();
                    if ("##default".equals(attrNs)) {
                        attrNs = this.defaultNamespace;
                    }
                    AttributeBinding keyBinding = new AttributeBinding(this.schemaBinding, new QName(attrNs, keyAttribute.name()), attributeType, attributeHandler);
                    keyBinding.setRequired(true);
                    entryType.addAttribute(keyBinding);
                }
                if (valueAttribute != null) {
                    attributeType = this.resolveTypeBinding(valueType);
                    attributeHandler = new PropertyHandler(entryInfo.getProperty("value"), valueType);
                    String valueNs = valueAttribute.namespace();
                    if ("##default".equals(valueNs)) {
                        valueNs = this.defaultNamespace;
                    }
                    AttributeBinding valueBinding = new AttributeBinding(this.schemaBinding, new QName(valueNs, valueAttribute.name()), attributeType, attributeHandler);
                    valueBinding.setRequired(true);
                    entryType.addAttribute(valueBinding);
                } else if (valueElement == null) {
                    ValueHandler charactersHandler = new ValueHandler(entryInfo.getProperty("value"), valueType);
                    entryType.setSimpleType(charactersHandler);
                }
            }
            SequenceBinding keyValueSequence = null;
            if (keyElement != null) {
                ParticleBinding keyValueParticle;
                keyValueSequence = new SequenceBinding(this.schemaBinding);
                if (entryType == null) {
                    keyValueSequence.setSkip(Boolean.FALSE);
                    keyValueSequence.setQName(propertyQName);
                    this.schemaBinding.addGroup(keyValueSequence.getQName(), keyValueSequence);
                    keyValueParticle = new ParticleBinding(keyValueSequence, 0, -1, true);
                    targetGroup.addParticle(keyValueParticle);
                    keyValueSequence.setHandler(entryHandler);
                } else {
                    keyValueParticle = new ParticleBinding(keyValueSequence, 1, 1, false);
                    entryType.setParticle(keyValueParticle);
                }
                TypeBinding keyTypeBinding = this.resolveTypeBinding(keyType);
                String keyNs = keyElement.namespace();
                if ("##default".equals(keyNs)) {
                    keyNs = this.defaultNamespace;
                }
                ElementBinding keyElementBinding = this.createElementBinding(keyType, keyTypeBinding, new QName(keyNs, keyElement.name()), false);
                particle = new ParticleBinding(keyElementBinding, 1, 1, false);
                keyValueSequence.addParticle(particle);
                PropertyHandler keyHandler = new PropertyHandler(entryInfo.getProperty("key"), keyType);
                entryAdapterFactory.addProperty(keyElementBinding.getQName(), keyHandler);
            }
            if (valueElement != null) {
                TypeBinding valueTypeBinding = this.resolveTypeBinding(valueType);
                String valueNs = valueElement.namespace();
                if ("##default".equals(valueNs)) {
                    valueNs = this.defaultNamespace;
                }
                ElementBinding valueElementBinding = this.createElementBinding(valueType, valueTypeBinding, new QName(valueNs, valueElement.name()), false);
                particle = new ParticleBinding(valueElementBinding, 1, 1, false);
                keyValueSequence.addParticle(particle);
                PropertyHandler valueHandler = new PropertyHandler(entryInfo.getProperty("value"), valueType);
                entryAdapterFactory.addProperty(valueElementBinding.getQName(), valueHandler);
            }
            boundQName = propertyQName;
        } else if (entryElement != null && !JBossXmlMapEntry.DEFAULT.class.equals((Object)entryElement.type())) {
            if (!"##default".equals(entryElement.name())) {
                String ns = entryElement.namespace();
                if ("##default".equals(ns)) {
                    ns = propertyQName.getNamespaceURI();
                }
                propertyQName = new QName(ns, entryElement.name());
            }
            TypeInfo entryTypeInfo = JBossXBBuilder.configuration.getTypeInfo((Type)entryElement.type());
            ElementBinding entryElementBinding = this.createElementBinding(entryTypeInfo, propertyQName.getLocalPart(), false);
            ParticleBinding entryParticle = new ParticleBinding(entryElementBinding, 0, -1, true);
            targetGroup.addParticle(entryParticle);
            boundQName = propertyQName;
        }
        return boundQName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class XBValueAdapter
    implements ValueAdapter {
        private final XmlAdapter xmlAdapter;
        private final TypeInfo adaptedTypeInfo;
        private final Type adaptedType;

        public XBValueAdapter(Class<? extends XmlAdapter> adapterImplClass, TypeInfoFactory factory) {
            try {
                this.xmlAdapter = adapterImplClass.newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to create an instance of " + adapterImplClass.getName(), e);
            }
            this.adaptedType = ((ParameterizedType)adapterImplClass.getGenericSuperclass()).getActualTypeArguments()[0];
            this.adaptedTypeInfo = factory.getTypeInfo(this.adaptedType);
        }

        public TypeInfo getAdaptedTypeInfo() {
            return this.adaptedTypeInfo;
        }

        public Type getAdaptedType() {
            return this.adaptedType;
        }

        @Override
        public Object cast(Object o, Class c) {
            try {
                return this.xmlAdapter.unmarshal(o);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to adapt value " + o + " to type " + c, e);
            }
        }
    }

    private class Location {
        TypeInfo typeInfo;
        String joinpoint;

        Location(TypeInfo typeInfo, String joinpoint) {
            this.typeInfo = typeInfo;
            this.joinpoint = joinpoint;
        }

        public void append(StringBuilder builder) {
            builder.append("at ");
            builder.append(this.typeInfo.getName());
            if (this.joinpoint != null) {
                builder.append('.').append(this.joinpoint);
            }
        }
    }
}

