/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.embedded.manager.pc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.embedded.manager.ResourceManager;
import org.jboss.seam.core.Events;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.configuration.ConfigurationAgentService;
import org.rhq.core.clientapi.agent.configuration.ConfigurationUpdateRequest;
import org.rhq.core.clientapi.agent.configuration.ConfigurationUtility;
import org.rhq.core.clientapi.agent.discovery.DiscoveryAgentService;
import org.rhq.core.clientapi.agent.inventory.CreateResourceRequest;
import org.rhq.core.clientapi.agent.inventory.CreateResourceResponse;
import org.rhq.core.clientapi.agent.inventory.DeleteResourceRequest;
import org.rhq.core.clientapi.agent.inventory.DeleteResourceResponse;
import org.rhq.core.clientapi.agent.inventory.ResourceFactoryAgentService;
import org.rhq.core.clientapi.agent.operation.OperationAgentService;
import org.rhq.core.clientapi.server.configuration.ConfigurationUpdateResponse;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.domain.resource.DeleteResourceStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.PluginContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginContainerResourceManager
implements ResourceManager {
    private static final Log LOG = LogFactory.getLog(PluginContainerResourceManager.class);
    private static final String DISCOVERY_ERROR = "Error occurred during discovery";
    private static final String NO_SERVERS_FOUND = "Service cannot be created since no servers are found in the platform";
    private static final String CANNOT_CREATE_REQUEST = "Unable to create a request for saving the resource";
    private static final String CANNOT_BE_NULL = "Resource cannot be null";
    private static final String GET_RESOURCE_ERROR = "Error retrieving configuration for resource: ";
    private static final String REMOVE_RESOURCE_ERROR = "Error while deleting service: ";
    private static final String CREATE_RESOURCE_ERROR = "Error while creating service of type [";
    private static final String UPDATE_RESOURCE_ERROR = "Error while updating service: ";
    private static final String INVOKE_OPERATION_ERROR = "Error invoking operation on resource [";

    public void discoverResources() {
        LOG.info((Object)"Discovering Resources...");
        try {
            this.getInventoryService().executeServerScanImmediately();
            this.getInventoryService().executeServiceScanImmediately();
        }
        catch (Exception e) {
            LOG.error((Object)DISCOVERY_ERROR, (Throwable)e);
            throw new RuntimeException(DISCOVERY_ERROR, e);
        }
        Resource platform = this.getInventoryService().getPlatform();
        if (platform.getChildResources().isEmpty()) {
            LOG.error((Object)NO_SERVERS_FOUND);
            return;
        }
    }

    public void discoverServicesAsync() {
        try {
            this.getInventoryService().executeServiceScanDeferred();
        }
        catch (Exception e) {
            LOG.error((Object)DISCOVERY_ERROR, (Throwable)e);
            throw new RuntimeException(DISCOVERY_ERROR, e);
        }
    }

    public void discoverServicesSync() {
        try {
            this.getInventoryService().executeServiceScanImmediately();
        }
        catch (Exception e) {
            LOG.error((Object)DISCOVERY_ERROR, (Throwable)e);
            throw new RuntimeException(DISCOVERY_ERROR, e);
        }
    }

    public ResourceType getResourceType(String resourceTypeName) {
        ResourceType resourceType = null;
        Set allTypes = this.getPluginContainer().getPluginManager().getMetadataManager().getAllTypes();
        for (ResourceType type : allTypes) {
            if (!type.getName().equals(resourceTypeName)) continue;
            resourceType = type;
        }
        return resourceType;
    }

    public Set<ResourceType> getAllResourceTypes() {
        return this.getPluginContainer().getPluginManager().getMetadataManager().getAllTypes();
    }

    @NotNull
    public Set<Resource> getResources(ResourceType resourceType, Resource rootResource) {
        TreeSet<Resource> childResources = new TreeSet<Resource>();
        if (resourceType.getCategory() == ResourceCategory.PLATFORM) {
            childResources.add(this.getInventoryService().getPlatform());
        } else {
            this.fillWithChildResources(childResources, rootResource, resourceType);
        }
        return childResources;
    }

    private void fillWithChildResources(Set<Resource> matchingResources, Resource root, ResourceType type) {
        for (Resource childResource : root.getChildResources()) {
            if (childResource.getResourceType().equals((Object)type)) {
                matchingResources.add(childResource);
            }
            this.fillWithChildResources(matchingResources, childResource, type);
        }
    }

    public Resource getResource(Integer id) {
        Resource result = null;
        if (id != null) {
            result = this.getResource(this.getInventoryService().getPlatform(), id);
        }
        return result;
    }

    public Resource getPlatform() {
        return this.getInventoryService().getPlatform();
    }

    private Resource getResource(@NotNull Resource resource, @NotNull Integer id) {
        Resource result = null;
        if (resource.getId() == id.intValue()) {
            result = resource;
        } else {
            Resource childResource;
            Iterator i$ = resource.getChildResources().iterator();
            while (i$.hasNext() && (result = this.getResource(childResource = (Resource)i$.next(), id)) == null) {
                if (childResource.getId() != id.intValue()) continue;
                result = childResource;
                break;
            }
        }
        return result;
    }

    public Configuration getResourceConfiguration(Resource resource) {
        Configuration configuration;
        if (resource == null) {
            throw new IllegalArgumentException(CANNOT_BE_NULL);
        }
        try {
            configuration = this.getConfigService().loadResourceConfiguration(resource.getId());
        }
        catch (PluginContainerException e) {
            LOG.error((Object)(GET_RESOURCE_ERROR + resource), (Throwable)e);
            throw new RuntimeException(e);
        }
        ConfigurationUtility.normalizeConfiguration((Configuration)configuration, (ConfigurationDefinition)resource.getResourceType().getResourceConfigurationDefinition());
        return configuration;
    }

    public DeleteResourceResponse removeResource(Resource resource) {
        DeleteResourceResponse response;
        try {
            DeleteResourceRequest deleteRequest = new DeleteResourceRequest(1, resource.getId());
            response = this.getResourceFactoryService().executeDeleteResourceImmediately(deleteRequest);
            if (response.getStatus() == DeleteResourceStatus.SUCCESS) {
                this.discoverServicesSync();
            }
        }
        catch (PluginContainerException e) {
            LOG.error((Object)(REMOVE_RESOURCE_ERROR + resource), (Throwable)e);
            throw new RuntimeException(e);
        }
        return response;
    }

    public CreateResourceResponse createResource(String resourceName, ResourceType resourceType, Resource parentResource, Configuration pluginConfiguration, Configuration resourceConfiguration) {
        CreateResourceRequest request = new CreateResourceRequest(1, parentResource.getId(), resourceName, resourceType.getName(), resourceType.getPlugin(), pluginConfiguration, resourceConfiguration);
        CreateResourceResponse response = this.createResource(resourceType, parentResource, request);
        return response;
    }

    public CreateResourceResponse createResource(String resourceName, ResourceType resourceType, Resource parentResource, Configuration pluginConfiguration, ResourcePackageDetails packageDetails) {
        CreateResourceRequest request = new CreateResourceRequest(1, parentResource.getId(), resourceName, resourceType.getName(), resourceType.getPlugin(), pluginConfiguration, packageDetails);
        CreateResourceResponse response = this.createResource(resourceType, parentResource, request);
        return response;
    }

    private CreateResourceResponse createResource(ResourceType resourceType, Resource parentResource, CreateResourceRequest request) {
        CreateResourceResponse response;
        try {
            response = this.getResourceFactoryService().executeCreateResourceImmediately(request);
            if (response.getStatus() == CreateResourceStatus.SUCCESS) {
                this.discoverServicesSync();
            }
        }
        catch (PluginContainerException e) {
            LOG.error((Object)(CREATE_RESOURCE_ERROR + resourceType), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            LOG.error((Object)(CANNOT_CREATE_REQUEST + e));
            throw new RuntimeException(CANNOT_CREATE_REQUEST, e);
        }
        return response;
    }

    public ConfigurationUpdateResponse updateResource(Resource resource, Configuration configuration) {
        ConfigurationUpdateResponse response;
        try {
            ConfigurationUpdateRequest request = new ConfigurationUpdateRequest(0, configuration, resource.getId());
            response = this.getConfigService().executeUpdateResourceConfigurationImmediately(request);
            if (response.getStatus() == ConfigurationUpdateStatus.SUCCESS) {
                this.discoverServicesSync();
                Events.instance().raiseEvent("resourceUpdated", new Object[]{resource});
            }
        }
        catch (PluginContainerException e) {
            LOG.error((Object)UPDATE_RESOURCE_ERROR);
            throw new RuntimeException(UPDATE_RESOURCE_ERROR, e);
        }
        return response;
    }

    public Availability getAvailability(Resource resource) {
        return this.getInventoryService().getCurrentAvailability(resource);
    }

    @NotNull
    public List<OperationDefinition> getOperationsForResource(Resource resource) {
        ArrayList<OperationDefinition> operationDefinitions = new ArrayList<OperationDefinition>();
        if (resource != null) {
            ResourceType resourceType = resource.getResourceType();
            operationDefinitions.addAll(resourceType.getOperationDefinitions());
        }
        return operationDefinitions;
    }

    public void invokeOperation(Resource resource, OperationDefinition operation, Configuration parameters, String jobId) {
        try {
            this.getOperationService().invokeOperation(jobId, resource.getId(), operation.getName(), parameters);
        }
        catch (PluginContainerException e) {
            LOG.error((Object)(INVOKE_OPERATION_ERROR + resource), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected ConfigurationAgentService getConfigService() {
        return this.getPluginContainer().getConfigurationAgentService();
    }

    protected DiscoveryAgentService getInventoryService() {
        return this.getPluginContainer().getDiscoveryAgentService();
    }

    protected OperationAgentService getOperationService() {
        return this.getPluginContainer().getOperationAgentService();
    }

    protected ResourceFactoryAgentService getResourceFactoryService() {
        return this.getPluginContainer().getResourceFactoryAgentService();
    }

    protected PluginContainer getPluginContainer() {
        return PluginContainer.getInstance();
    }
}

