/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.embedded.ui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.embedded.manager.ResourceManager;
import org.jboss.on.embedded.manager.ResourceManagerFactory;
import org.jboss.on.embedded.ui.nav.BaseTreeNode;
import org.jboss.on.embedded.ui.nav.DummyTreeNode;
import org.jboss.on.embedded.ui.nav.JONTreeNode;
import org.jboss.on.embedded.ui.nav.PlatformResourceTreeNode;
import org.jboss.on.embedded.ui.nav.ResourceTypeTreeNode;
import org.jboss.on.embedded.ui.nav.TreeNodeWithResource;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceCreationDataType;
import org.rhq.core.domain.resource.ResourceType;
import org.richfaces.component.UITree;
import org.richfaces.event.NodeExpandedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="navigationAction")
@Scope(value=ScopeType.SESSION)
public class NavigationAction
implements Serializable {
    private Set<JONTreeNode> expandedYet = new HashSet();
    private int openDepth = 0;
    private static final Log log = LogFactory.getLog(NavigationAction.class);
    private Object navigationState;
    @In(value="rootNode", create=true)
    private JONTreeNode rootNode;
    private String currentPath;

    public int getOpenDepth() {
        return this.openDepth;
    }

    public void setOpenDepth(int n) {
        this.openDepth = n;
    }

    public Object getNavigationState() {
        return this.navigationState;
    }

    public void setNavigationState(Object navigationState) {
        this.navigationState = navigationState;
    }

    private ResourceManager getManager() {
        return ResourceManagerFactory.resourceManager();
    }

    public JONTreeNode getRootNode() {
        return this.rootNode;
    }

    public String getCurrentPath() {
        return this.currentPath;
    }

    public void setCurrentPath(String path) {
        this.currentPath = path;
    }

    public List<JONTreeNode> getBreadCrumbs() {
        JONTreeNode selectedNode = this.getSelectedNode();
        ArrayList<JONTreeNode> breadcrumbs = new ArrayList<JONTreeNode>();
        breadcrumbs.add(selectedNode);
        for (JONTreeNode parent = selectedNode.getParent(); parent != null; parent = parent.getParent()) {
            breadcrumbs.add(0, parent);
        }
        if (breadcrumbs.get(0) instanceof DummyTreeNode) {
            breadcrumbs.remove(0);
        }
        return breadcrumbs;
    }

    public Map<String, Boolean> getEnabledTabs() {
        HashMap<String, Boolean> enabledTabs = new HashMap<String, Boolean>(4);
        JONTreeNode currentNode = this.getSelectedNode();
        if (currentNode instanceof TreeNodeWithResource) {
            Resource resource = ((TreeNodeWithResource)currentNode).getResource();
            if (this.hasConfiguration(resource)) {
                enabledTabs.put("configuration", true);
            }
            if (this.hasMetrics(resource)) {
                enabledTabs.put("metric", true);
            }
            if (resource.getResourceType().getCategory() != ResourceCategory.PLATFORM && this.hasOperations(resource)) {
                enabledTabs.put("operation", true);
            }
            if (this.isContentBacked(resource)) {
                enabledTabs.put("content", true);
            }
        }
        return enabledTabs;
    }

    private boolean isContentBacked(Resource resource) {
        return resource.getResourceType().getCreationDataType().equals((Object)ResourceCreationDataType.CONTENT);
    }

    private boolean hasOperations(Resource resource) {
        List operations = this.getManager().getOperationsForResource(resource);
        return !operations.isEmpty();
    }

    private boolean hasMetrics(Resource resource) {
        Set metrics = resource.getResourceType().getMetricDefinitions();
        return metrics != null && !metrics.isEmpty();
    }

    private boolean hasConfiguration(Resource resource) {
        ConfigurationDefinition resourceConfigDef = resource.getResourceType().getResourceConfigurationDefinition();
        return resourceConfigDef != null && !resourceConfigDef.getPropertyDefinitions().isEmpty();
    }

    public String getAvailableStatus() {
        String status = "SUMMARY";
        JONTreeNode currentNode = this.getSelectedNode();
        if (currentNode instanceof TreeNodeWithResource) {
            Resource resource = ((TreeNodeWithResource)currentNode).getResource();
            return this.getAvailableStatus(resource);
        }
        return status;
    }

    public String getAvailableStatus(Resource resource) {
        Availability availability = this.getManager().getAvailability(resource);
        AvailabilityType type = availability.getAvailabilityType();
        String status = type != null ? type.getName() : "UNKNOWN";
        return status;
    }

    public boolean equalsSelectedNode(JONTreeNode node) {
        JONTreeNode currentNode = this.getSelectedNode();
        return node.equals(currentNode);
    }

    public JONTreeNode getSelectedNode() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Finding node for path [" + this.getCurrentPath() + "]..."));
        }
        JONTreeNode selectedNode = this.getRootNode().findNode(this.getCurrentPath());
        ResourceManager resourceManager = ResourceManagerFactory.resourceManager();
        if (selectedNode == null) {
            log.debug((Object)("Unable to find node with path [" + this.currentPath + "]; defaulting to platform node..."));
            this.currentPath = this.getResourcePath(resourceManager.getPlatform());
            selectedNode = this.getRootNode().findNode(this.currentPath);
        }
        return selectedNode;
    }

    public boolean isAvailable(Resource r) {
        Availability availability = this.getManager().getAvailability(r);
        return availability.getAvailabilityType() == AvailabilityType.UP;
    }

    public JONTreeNode findNode(String path) {
        return this.getRootNode().findNode(path);
    }

    public String getResourcePath(Integer resourceId) {
        return String.valueOf(resourceId);
    }

    public String getResourcePath(Resource resource) {
        return this.getResourcePath(Integer.valueOf(resource.getId()));
    }

    public ResourceTypeTreeNode findNodeByResourceTypeAndParent(ResourceType resourceType, JONTreeNode parentResourceNode) {
        return ((BaseTreeNode)parentResourceNode).findNodeByType(resourceType);
    }

    public Boolean openNodeAdvisor(UITree tree) {
        JONTreeNode data = (JONTreeNode)tree.getTreeNode().getData();
        if (!this.expandedYet.contains(data) && this.isWithinNStepsOfPlatform(this.openDepth - 1, data).booleanValue()) {
            this.expandedYet.add(data);
            return Boolean.TRUE;
        }
        return null;
    }

    private Boolean isWithinNStepsOfPlatform(int n, JONTreeNode node) {
        if (n < 0 || node == null) {
            return Boolean.FALSE;
        }
        return node instanceof PlatformResourceTreeNode || this.isWithinNStepsOfPlatform(n - 1, node.getParent()) != false;
    }

    public void changeExpandListener(NodeExpandedEvent event) {
        UIComponent comp = event.getComponent();
        UITree tree = (UITree)comp;
        JONTreeNode jonTreeNode = (JONTreeNode)tree.getTreeNode().getData();
        jonTreeNode.reInitializeChildrenMap();
    }
}

