/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.embedded.ui.content;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.faces.application.FacesMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.embedded.manager.ResourceManager;
import org.jboss.on.embedded.manager.ResourceManagerFactory;
import org.jboss.on.embedded.ui.content.AbstractFileUploadAction;
import org.jboss.on.embedded.ui.content.CreateContentBackedResourceAction;
import org.jboss.on.embedded.ui.nav.JONTreeNode;
import org.jboss.on.embedded.ui.nav.ResourceTypeTreeNode;
import org.jboss.on.embedded.util.ContentUtility;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.End;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
import org.rhq.core.clientapi.agent.inventory.CreateResourceResponse;
import org.rhq.core.clientapi.server.plugin.content.ContentSourcePackageDetailsKey;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;

@Name(value="createContentBackedResourceAction")
@Scope(value=ScopeType.CONVERSATION)
public class CreateContentBackedResourceAction
extends AbstractFileUploadAction
implements Serializable {
    private static final String INITIAL_PACKAGE_VERSION = "1.0";
    private final Log log = LogFactory.getLog(this.getClass());
    private final ResourceManager resourceManager = ResourceManagerFactory.resourceManager();
    @Out(required=false)
    private ConfigurationDefinition configurationDefinition;
    @Out(required=false)
    private Configuration configuration;
    @Out
    private ResourceType resourceType;
    private PackageType packageType;

    @Begin(join=true)
    public String init() {
        JONTreeNode selectedNode = this.navigationAction.getSelectedNode();
        ResourceTypeTreeNode resourceTypeTreeNode = (ResourceTypeTreeNode)selectedNode;
        this.resourceType = resourceTypeTreeNode.getResourceType();
        this.packageType = ContentUtility.getCreationPackageType((ResourceType)this.resourceType);
        if (this.packageType == null) {
            this.facesMessages.addFromResourceBundle(FacesMessage.SEVERITY_ERROR, "content.resourceInstance.create.resourceTypeHasNoCreationPackageType", new Object[0]);
            return "failure";
        }
        this.configurationDefinition = this.packageType.getDeploymentConfigurationDefinition();
        this.configuration = ContentUtility.getDefaultDeploymentConfiguration((PackageType)this.packageType);
        return "success";
    }

    @End(ifOutcome={"success"})
    public String createContentBackedResource() {
        File tempFile;
        if (this.getFileName() == null) {
            this.facesMessages.addFromResourceBundle(FacesMessage.SEVERITY_ERROR, "content.resourceInstance.create.noFileSelected", new Object[0]);
            return "failure";
        }
        this.log.debug((Object)("Creating content-backed " + this.resourceType + " Resource " + this.getFileName() + "..."));
        try {
            tempFile = this.writeTempFile();
        }
        catch (IOException e) {
            return "failure";
        }
        ContentSourcePackageDetailsKey key = new ContentSourcePackageDetailsKey(tempFile.getPath(), INITIAL_PACKAGE_VERSION, this.packageType.getName(), "no-arch", this.resourceType.getName(), this.resourceType.getPlugin());
        ResourcePackageDetails detail = new ResourcePackageDetails((PackageDetailsKey)key);
        detail.setDeploymentTimeConfiguration(this.configuration);
        Configuration pluginConfiguration = null;
        JONTreeNode currentNode = this.navigationAction.getSelectedNode();
        Resource ancestorResource = currentNode.getClosestResource();
        String resourceName = this.getFileName();
        CreateResourceResponse createResourceResponse = this.resourceManager.createResource(resourceName, this.resourceType, ancestorResource, pluginConfiguration, detail);
        switch (1.$SwitchMap$org$rhq$core$domain$resource$CreateResourceStatus[createResourceResponse.getStatus().ordinal()]) {
            case 1: {
                this.facesMessages.addFromResourceBundle(FacesMessage.SEVERITY_INFO, "content.resourceInstance.create.success", new Object[]{this.getFileName()});
                return "success";
            }
        }
        String cause = createResourceResponse.getErrorMessage() != null ? createResourceResponse.getErrorMessage() : "unknown";
        this.facesMessages.addFromResourceBundle(FacesMessage.SEVERITY_ERROR, "content.resourceInstance.create.failure", new Object[]{this.getFileName(), cause});
        return "failure";
    }
}

