/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.embedded.ui.nav;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.on.embedded.manager.ResourceManager;
import org.jboss.on.embedded.manager.ResourceManagerFactory;
import org.jboss.on.embedded.ui.SummaryAction;
import org.jboss.on.embedded.ui.nav.BaseTreeNode;
import org.jboss.on.embedded.ui.nav.JONTreeNode;
import org.jboss.on.embedded.ui.nav.NonSingletonResourceTypeTreeNode;
import org.jboss.on.embedded.ui.nav.ResourceTypeTreeNode;
import org.jboss.on.embedded.ui.nav.SingletonResourceTypeTreeNode;
import org.jboss.on.embedded.ui.nav.SubCategoryTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceSubCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.richfaces.model.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public abstract class BaseTreeNode
implements JONTreeNode {
    private JONTreeNode parent;
    protected Map<Object, JONTreeNode> childrenMap;
    private String key;
    private static final AtomicInteger nodeKey = new AtomicInteger();

    public BaseTreeNode(String key) {
        this.key = key;
    }

    private Map<Object, JONTreeNode> getChildrenMap() {
        if (this.childrenMap == null) {
            this.childrenMap = new LinkedHashMap();
            this.initChildrenMap();
        }
        return this.childrenMap;
    }

    protected abstract void initChildrenMap();

    public abstract SummaryAction.SummaryActionOutcome getSummaryActionOutcome(SummaryAction var1);

    public void reInitializeChildrenMap() {
        if (this.childrenMap != null) {
            this.childrenMap.clear();
            this.childrenMap = null;
        }
        this.getChildrenMap();
    }

    public Object getData() {
        return this;
    }

    public void setData(Object object) {
    }

    public boolean isLeaf() {
        return this.getChildrenMap().isEmpty();
    }

    public Iterator<Map.Entry<Object, JONTreeNode>> getChildren() {
        return this.getChildrenMap().entrySet().iterator();
    }

    public Collection<JONTreeNode> getChildNodes() {
        return this.getChildrenMap().values();
    }

    public List<JONTreeNode> getChildNodesAsList() {
        return new ArrayList<JONTreeNode>(this.getChildNodes());
    }

    public JONTreeNode getChild(Object key) {
        return (JONTreeNode)this.getChildrenMap().get(key);
    }

    public void addChild(BaseTreeNode child) {
        this.addChild((Object)child.getKey(), (TreeNode)child);
    }

    private String getKey() {
        return this.key;
    }

    public void addChild(Object key, TreeNode child) {
        child.setParent((TreeNode)this);
        this.getChildrenMap().put(key, (JONTreeNode)child);
    }

    public void removeChild(Object key) {
        JONTreeNode treeNode = (JONTreeNode)this.getChildrenMap().remove(key);
        if (treeNode != null) {
            treeNode.setParent(null);
        }
    }

    public JONTreeNode getParent() {
        return this.parent;
    }

    public void setParent(TreeNode treeNode) {
        this.parent = (JONTreeNode)treeNode;
    }

    public static String getUniqueKey() {
        return String.valueOf(nodeKey.incrementAndGet());
    }

    protected void addChildResourceTypeNode(@NotNull ResourceType resourceType, @NotNull Resource parentResource) {
        this.addChildResourceTypeNode(resourceType, parentResource, true);
    }

    protected void addChildResourceTypeNodeWithSubCategory(@NotNull ResourceType resourceType, @NotNull Resource parentResource) {
        this.addChildResourceTypeNode(resourceType, parentResource, false);
    }

    private void addChildResourceTypeNode(@NotNull ResourceType resourceType, @NotNull Resource parentResource, boolean ignoreSubCategorizedResources) {
        if (resourceType == null) {
            throw new IllegalArgumentException("ResourceType cannot be null");
        }
        if (ignoreSubCategorizedResources && resourceType.getSubCategory() != null) {
            return;
        }
        Set resources = this.getResourceManager().getResources(resourceType, parentResource);
        if (resourceType.isSingleton() && !resources.isEmpty()) {
            if (resources.size() > 1) {
                throw new IllegalArgumentException("ResourceType [" + resourceType + "] has more than one resource " + "associated with it, yet it is specified as a Singleton");
            }
            this.addChild((BaseTreeNode)new SingletonResourceTypeTreeNode(BaseTreeNode.getUniqueKey(), resourceType, (Resource)resources.iterator().next(), parentResource));
        } else if (!(resourceType.isSingleton() || resources.isEmpty() && !resourceType.isCreatable())) {
            this.addChild((BaseTreeNode)new NonSingletonResourceTypeTreeNode(BaseTreeNode.getUniqueKey(), resourceType, parentResource));
        }
    }

    protected void addChildResourceTypeOrSubCategoryNodes(@NotNull ResourceType resourceType, @NotNull Resource parentResource) {
        if (resourceType == null) {
            throw new IllegalArgumentException("ResourceType cannot be null");
        }
        Set childResourceTypes = resourceType.getChildResourceTypes();
        for (ResourceType childResourceType : childResourceTypes) {
            this.addChildResourceTypeNode(childResourceType, parentResource);
        }
        List subCategories = resourceType.getChildSubCategories();
        TreeSet sortedSubCategories = new TreeSet(subCategories);
        for (ResourceSubCategory subCategory : sortedSubCategories) {
            this.addChild((BaseTreeNode)new SubCategoryTreeNode(BaseTreeNode.getUniqueKey(), subCategory, parentResource));
        }
    }

    public ResourceManager getResourceManager() {
        return ResourceManagerFactory.resourceManager();
    }

    @Nullable
    public JONTreeNode findNode(@Nullable String path) {
        if (path != null && !path.equals("")) {
            return this.findNode((JONTreeNode)this, (NodeMatcher)new PathBasedNodeMatcher(this, path));
        }
        return null;
    }

    @Nullable
    public JONTreeNode findNodeByTypeName(@Nullable String typeName) {
        if (typeName != null && !typeName.equals("")) {
            return this.findNode((JONTreeNode)this, (NodeMatcher)new ResourceTypeNameNodeMatcher(this, typeName));
        }
        return null;
    }

    public ResourceTypeTreeNode findNodeByType(@NotNull ResourceType resourceType) {
        if (resourceType != null) {
            return (ResourceTypeTreeNode)this.findNode((JONTreeNode)this, (NodeMatcher)new ResourceTypeNodeMatcher(this, resourceType));
        }
        return null;
    }

    private JONTreeNode findNode(JONTreeNode currentNode, NodeMatcher matcher) {
        JONTreeNode resultNode = null;
        if (matcher.matchesNode(currentNode)) {
            resultNode = currentNode;
        } else {
            JONTreeNode child;
            Iterator i$ = currentNode.getChildNodes().iterator();
            while (i$.hasNext() && (resultNode = this.findNode(child = (JONTreeNode)i$.next(), matcher)) == null) {
            }
        }
        return resultNode;
    }
}

