/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.eis.adapters.xmlfile;

import java.io.File;
import java.util.List;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import javax.resource.cci.ResourceWarning;
import org.eclipse.persistence.eis.EISDOMRecord;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.internal.eis.adapters.xmlfile.XMLFileConnection;
import org.eclipse.persistence.internal.eis.adapters.xmlfile.XMLFileInteractionSpec;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.oxm.XMLField;

public class XMLFileInteraction
implements Interaction {
    protected XMLFileConnection connection;

    public XMLFileInteraction(XMLFileConnection connection) {
        this.connection = connection;
    }

    public void clearWarnings() {
    }

    public void close() {
    }

    public Record execute(InteractionSpec spec, Record input) throws ResourceException {
        boolean autocommit = false;
        if (!this.connection.getXMLFileTransaction().isInTransaction()) {
            autocommit = true;
            this.connection.getXMLFileTransaction().begin();
        }
        try {
            XMLFileInteractionSpec xmlSpec = (XMLFileInteractionSpec)spec;
            File file = new File(String.valueOf(this.connection.getConnectionSpec().getDirectory()) + "/" + xmlSpec.getFileName());
            Record recordToReturn = null;
            if (xmlSpec.getInteractionType() == 1) {
                autocommit = false;
                recordToReturn = this.executeRead(xmlSpec, file);
            } else if (xmlSpec.getInteractionType() == 0) {
                recordToReturn = this.executeInsert(xmlSpec, file, (EISDOMRecord)input);
            } else if (xmlSpec.getInteractionType() == 2) {
                recordToReturn = this.executeUpdate(xmlSpec, file, (EISDOMRecord)input);
            } else if (xmlSpec.getInteractionType() == 3) {
                recordToReturn = this.executeDelete(xmlSpec, file);
            }
            if (recordToReturn != null) {
                ((EISDOMRecord)recordToReturn).setSession(((EISDOMRecord)input).getSession());
            }
            Record record = recordToReturn;
            return record;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ResourceException(exception.toString());
        }
        finally {
            if (autocommit) {
                this.connection.getXMLFileTransaction().commit();
            }
        }
    }

    public Record executeRead(XMLFileInteractionSpec spec, File file) throws Exception {
        if (!file.exists()) {
            return null;
        }
        EISDOMRecord fileRecord = this.connection.getXMLFileTransaction().retrieveDOMRecord(file);
        if (spec.getXPath() != null) {
            Object result = fileRecord.getValues(this.buildField(spec));
            EISDOMRecord output = new EISDOMRecord();
            if (result instanceof List) {
                List results = (List)result;
                output.setDOM(output.createNewDocument("results"));
                if (results != null) {
                    int index = 0;
                    while (index < results.size()) {
                        output.add(new DatabaseField("result"), results.get(index));
                        ++index;
                    }
                }
            } else {
                output.setDOM(output.createNewDocument("results"));
                output.add(new DatabaseField("result"), result);
            }
            return output;
        }
        return fileRecord;
    }

    public Record executeInsert(XMLFileInteractionSpec spec, File file, EISDOMRecord input) throws Exception {
        EISDOMRecord outputToFile = input;
        if (spec.getXPath() != null) {
            outputToFile = this.connection.getXMLFileTransaction().retrieveDOMRecord(file);
            outputToFile.add(this.buildField(spec), input);
        }
        return null;
    }

    public Record executeUpdate(XMLFileInteractionSpec spec, File file, EISDOMRecord input) throws Exception {
        if (!file.exists()) {
            return null;
        }
        EISDOMRecord outputToFile = input;
        if (spec.getXPath() != null) {
            outputToFile = this.connection.getXMLFileTransaction().retrieveDOMRecord(file);
            outputToFile.put(this.buildField(spec), (Object)input);
        }
        return null;
    }

    public Record executeDelete(XMLFileInteractionSpec spec, File file) throws Exception {
        if (!file.exists()) {
            return null;
        }
        if (spec.getXPath() != null) {
            EISDOMRecord outputToFile = this.connection.getXMLFileTransaction().retrieveDOMRecord(file);
            outputToFile.remove(this.buildField(spec));
        } else {
            boolean success = file.delete();
            if (!success) {
                throw EISException.couldNotDeleteFile(new Object[]{file});
            }
        }
        return null;
    }

    public boolean execute(InteractionSpec spec, Record input, Record output) throws ResourceException {
        EISDOMRecord result = (EISDOMRecord)this.execute(spec, input);
        if (result == null) {
            return false;
        }
        ((EISDOMRecord)output).setDOM(result.getDOM());
        return true;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public ResourceWarning getWarnings() {
        return null;
    }

    protected DatabaseField buildField(XMLFileInteractionSpec spec) {
        XMLField xmlField = new XMLField(spec.getXPath());
        xmlField.setNamespaceResolver(spec.getNamespaceResolver());
        return xmlField;
    }
}

