/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.oxm.XMLBinaryDataHelper;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.ExtendedContentHandler;
import org.eclipse.persistence.internal.oxm.record.XMLFragmentReader;
import org.eclipse.persistence.oxm.CharacterEscapeHandler;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class JSONWriterRecord
extends MarshalRecord {
    protected Writer writer;
    protected boolean isStartElementOpen = false;
    protected boolean isProcessingCData = false;
    protected Stack<Level> levels = new Stack();
    protected static final String NULL = "null";
    protected String attributePrefix;
    protected boolean charactersAllowed = false;
    protected CharsetEncoder encoder;
    protected String space = "";
    protected CharacterEscapeHandler characterEscapeHandler;

    @Override
    public void setMarshaller(XMLMarshaller marshaller) {
        super.setMarshaller(marshaller);
        this.attributePrefix = marshaller.getAttributePrefix();
        this.encoder = Charset.forName(marshaller.getEncoding()).newEncoder();
        if (marshaller.getValueWrapper() != null) {
            this.textWrapperFragment = new XPathFragment(marshaller.getValueWrapper());
        }
        this.characterEscapeHandler = marshaller.getCharacterEscapeHandler();
    }

    @Override
    public boolean emptyCollection(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, boolean openGrouping) {
        if (this.marshaller.isMarshalEmptyCollections()) {
            super.emptyCollection(xPathFragment, namespaceResolver, true);
            this.startCollection();
            if (xPathFragment != null) {
                this.openStartElement(xPathFragment, namespaceResolver);
                if (!this.levels.isEmpty()) {
                    Level position = this.levels.peek();
                    position.setNeedToCloseComplex(false);
                    position.setNeedToOpenComplex(false);
                }
                this.endElement(xPathFragment, namespaceResolver);
            }
            this.endEmptyCollection();
            return true;
        }
        return super.emptyCollection(xPathFragment, namespaceResolver, openGrouping);
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void namespaceDeclaration(String prefix, String namespaceURI) {
    }

    @Override
    public void defaultNamespaceDeclaration(String defaultNamespace) {
    }

    @Override
    public void startDocument(String encoding, String version) {
        try {
            if (!this.levels.isEmpty()) {
                Level level = this.levels.peek();
                if (level.isFirst()) {
                    level.setFirst(false);
                } else {
                    this.writer.write(",");
                    this.writer.write(this.space);
                }
            }
            this.levels.push(new Level(true, false));
            this.writer.write(123);
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    @Override
    public void endDocument() {
        try {
            this.closeComplex();
            this.levels.pop();
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    @Override
    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        try {
            Level newLevel = null;
            Level position = null;
            if (this.levels.isEmpty()) {
                newLevel = new Level(true, true);
                this.levels.push(newLevel);
            } else {
                position = this.levels.peek();
                newLevel = new Level(true, true);
                this.levels.push(newLevel);
                if (position.isFirst()) {
                    position.setFirst(false);
                } else {
                    this.writer.write(44);
                }
            }
            if (xPathFragment.nameIsText() && position != null && position.isCollection() && position.isEmptyCollection()) {
                if (!this.charactersAllowed) {
                    throw JAXBException.jsonValuePropertyRequired("[");
                }
                this.writer.write(91);
                position.setEmptyCollection(false);
                position.setNeedToOpenComplex(false);
                this.charactersAllowed = true;
                return;
            }
            if (position != null && position.needToOpenComplex) {
                this.writer.write(123);
                position.needToOpenComplex = false;
                position.needToCloseComplex = true;
            }
            if (!position.isCollection() || position.isEmptyCollection()) {
                this.writeKey(xPathFragment);
                if (position.isCollection() && position.isEmptyCollection()) {
                    this.writer.write(91);
                    position.setEmptyCollection(false);
                }
            }
            this.charactersAllowed = true;
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    @Override
    public void element(XPathFragment frag) {
        try {
            if (this.isStartElementOpen) {
                this.writer.write(62);
                this.isStartElementOpen = false;
            }
            this.writer.write(60);
            this.writer.write(frag.getShortName());
            this.writer.write(47);
            this.writer.write(62);
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    @Override
    public void attribute(String namespaceURI, String localName, String qName, String value) {
        XPathFragment xPathFragment = new XPathFragment();
        xPathFragment.setNamespaceURI(namespaceURI);
        xPathFragment.setAttribute(true);
        xPathFragment.setLocalName(localName);
        this.openStartElement(xPathFragment, this.namespaceResolver);
        this.characters(null, value, null, false, true);
        this.endElement(xPathFragment, this.namespaceResolver);
    }

    @Override
    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, String value) {
        this.attribute(xPathFragment, namespaceResolver, (Object)value, null);
    }

    @Override
    public void startPrefixMappings(NamespaceResolver namespaceResolver) {
    }

    @Override
    public void endPrefixMappings(NamespaceResolver namespaceResolver) {
    }

    @Override
    public void closeStartElement() {
    }

    @Override
    public void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        try {
            if (!this.levels.isEmpty()) {
                Level position = this.levels.pop();
                if (position.needToOpenComplex) {
                    this.writer.write(123);
                    this.closeComplex();
                } else if (position.needToCloseComplex) {
                    this.closeComplex();
                }
                this.charactersAllowed = false;
            }
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    protected void closeComplex() throws IOException {
        this.writer.write(125);
    }

    @Override
    public void startCollection() {
        if (this.levels.isEmpty()) {
            try {
                this.writer.write(91);
                this.levels.push(new Level(true, false));
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        } else {
            this.levels.peek().setCollection(true);
            this.levels.peek().setEmptyCollection(true);
        }
    }

    protected void endEmptyCollection() {
        this.endCollection();
    }

    @Override
    public void endCollection() {
        try {
            if (this.levels.size() == 1) {
                this.writer.write(93);
            } else {
                Level position = this.levels.peek();
                if (position != null && position.isCollection() && !position.isEmptyCollection()) {
                    this.writer.write(93);
                }
            }
            this.levels.peek().setCollection(false);
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    @Override
    public void characters(String value) {
        this.characters(value, true, false);
    }

    public void characters(String value, boolean isString, boolean isAttribute) {
        boolean textWrapperOpened = false;
        if (!this.charactersAllowed && this.textWrapperFragment != null) {
            this.openStartElement(this.textWrapperFragment, this.namespaceResolver);
            textWrapperOpened = true;
        }
        Level position = this.levels.peek();
        position.setNeedToOpenComplex(false);
        try {
            if (isString) {
                this.writer.write(34);
                this.writeValue(value, isAttribute);
                this.writer.write(34);
            } else {
                this.writer.write(value);
            }
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
        if (textWrapperOpened && this.textWrapperFragment != null) {
            this.endElement(this.textWrapperFragment, this.namespaceResolver);
        }
    }

    @Override
    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, Object value, QName schemaType) {
        if (xPathFragment.getNamespaceURI() != null && xPathFragment.getNamespaceURI() == "http://www.w3.org/2000/xmlns/") {
            return;
        }
        xPathFragment.setAttribute(true);
        this.openStartElement(xPathFragment, namespaceResolver);
        this.characters(schemaType, value, null, false, true);
        this.endElement(xPathFragment, namespaceResolver);
    }

    @Override
    public void characters(QName schemaType, Object value, String mimeType, boolean isCDATA) {
        this.characters(schemaType, value, mimeType, isCDATA, false);
    }

    public void characters(QName schemaType, Object value, String mimeType, boolean isCDATA, boolean isAttribute) {
        Level position = this.levels.peek();
        position.setNeedToOpenComplex(false);
        if (mimeType != null) {
            value = XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesForBinaryValue(value, this.marshaller, mimeType).getData();
        }
        if (schemaType != null && XMLConstants.QNAME_QNAME.equals(schemaType)) {
            String convertedValue = this.getStringForQName((QName)value);
            this.characters(convertedValue);
        } else if (value.getClass() == String.class) {
            if (schemaType != null && this.isNumericOrBooleanType(schemaType)) {
                String convertedValue = (String)((XMLConversionManager)this.session.getDatasourcePlatform().getConversionManager()).convertObject(value, ClassConstants.STRING, schemaType);
                this.characters(convertedValue, false, isAttribute);
            } else if (isCDATA) {
                this.cdata((String)value);
            } else {
                this.characters((String)value);
            }
        } else {
            String convertedValue = (String)((XMLConversionManager)this.session.getDatasourcePlatform().getConversionManager()).convertObject(value, ClassConstants.STRING, schemaType);
            if (schemaType == null) {
                if (value.getClass() == ClassConstants.BOOLEAN || ClassConstants.NUMBER.isAssignableFrom(value.getClass())) {
                    this.characters(convertedValue, false, isAttribute);
                } else {
                    this.characters(convertedValue);
                }
            } else if (schemaType != null && !this.isNumericOrBooleanType(schemaType)) {
                this.characters(convertedValue);
            } else if (isCDATA) {
                this.cdata(convertedValue);
            } else {
                this.characters(convertedValue, false, isAttribute);
            }
        }
        this.charactersAllowed = false;
    }

    private boolean isNumericOrBooleanType(QName schemaType) {
        if (schemaType == null) {
            return false;
        }
        return schemaType.equals(XMLConstants.BOOLEAN_QNAME) || schemaType.equals(XMLConstants.INTEGER_QNAME) || schemaType.equals(XMLConstants.INT_QNAME) || schemaType.equals(XMLConstants.DECIMAL_QNAME) || schemaType.equals(XMLConstants.FLOAT_QNAME) || schemaType.equals(XMLConstants.DOUBLE_QNAME) || schemaType.equals(XMLConstants.SHORT_QNAME);
    }

    @Override
    public void namespaceDeclarations(NamespaceResolver namespaceResolver) {
    }

    @Override
    public void nilComplex(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.closeStartGroupingElements(groupingFragment);
        this.openStartElement(xPathFragment, namespaceResolver);
        this.characters(NULL, false, false);
        this.endElement(xPathFragment, namespaceResolver);
    }

    @Override
    public void nilSimple(NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.characters(NULL, false, false);
        this.closeStartGroupingElements(groupingFragment);
    }

    @Override
    public void emptySimple(NamespaceResolver namespaceResolver) {
        this.nilSimple(namespaceResolver);
    }

    @Override
    public void emptyComplex(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.closeStartGroupingElements(groupingFragment);
        this.openStartElement(xPathFragment, namespaceResolver);
        this.endElement(xPathFragment, namespaceResolver);
    }

    @Override
    public void marshalWithoutRootElement(TreeObjectBuilder treeObjectBuilder, Object object, XMLDescriptor descriptor, XMLRoot root, boolean isXMLRoot) {
        if (treeObjectBuilder != null) {
            treeObjectBuilder.addXsiTypeAndClassIndicatorIfRequired(this, descriptor, null, descriptor.getDefaultRootElementField(), root, object, isXMLRoot, true);
            treeObjectBuilder.marshalAttributes(this, object, this.session);
        }
    }

    @Override
    public void cdata(String value) {
        this.characters(value);
    }

    @Override
    public char getNamespaceSeparator() {
        return this.marshaller.getNamespaceSeparator();
    }

    @Override
    public XPathFragment getTextWrapperFragment() {
        return this.textWrapperFragment;
    }

    protected void writeKey(XPathFragment xPathFragment) throws IOException {
        super.openStartElement(xPathFragment, this.namespaceResolver);
        this.isStartElementOpen = true;
        this.writer.write(34);
        if (xPathFragment.isAttribute() && this.attributePrefix != null) {
            this.writer.write(this.attributePrefix);
        }
        if (this.isNamespaceAware() && xPathFragment.getNamespaceURI() != null) {
            String prefix = null;
            if (this.getNamespaceResolver() != null) {
                prefix = this.getNamespaceResolver().resolveNamespaceURI(xPathFragment.getNamespaceURI());
            } else if (this.namespaceResolver != null) {
                prefix = this.namespaceResolver.resolveNamespaceURI(xPathFragment.getNamespaceURI());
            }
            if (prefix != null && !prefix.equals("")) {
                this.writer.write(prefix);
                this.writer.write(this.getNamespaceSeparator());
            }
        }
        this.writer.write(xPathFragment.getLocalName());
        this.writer.write("\"");
        this.writer.write(this.space);
        this.writer.write(58);
        this.writer.write(this.space);
    }

    protected void writeValue(String value, boolean isAttribute) {
        try {
            if (this.characterEscapeHandler != null) {
                try {
                    this.characterEscapeHandler.escape(value.toCharArray(), 0, value.length(), isAttribute, this.writer);
                }
                catch (IOException e) {
                    throw XMLMarshalException.marshalException(e);
                }
                return;
            }
            char[] chars = value.toCharArray();
            int x = 0;
            int charsSize = chars.length;
            while (x < charsSize) {
                char character = chars[x];
                switch (character) {
                    case '\"': {
                        this.writer.write("\\\"");
                        break;
                    }
                    case '\b': {
                        this.writer.write("\\");
                        this.writer.write("b");
                        break;
                    }
                    case '\f': {
                        this.writer.write("\\");
                        this.writer.write("f");
                        break;
                    }
                    case '\n': {
                        this.writer.write("\\");
                        this.writer.write("n");
                        break;
                    }
                    case '\r': {
                        this.writer.write("\\");
                        this.writer.write("r");
                        break;
                    }
                    case '\t': {
                        this.writer.write("\\");
                        this.writer.write("t");
                        break;
                    }
                    case '\\': {
                        this.writer.write("\\");
                        this.writer.write("\\");
                        break;
                    }
                    default: {
                        if (Character.isISOControl(character) || !this.encoder.canEncode(character)) {
                            this.writer.write("\\u");
                            String hex = Integer.toHexString(character).toUpperCase();
                            int i = hex.length();
                            while (i < 4) {
                                this.writer.write("0");
                                ++i;
                            }
                            this.writer.write(hex);
                            break;
                        }
                        this.writer.write(character);
                    }
                }
                ++x;
            }
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    @Override
    protected String getStringForQName(QName qName) {
        if (qName == null) {
            return null;
        }
        XMLConversionManager xmlConversionManager = (XMLConversionManager)this.getSession().getDatasourcePlatform().getConversionManager();
        return (String)xmlConversionManager.convertObject(qName, String.class);
    }

    @Override
    public void node(Node node, NamespaceResolver namespaceResolver) {
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            String resolverPfx = null;
            if (this.getNamespaceResolver() != null) {
                resolverPfx = this.getNamespaceResolver().resolveNamespaceURI(attr.getNamespaceURI());
            }
            attr.getNamespaceURI();
            if (resolverPfx != null) {
                this.attribute(attr.getNamespaceURI(), "", String.valueOf(resolverPfx) + ':' + attr.getLocalName(), attr.getNodeValue());
            } else {
                this.attribute(attr.getNamespaceURI(), "", attr.getName(), attr.getNodeValue());
                if (attr.getNamespaceURI() != null) {
                    this.attribute("http://www.w3.org/2000/xmlns/", "", "xmlns:" + attr.getPrefix(), attr.getNamespaceURI());
                    this.getNamespaceResolver().put(attr.getPrefix(), attr.getNamespaceURI());
                }
            }
        } else if (node.getNodeType() == 3) {
            this.characters(node.getNodeValue(), false, false);
        } else {
            try {
                JSONWriterRecordContentHandler wrcHandler = new JSONWriterRecordContentHandler();
                XMLFragmentReader xfragReader = new XMLFragmentReader(namespaceResolver);
                xfragReader.setContentHandler(wrcHandler);
                xfragReader.setProperty("http://xml.org/sax/properties/lexical-handler", wrcHandler);
                xfragReader.parse(node);
            }
            catch (SAXException sex) {
                throw XMLMarshalException.marshalException(sex);
            }
        }
    }

    protected class JSONWriterRecordContentHandler
    implements ExtendedContentHandler,
    LexicalHandler {
        JSONWriterRecordContentHandler() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            XPathFragment xPathFragment = new XPathFragment(localName);
            xPathFragment.setNamespaceURI(namespaceURI);
            JSONWriterRecord.this.openStartElement(xPathFragment, JSONWriterRecord.this.namespaceResolver);
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            XPathFragment xPathFragment = new XPathFragment(localName);
            xPathFragment.setNamespaceURI(namespaceURI);
            JSONWriterRecord.this.endElement(xPathFragment, JSONWriterRecord.this.namespaceResolver);
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String characters = new String(ch, start, length);
            this.characters(characters);
        }

        @Override
        public void characters(CharSequence characters) throws SAXException {
            JSONWriterRecord.this.characters(characters.toString());
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
            JSONWriterRecord.this.isProcessingCData = true;
        }

        @Override
        public void endCDATA() throws SAXException {
            JSONWriterRecord.this.isProcessingCData = false;
        }

        protected void handleAttributes(Attributes atts) {
            int i = 0;
            int attsLength = atts.getLength();
            while (i < attsLength) {
                String qName = atts.getQName(i);
                if (qName == null || !qName.startsWith("xmlns:") && !qName.equals("xmlns")) {
                    JSONWriterRecord.this.attribute(atts.getURI(i), atts.getLocalName(i), qName, atts.getValue(i));
                }
                ++i;
            }
        }

        protected void writeComment(char[] chars, int start, int length) {
        }

        protected void writeCharacters(char[] chars, int start, int length) {
            try {
                this.characters(chars, start, length);
            }
            catch (SAXException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }
    }

    protected static class Level {
        private boolean first;
        private boolean collection;
        private boolean emptyCollection;
        private boolean needToOpenComplex;
        private boolean needToCloseComplex;

        public Level(boolean value, boolean needToOpen) {
            this.first = value;
            this.needToOpenComplex = needToOpen;
        }

        public boolean isNeedToOpenComplex() {
            return this.needToOpenComplex;
        }

        public void setNeedToOpenComplex(boolean needToOpenComplex) {
            this.needToOpenComplex = needToOpenComplex;
        }

        public boolean isNeedToCloseComplex() {
            return this.needToCloseComplex;
        }

        public void setNeedToCloseComplex(boolean needToCloseComplex) {
            this.needToCloseComplex = needToCloseComplex;
        }

        public boolean isEmptyCollection() {
            return this.emptyCollection;
        }

        public void setEmptyCollection(boolean emptyCollection) {
            this.emptyCollection = emptyCollection;
        }

        public boolean isFirst() {
            return this.first;
        }

        public void setFirst(boolean value) {
            this.first = value;
        }

        public boolean isCollection() {
            return this.collection;
        }

        public void setCollection(boolean collection) {
            this.collection = collection;
        }
    }
}

