/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl;

import java.util.List;
import org.jboss.aesh.cl.CommandLine;
import org.jboss.aesh.cl.OptionProperty;
import org.jboss.aesh.cl.ParsedOption;
import org.jboss.aesh.cl.internal.OptionInt;
import org.jboss.aesh.cl.internal.ParameterInt;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.util.Parser;

public class CommandLineParser {
    private ParameterInt param;
    private static final String EQUALS = "=";

    public CommandLineParser(ParameterInt parameterInt) {
        this.param = parameterInt;
    }

    public CommandLineParser(String name, String usage) {
        this.param = new ParameterInt(name, usage);
    }

    public void addOption(char name, String longName, String description, boolean hasValue, String argument, boolean required, boolean hasMultipleValues, Object type) {
        this.param.addOption(name, longName, description, hasValue, argument, required, hasMultipleValues, type);
    }

    public void addOption(char name, String longName, String description, boolean hasValue) {
        this.param.addOption(name, longName, description, hasValue, null, false, false, null);
    }

    protected ParameterInt getParameter() {
        return this.param;
    }

    public String printHelp() {
        int maxLength = 0;
        int width = 80;
        for (OptionInt o : this.getParameter().getOptions()) {
            if (o.getFormattedLength() <= maxLength) continue;
            maxLength = o.getFormattedLength();
        }
        StringBuilder sb = new StringBuilder();
        for (OptionInt o : this.getParameter().getOptions()) {
            sb.append(o.getFormattedOption(2, maxLength + 4, width)).append(Config.getLineSeparator());
        }
        return "Usage: " + this.getParameter().getName() + " " + this.getParameter().getUsage() + Config.getLineSeparator() + sb.toString();
    }

    public CommandLine parse(String line) throws IllegalArgumentException {
        this.param.clean();
        List<String> lines = Parser.findAllWords(line);
        CommandLine commandLine = new CommandLine();
        OptionInt active = null;
        for (int i = 1; i < lines.size(); ++i) {
            String name;
            String parseLine = lines.get(i);
            if (parseLine.startsWith("--")) {
                if (active != null) {
                    throw new IllegalArgumentException("Option: " + active.getName() + " must be given a value");
                }
                active = this.findLongOption(parseLine.substring(2));
                if (active != null && active.isProperty()) {
                    if (parseLine.length() <= 2 + active.getLongName().length() || !parseLine.contains(EQUALS)) {
                        throw new IllegalArgumentException("Option " + active.getLongName() + ", must be part of a property");
                    }
                    name = parseLine.substring(2 + active.getLongName().length(), parseLine.indexOf(EQUALS));
                    String value = parseLine.substring(parseLine.indexOf(EQUALS) + 1);
                    commandLine.addOption(new ParsedOption(active.getName(), active.getLongName(), new OptionProperty(name, value)));
                    active = null;
                    continue;
                }
                if (!(active == null || active.hasValue() && active.getValue() == null)) {
                    commandLine.addOption(new ParsedOption(active.getName(), active.getLongName(), active.getValue()));
                    active = null;
                    continue;
                }
                if (active != null) continue;
                throw new IllegalArgumentException("Option: " + parseLine + " is not a valid option for this command");
            }
            if (parseLine.startsWith("-")) {
                if (active != null) {
                    throw new IllegalArgumentException("Option: " + active.getName() + " must be given a value");
                }
                if (parseLine.length() != 2 && !parseLine.contains(EQUALS)) {
                    throw new IllegalArgumentException("Option: - must be followed by a valid operator");
                }
                active = this.findOption(parseLine.substring(1));
                if (active != null && active.isProperty()) {
                    if (parseLine.length() <= 2 || !parseLine.contains(EQUALS)) {
                        throw new IllegalArgumentException("Option " + active.getName() + ", must be part of a property");
                    }
                    name = parseLine.substring(2, parseLine.indexOf(EQUALS));
                    String value = parseLine.substring(parseLine.indexOf(EQUALS) + 1);
                    commandLine.addOption(new ParsedOption(active.getName(), active.getLongName(), new OptionProperty(name, value)));
                    active = null;
                    continue;
                }
                if (!(active == null || active.hasValue() && active.getValue() == null)) {
                    commandLine.addOption(new ParsedOption(String.valueOf(active.getName()), active.getLongName(), active.getValue()));
                    active = null;
                    continue;
                }
                if (active != null) continue;
                throw new IllegalArgumentException("Option: " + parseLine + " is not a valid option for this command");
            }
            if (active != null) {
                if (active.hasMultipleValues()) {
                    if (parseLine.contains(String.valueOf(active.getValueSeparator()))) {
                        for (String value : parseLine.split(String.valueOf(active.getValueSeparator()))) {
                            active.addValue(value.trim());
                        }
                    }
                } else {
                    active.addValue(parseLine);
                }
                commandLine.addOption(new ParsedOption(active.getName(), active.getLongName(), active.getValues()));
                active = null;
                continue;
            }
            commandLine.addArgument(parseLine);
        }
        this.checkForMissingRequiredOptions(commandLine);
        return commandLine;
    }

    private void checkForMissingRequiredOptions(CommandLine commandLine) throws IllegalArgumentException {
        for (OptionInt o : this.param.getOptions()) {
            if (!o.isRequired()) continue;
            boolean found = false;
            for (ParsedOption po : commandLine.getOptions()) {
                if (!po.getName().equals(o.getName()) && !po.getName().equals(o.getLongName())) continue;
                found = true;
            }
            if (found) continue;
            throw new IllegalArgumentException("Option: " + o.getName() + " is required for this command.");
        }
    }

    private OptionInt findOption(String line) {
        String rest;
        OptionInt option = this.param.findOption(line);
        if (option != null) {
            return option;
        }
        option = this.param.startWithOption(line);
        if (option != null && option.isProperty()) {
            return option;
        }
        if (option != null && (rest = line.substring(option.getName().length())) != null && rest.length() > 1 && rest.startsWith(EQUALS)) {
            option.addValue(rest.substring(1));
            return option;
        }
        return null;
    }

    private OptionInt findLongOption(String line) {
        String rest;
        OptionInt option = this.param.findLongOption(line);
        if (option != null) {
            return option;
        }
        option = this.param.startWithLongOption(line);
        if (option != null && option.isProperty()) {
            return option;
        }
        if (option != null && (rest = line.substring(option.getLongName().length())) != null && rest.length() > 1 && rest.startsWith(EQUALS)) {
            option.addValue(rest.substring(1));
            return option;
        }
        return null;
    }
}

