/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.trycatch;

import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.batch.Batch;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.handlers.trycatch.TryBlock;

public class CatchHandler
extends CommandHandlerWithHelp {
    public CatchHandler() {
        super("catch", true);
    }

    @Override
    public boolean isAvailable(CommandContext ctx) {
        try {
            TryBlock tryBlock = TryBlock.get(ctx);
            return tryBlock != null && tryBlock.isInTry();
        }
        catch (CommandLineException e) {
            return false;
        }
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        TryBlock tryBlock = TryBlock.get(ctx);
        BatchManager batchManager = ctx.getBatchManager();
        if (!batchManager.isBatchActive()) {
            throw new CommandLineException("try block did not activate batch mode.");
        }
        Batch tryBatch = batchManager.getActiveBatch();
        if (tryBatch.size() == 0) {
            throw new CommandLineException("try block is empty.");
        }
        tryBlock.setTryRequest(tryBatch.toRequest());
        tryBlock.setInCatch();
        batchManager.discardActiveBatch();
        batchManager.activateNewBatch();
    }
}

