/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.loom;

import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.loom.MigratorEngine;
import org.jboss.loom.conf.AS7Config;
import org.jboss.loom.conf.Configuration;
import org.jboss.loom.conf.GlobalConfiguration;
import org.jboss.loom.ex.MigrationException;
import org.jboss.loom.ex.RollbackMigrationException;
import org.jboss.loom.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigratorApp {
    private static final Logger log = LoggerFactory.getLogger(MigratorApp.class);

    public static void main(String[] args) {
        if (args.length == 0) {
            Utils.writeHelp();
            return;
        }
        Configuration configuration = MigratorApp.parseArguments(args);
        if (null == configuration) {
            System.exit(1);
        }
        MigratorApp.applyDefaults(configuration);
        List<String> problems = MigratorApp.validateConfiguration(configuration);
        if (!problems.isEmpty()) {
            for (String problem : problems) {
                log.error(problem);
            }
            System.exit(1);
        }
        try {
            MigratorApp.migrate(configuration);
        }
        catch (MigrationException ex) {
            log.error("Migration failed (details at DEBUG level): " + ex.getMessage());
            log.debug("Migration failed: ", ex);
        }
    }

    private static Configuration parseArguments(String[] args) {
        GlobalConfiguration globalConfig = new GlobalConfiguration();
        LinkedList<Configuration.ModuleSpecificProperty> moduleConfigs = new LinkedList<Configuration.ModuleSpecificProperty>();
        for (String arg : args) {
            if (arg.startsWith("--help")) {
                Utils.writeHelp();
                return null;
            }
            if (arg.startsWith("--as5.dir=") || arg.startsWith("as5.dir=")) {
                globalConfig.getAS5Config().setDir(StringUtils.substringAfter(arg, "="));
                continue;
            }
            if (arg.startsWith("--as7.dir=") || arg.startsWith("as7.dir=")) {
                globalConfig.getAS7Config().setDir(StringUtils.substringAfter(arg, "="));
                continue;
            }
            if (arg.startsWith("--as5.profile=")) {
                globalConfig.getAS5Config().setProfileName(StringUtils.substringAfter(arg, "="));
                continue;
            }
            if (arg.startsWith("--as7.confPath=")) {
                globalConfig.getAS7Config().setConfigPath(StringUtils.substringAfter(arg, "="));
                continue;
            }
            if (arg.startsWith("--as7.mgmt=")) {
                MigratorApp.parseMgmtConn(StringUtils.substringAfter(arg, "="), globalConfig.getAS7Config());
                continue;
            }
            if (arg.startsWith("--app.path=")) {
                globalConfig.setAppPath(StringUtils.substringAfter(arg, "="));
                continue;
            }
            if (arg.startsWith("--valid.skip")) {
                globalConfig.setSkipValidation(true);
                continue;
            }
            if (arg.startsWith("--conf.")) {
                String conf = StringUtils.substringAfter(arg, ".");
                String module = StringUtils.substringBefore(conf, ".");
                String propName = StringUtils.substringAfter(conf, ".");
                int pos = propName.indexOf(61);
                String value = null;
                if (pos == -1) {
                    value = propName.substring(pos + 1);
                    propName = propName.substring(0, pos);
                }
                moduleConfigs.add(new Configuration.ModuleSpecificProperty(module, propName, value));
            }
            System.err.println("Warning: Unknown argument: " + arg + " !");
            Utils.writeHelp();
        }
        Configuration configuration = new Configuration();
        configuration.setModuleConfigs(moduleConfigs);
        configuration.setGlobalConfig(globalConfig);
        return configuration;
    }

    private static void applyDefaults(Configuration configuration) {
    }

    public static List<String> validateConfiguration(Configuration config) {
        LinkedList<String> problems = new LinkedList<String>();
        String path = config.getGlobal().getAS5Config().getDir();
        if (null == path) {
            problems.add("as5.dir was not set.");
        } else if (!new File(path).isDirectory()) {
            problems.add("as5.dir is not a directory: " + path);
        } else {
            File profileDir;
            String profileName = config.getGlobal().getAS5Config().getProfileName();
            if (null != profileName && !(profileDir = config.getGlobal().getAS5Config().getProfileDir()).exists()) {
                problems.add("as5.profile is not a subdirectory in AS 5 dir: " + profileDir.getPath());
            }
        }
        AS7Config as7Config = config.getGlobal().getAS7Config();
        path = as7Config.getDir();
        if (null == path) {
            problems.add("as7.dir was not set.");
        } else if (!new File(path).isDirectory()) {
            problems.add("as7.dir is not a directory: " + path);
        } else {
            File configFile;
            String configPath = as7Config.getConfigFilePath();
            if (null != configPath && !(configFile = new File(path, configPath)).exists()) {
                log.warn("as7.confPath is not a subpath under AS 7 dir: " + configFile.getPath());
            }
        }
        if (as7Config.getManagementPort() == -1) {
            problems.add("as7.mgmt doesn't contain valid port after ':'.");
        } else {
            ModelControllerClient client = null;
            try {
                client = ModelControllerClient.Factory.create(as7Config.getHost(), as7Config.getManagementPort());
                client.close();
            }
            catch (UnknownHostException ex) {
                problems.add("Can't connect to AS 7 management: " + as7Config.getHost() + ":" + as7Config.getManagementPort());
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        path = config.getGlobal().getAppPath();
        if (null != path && !new File(path).exists()) {
            problems.add("App path was set but does not exist: " + path);
        }
        return problems;
    }

    public static void migrate(Configuration conf) throws MigrationException {
        log.info("Commencing migration.");
        MigratorEngine migrator = new MigratorEngine(conf);
        try {
            migrator.doMigration();
            log.info("");
            log.info("Migration was successful.");
        }
        catch (Throwable ex) {
            log.error("Migration failed. See previous messages for progress. ");
            if (ex instanceof RollbackMigrationException) {
                log.error("Yet, the rollback attempt failed as well. The server configuration may have ended up in an inconsistent state!");
                log.error("");
                RollbackMigrationException rollEx = (RollbackMigrationException)ex;
                log.error("Rollback failure cause: " + rollEx.getRollbackCause(), rollEx.getRollbackCause());
                ex = rollEx.getCause();
            }
            log.error("");
            log.error("Migration failure cause: " + ex, ex);
        }
    }

    private static void parseMgmtConn(String mgmtConn, AS7Config aS7Config) {
        String host = StringUtils.substringBefore(mgmtConn, ":");
        if (!mgmtConn.contains(":")) {
            return;
        }
        String port = StringUtils.substringAfter(mgmtConn, ":");
        aS7Config.setHost(host);
        try {
            aS7Config.setManagementPort(Integer.parseInt(port));
        }
        catch (NumberFormatException ex) {
            aS7Config.setManagementPort(-1);
        }
    }
}

