/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.loom;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.collections.map.MultiValueMap;
import org.eclipse.persistence.exceptions.JAXBException;
import org.jboss.as.cli.batch.BatchedCommand;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.loom.MigrationContext;
import org.jboss.loom.actions.CliCommandAction;
import org.jboss.loom.actions.IMigrationAction;
import org.jboss.loom.conf.AS7Config;
import org.jboss.loom.conf.Configuration;
import org.jboss.loom.conf.GlobalConfiguration;
import org.jboss.loom.ex.ActionException;
import org.jboss.loom.ex.CliBatchException;
import org.jboss.loom.ex.InitMigratorsExceptions;
import org.jboss.loom.ex.LoadMigrationException;
import org.jboss.loom.ex.MigrationException;
import org.jboss.loom.migrators.connectionFactories.ResAdapterMigrator;
import org.jboss.loom.migrators.dataSources.DatasourceMigrator;
import org.jboss.loom.migrators.deploymentScanner.DeploymentScannerMigrator;
import org.jboss.loom.migrators.logging.LoggingMigrator;
import org.jboss.loom.migrators.security.SecurityMigrator;
import org.jboss.loom.migrators.server.ServerMigrator;
import org.jboss.loom.spi.IMigrator;
import org.jboss.loom.utils.AS7CliUtils;
import org.jboss.loom.utils.Utils;
import org.jboss.loom.utils.as7.BatchFailure;
import org.jboss.loom.utils.as7.BatchedCommandWithAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class MigratorEngine {
    private static final Logger log = LoggerFactory.getLogger(MigratorEngine.class);
    private Configuration config;
    private MigrationContext ctx;
    private List<IMigrator> migrators;

    public MigratorEngine(Configuration config) throws InitMigratorsExceptions {
        this.config = config;
        this.init();
        this.resetContext(config.getGlobal().getAS7Config());
    }

    private void resetContext(AS7Config as7Config) {
        this.ctx = new MigrationContext(as7Config);
    }

    private void init() throws InitMigratorsExceptions {
        List<Class<? extends IMigrator>> migratorClasses = MigratorEngine.findMigratorClasses();
        Map<Class<? extends IMigrator>, IMigrator> migratorsMap = MigratorEngine.createMigrators(migratorClasses, this.config.getGlobal(), null);
        this.migrators = new ArrayList<IMigrator>(migratorsMap.values());
        for (IMigrator mig : this.migrators) {
            mig.setGlobalConfig(this.config.getGlobal());
            for (Configuration.ModuleSpecificProperty moduleOption : this.config.getModuleConfigs()) {
                mig.examineConfigProperty(moduleOption);
            }
        }
    }

    private static Map<Class<? extends IMigrator>, IMigrator> createMigrators(List<Class<? extends IMigrator>> migratorClasses, GlobalConfiguration globalConfig, MultiValueMap config) throws InitMigratorsExceptions {
        LinkedHashMap<Class<? extends IMigrator>, IMigrator> migs = new LinkedHashMap<Class<? extends IMigrator>, IMigrator>();
        LinkedList<Exception> exs = new LinkedList<Exception>();
        for (Class<? extends IMigrator> cls : migratorClasses) {
            try {
                Constructor<? extends IMigrator> ctor = cls.getConstructor(GlobalConfiguration.class, MultiValueMap.class);
                IMigrator mig = ctor.newInstance(globalConfig, config);
                migs.put(cls, mig);
            }
            catch (NoSuchMethodException ex) {
                String msg = cls.getName() + " doesn't have constructor ...(GlobalConfiguration globalConfig, MultiValueMap config).";
                log.error(msg);
                exs.add(new MigrationException(msg));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                log.error("Failed instantiating " + cls.getSimpleName() + ": " + ex.toString());
                log.debug("Stack trace: ", ex);
                exs.add(ex);
            }
        }
        if (!exs.isEmpty()) {
            throw new InitMigratorsExceptions(exs);
        }
        return migs;
    }

    private static List<Class<? extends IMigrator>> findMigratorClasses() {
        LinkedList<Class<? extends IMigrator>> migratorClasses = new LinkedList<Class<? extends IMigrator>>();
        migratorClasses.add(SecurityMigrator.class);
        migratorClasses.add(ServerMigrator.class);
        migratorClasses.add(DatasourceMigrator.class);
        migratorClasses.add(ResAdapterMigrator.class);
        migratorClasses.add(LoggingMigrator.class);
        migratorClasses.add(DeploymentScannerMigrator.class);
        return migratorClasses;
    }

    public void doMigration() throws MigrationException {
        log.info("Commencing migration.");
        AS7Config as7Config = this.config.getGlobal().getAS7Config();
        this.resetContext(as7Config);
        File as7configFile = new File(as7Config.getConfigFilePath());
        try {
            DocumentBuilder db = Utils.createXmlDocumentBuilder();
            Document doc = db.parse(as7configFile);
            this.ctx.setAS7ConfigXmlDoc(doc);
            doc = db.parse(as7configFile);
            this.ctx.setAs7ConfigXmlDocOriginal(doc);
        }
        catch (IOException | SAXException ex) {
            throw new MigrationException("Failed loading AS 7 config from " + as7configFile, ex);
        }
        String message = null;
        try {
            message = "Failed loading AS 5 config from " + as7configFile;
            this.loadAS5Data();
            this.openManagementClient();
            message = "Failed preparing the migration actions.";
            this.prepareActions();
            message = "Migration actions validation failed.";
            this.preValidateActions();
            message = "Failed creating backups for the migration actions.";
            this.backupActions();
            message = "Failed performing the migration actions.";
            this.performActions();
            message = "Verification of migration actions results failed.";
            this.postValidateActions();
            this.closeManagementClient();
        }
        catch (MigrationException ex) {
            this.rollbackActionsWhichWerePerformed();
            String description = "";
            if (ex instanceof ActionException) {
                IMigrationAction action = ((ActionException)ex).getAction();
                description = "\n    Migration action which caused the failure:   (from " + action.getFromMigrator().getSimpleName() + ")";
                if (action.getOriginStackTrace() != null) {
                    description = description + "\n\tat " + action.getOriginStackTrace().toString();
                }
                description = description + "\n    " + action.toDescription();
                if (action.getOriginMessage() != null) {
                    description = description + "\n    Purpose of the action: " + action.getOriginMessage();
                }
            }
            throw new MigrationException(message + "\n    " + ex.getMessage() + description, ex);
        }
        finally {
            this.cleanBackupsIfAny();
        }
    }

    private void prepareActions() throws MigrationException {
        log.debug("====== prepareActions() ========");
        try {
            for (IMigrator mig : this.migrators) {
                log.debug("    Preparing actions with " + mig.getClass().getSimpleName());
                mig.createActions(this.ctx);
            }
        }
        catch (JAXBException e) {
            throw new MigrationException(e);
        }
    }

    private void preValidateActions() throws MigrationException {
        log.debug("======== preValidateActions() ========");
        List<IMigrationAction> actions = this.ctx.getActions();
        for (IMigrationAction action : actions) {
            action.setMigrationContext(this.ctx);
            action.preValidate();
        }
    }

    private void backupActions() throws MigrationException {
        log.debug("======== backupActions() ========");
        List<IMigrationAction> actions = this.ctx.getActions();
        for (IMigrationAction action : actions) {
            action.backup();
        }
    }

    private void performActions() throws MigrationException {
        this.ctx.getBatch().clear();
        LinkedList<CliCommandAction> cliActions = new LinkedList<CliCommandAction>();
        log.info("Performing actions:");
        List<IMigrationAction> actions = this.ctx.getActions();
        for (IMigrationAction action : actions) {
            if (action instanceof CliCommandAction) {
                cliActions.add((CliCommandAction)action);
            }
            log.info("    " + action.toDescription());
            action.setMigrationContext(this.ctx);
            action.perform();
        }
        log.debug("CLI scripts in batch:");
        int i = 1;
        for (BatchedCommand command : this.ctx.getBatch().getCommands()) {
            log.debug("    " + i++ + ": " + command.getCommand());
        }
        log.debug("Executing CLI batch:");
        try {
            AS7CliUtils.executeRequest(this.ctx.getBatch().toRequest(), this.config.getGlobal().getAS7Config());
        }
        catch (CliBatchException ex) {
            BatchFailure failure = AS7CliUtils.extractFailedOperationNode(ex.getResponseNode());
            if (null == failure) {
                log.warn("Unable to parse CLI batch operation index: " + ex.getResponseNode());
                throw new MigrationException("Executing a CLI batch failed: " + ex, ex);
            }
            BatchedCommand cmd = this.ctx.getBatch().getCommands().get(failure.getIndex() - 1);
            IMigrationAction causeAction = cmd instanceof BatchedCommandWithAction ? ((BatchedCommandWithAction)cmd).getAction() : (IMigrationAction)cliActions.get(failure.getIndex() - 1);
            throw new ActionException(causeAction, "Executing a CLI batch failed: " + failure.getMessage());
        }
        catch (IOException ex) {
            throw new MigrationException("Executing a CLI batch failed: " + ex, ex);
        }
    }

    private void postValidateActions() throws MigrationException {
        List<IMigrationAction> actions = this.ctx.getActions();
        for (IMigrationAction action : actions) {
            action.postValidate();
        }
    }

    private void cleanBackupsIfAny() throws MigrationException {
        List<IMigrationAction> actions = this.ctx.getActions();
        for (IMigrationAction action : actions) {
            action.cleanBackup();
        }
    }

    private void rollbackActionsWhichWerePerformed() throws MigrationException {
        List<IMigrationAction> actions = this.ctx.getActions();
        for (IMigrationAction action : actions) {
            action.rollback();
        }
    }

    public void loadAS5Data() throws LoadMigrationException {
        log.debug("======== loadAS5Data() ========");
        try {
            for (IMigrator mig : this.migrators) {
                log.debug("    Scanning with " + mig.getClass().getSimpleName());
                mig.loadAS5Data(this.ctx);
            }
        }
        catch (JAXBException e) {
            throw new LoadMigrationException(e);
        }
    }

    private void openManagementClient() throws MigrationException {
        ModelControllerClient as7Client = null;
        AS7Config as7Config = this.config.getGlobal().getAS7Config();
        try {
            as7Client = ModelControllerClient.Factory.create(as7Config.getHost(), as7Config.getManagementPort());
        }
        catch (UnknownHostException ex) {
            throw new MigrationException("Unknown AS 7 host.", ex);
        }
        this.ctx.setAS7ManagementClient(as7Client);
    }

    private void closeManagementClient() {
        AS7CliUtils.safeClose(this.ctx.getAS7Client());
        this.ctx.setAS7ManagementClient(null);
    }
}

