/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.loom.actions;

import java.util.LinkedList;
import java.util.List;
import org.jboss.loom.MigrationContext;
import org.jboss.loom.actions.IMigrationAction;
import org.jboss.loom.ex.MigrationException;
import org.jboss.loom.spi.IMigrator;

public abstract class AbstractStatefulAction
implements IMigrationAction {
    IMigrationAction.State state = IMigrationAction.State.INITIAL;
    private MigrationContext ctx;
    private String originMessage;
    private StackTraceElement originStacktrace;
    private Class<? extends IMigrator> fromMigrator;
    private List<String> warnings = new LinkedList<String>();

    public AbstractStatefulAction() {
    }

    public AbstractStatefulAction(Class<? extends IMigrator> fromMigrator) {
        this.fromMigrator = fromMigrator;
        this.originStacktrace = Thread.currentThread().getStackTrace()[3];
    }

    public void addWarning(String text) {
        this.warnings.add(text);
    }

    public void checkState(IMigrationAction.State state) throws MigrationException {
        if (this.state != state) {
            throw new MigrationException("Action not in expected state '" + (Object)((Object)state) + ": " + this);
        }
    }

    @Override
    public void setMigrationContext(MigrationContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public MigrationContext getMigrationContext() {
        return this.ctx;
    }

    @Override
    public IMigrationAction.State getState() {
        return this.state;
    }

    public void setState(IMigrationAction.State state) {
        this.state = state;
    }

    @Override
    public StackTraceElement getOriginStackTrace() {
        return this.originStacktrace;
    }

    @Override
    public String getOriginMessage() {
        return this.originMessage;
    }

    public AbstractStatefulAction setOriginMessage(String msg) {
        this.originMessage = msg;
        return this;
    }

    @Override
    public Class<? extends IMigrator> getFromMigrator() {
        return this.fromMigrator;
    }

    @Override
    public List<String> getWarnings() {
        return this.warnings;
    }

    protected boolean isAfterBackup() {
        return this.state.ordinal() >= IMigrationAction.State.BACKED_UP.ordinal();
    }

    protected boolean isAfterPerform() {
        return this.state.ordinal() >= IMigrationAction.State.DONE.ordinal();
    }
}

