/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.loom.actions;

import org.jboss.as.cli.batch.BatchedCommand;
import org.jboss.dmr.ModelNode;
import org.jboss.loom.actions.AbstractStatefulAction;
import org.jboss.loom.actions.IMigrationAction;
import org.jboss.loom.conf.Configuration;
import org.jboss.loom.ex.ActionException;
import org.jboss.loom.ex.MigrationException;
import org.jboss.loom.spi.IMigrator;
import org.jboss.loom.utils.AS7CliUtils;
import org.jboss.loom.utils.as7.BatchedCommandWithAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliCommandAction
extends AbstractStatefulAction {
    private static final Logger log = LoggerFactory.getLogger(CliCommandAction.class);
    private BatchedCommandWithAction command;
    private Configuration.IfExists ifExists = Configuration.IfExists.WARN;
    private Configuration.IfExists todo = null;

    public CliCommandAction(Class<? extends IMigrator> fromMigrator, String script, ModelNode cliCommand) {
        super(fromMigrator);
        this.command = new BatchedCommandWithAction(this, script, cliCommand);
    }

    @Override
    public String toDescription() {
        return "Perform CLI command: " + this.command.getCommand();
    }

    @Override
    public void preValidate() throws MigrationException {
        boolean exists;
        if (this.command.getCommand() == null || this.command.getCommand().isEmpty()) {
            throw new ActionException((IMigrationAction)this, "No CLI script set for CliCommandAction");
        }
        if (this.command.getRequest() == null) {
            throw new ActionException((IMigrationAction)this, "ModelNode for CliCommandAction cannot be null");
        }
        try {
            exists = AS7CliUtils.exists(this.command.getRequest(), this.getMigrationContext().getAS7Client());
        }
        catch (Exception ex) {
            throw new ActionException(this, "Failed querying AS 7 for existence of " + this.command.getRequest() + ": " + ex, ex);
        }
        if (!exists) {
            return;
        }
        switch (this.ifExists) {
            case OVERWRITE: {
                this.todo = Configuration.IfExists.OVERWRITE;
                break;
            }
            case FAIL: {
                throw new ActionException((IMigrationAction)this, "ModelNode already exists in AS 7 config: " + this.command.getCommand());
            }
            case MERGE: {
                throw new UnsupportedOperationException("ModelNode merging not supported yet. MIGR-61");
            }
            case WARN: {
                this.todo = Configuration.IfExists.SKIP;
                log.warn("ModelNode already exists in AS 7 config: " + this.command.getCommand());
                return;
            }
            case SKIP: {
                this.todo = Configuration.IfExists.SKIP;
                return;
            }
            case ASK: {
                throw new UnsupportedOperationException("Interactive duplicity handling not supported yet. MIGR-62");
            }
        }
    }

    @Override
    public void perform() throws MigrationException {
        if (this.todo == Configuration.IfExists.SKIP) {
            return;
        }
        if (this.todo == Configuration.IfExists.OVERWRITE) {
            ModelNode remCmd = AS7CliUtils.createRemoveCommandForResource(this.command.getRequest());
            this.getMigrationContext().getBatch().add(new BatchedCommandWithAction(this, remCmd.asString(), remCmd));
        }
        this.getMigrationContext().getBatch().add(this.command);
        this.setState(IMigrationAction.State.DONE);
    }

    @Override
    public void rollback() throws MigrationException {
        this.setState(IMigrationAction.State.ROLLED_BACK);
    }

    @Override
    public void postValidate() throws MigrationException {
    }

    @Override
    public void backup() throws MigrationException {
        this.setState(IMigrationAction.State.BACKED_UP);
    }

    @Override
    public void cleanBackup() {
        this.setState(IMigrationAction.State.FINISHED);
    }

    public BatchedCommand getCommand() {
        return this.command;
    }

    public void setCommand(BatchedCommand command) {
        this.command = new BatchedCommandWithAction(this, command);
    }

    public Configuration.IfExists getIfExists() {
        return this.ifExists;
    }

    public CliCommandAction setIfExists(Configuration.IfExists ifExists) {
        this.ifExists = ifExists;
        return this;
    }

    public String toString() {
        return "CliCommandAction{" + this.command.getCommand() + "; ifExists=" + (Object)((Object)this.ifExists) + ", todo=" + (Object)((Object)this.todo) + '}';
    }
}

