/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.loom.actions;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.jboss.loom.actions.FileAbstractAction;
import org.jboss.loom.actions.IMigrationAction;
import org.jboss.loom.ex.ActionException;
import org.jboss.loom.ex.MigrationException;
import org.jboss.loom.spi.IMigrator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyFileAction
extends FileAbstractAction {
    private static final Logger log = LoggerFactory.getLogger(CopyFileAction.class);
    private boolean overwrite;
    private IfExists ifExists = IfExists.FAIL;

    public CopyFileAction(Class<? extends IMigrator> fromMigrator, File src, File dest, IfExists ifExists) {
        super(fromMigrator, src, dest);
        this.ifExists = ifExists;
    }

    public CopyFileAction(Class<? extends IMigrator> fromMigrator, File src, File dest, IfExists ifExists, boolean failIfNotExist) {
        super(fromMigrator, src, dest, failIfNotExist);
        this.ifExists = ifExists;
    }

    @Override
    protected String verb() {
        return "Copy";
    }

    @Override
    public String addToDescription() {
        return "if exists - " + this.ifExists.name().toLowerCase() + ", ";
    }

    @Override
    public void preValidate() throws MigrationException {
        if (!this.src.exists() && this.failIfNotExist) {
            throw new ActionException((IMigrationAction)this, "File to copy doesn't exist: " + this.src.getPath());
        }
        if (!this.dest.exists()) {
            return;
        }
        switch (this.ifExists) {
            case OVERWRITE: {
                return;
            }
            case FAIL: {
                throw new ActionException((IMigrationAction)this, "Copy destination exists, overwrite not allowed: " + this.dest.getAbsolutePath());
            }
            case WARN: {
                log.warn("Copy destination exists, skipping: " + this.dest.getAbsolutePath());
                return;
            }
            case SKIP: {
                return;
            }
        }
    }

    @Override
    public void perform() throws MigrationException {
        if (this.dest.exists() && this.ifExists == IfExists.SKIP) {
            return;
        }
        try {
            FileUtils.copyFile(this.src, this.dest);
            this.setState(IMigrationAction.State.DONE);
        }
        catch (IOException ex) {
            throw new ActionException(this, "Copying failed: " + ex.getMessage(), ex);
        }
    }

    public static enum IfExists {
        OVERWRITE,
        SKIP,
        WARN,
        FAIL;

    }
}

