/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.loom.actions;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.jboss.loom.actions.AbstractStatefulAction;
import org.jboss.loom.actions.IMigrationAction;
import org.jboss.loom.ex.ActionException;
import org.jboss.loom.ex.MigrationException;
import org.jboss.loom.spi.IMigrator;

public class CreateDirectoryAction
extends AbstractStatefulAction {
    private File dir;
    private boolean existed = false;

    public CreateDirectoryAction(File dir, Class<? extends IMigrator> fromMigrator) {
        super(fromMigrator);
        this.dir = dir;
    }

    @Override
    public String toDescription() {
        return "Create directory " + this.dir.getPath();
    }

    @Override
    public void preValidate() throws MigrationException {
        if (this.dir.exists()) {
            if (!this.dir.isDirectory()) {
                throw new ActionException((IMigrationAction)this, "Already exists, but is not a directory: " + this.dir.getPath());
            }
            this.existed = true;
            return;
        }
        File parentFile = this.dir.getParentFile();
        while (true) {
            if (null == parentFile) {
                return;
            }
            if (parentFile.exists()) break;
            parentFile = parentFile.getParentFile();
        }
        if (!parentFile.canWrite()) {
            throw new ActionException((IMigrationAction)this, "Can't write to the directory: " + parentFile.getPath());
        }
    }

    @Override
    public void backup() throws MigrationException {
    }

    @Override
    public void perform() throws MigrationException {
        if (this.existed) {
            return;
        }
        try {
            FileUtils.forceMkdir(this.dir);
        }
        catch (IOException ex) {
            throw new ActionException(this, "Can't create directory " + this.dir.getPath() + ": " + ex.getMessage(), ex);
        }
    }

    @Override
    public void postValidate() throws MigrationException {
    }

    @Override
    public void cleanBackup() {
    }

    @Override
    public void rollback() throws MigrationException {
        if (this.existed) {
            return;
        }
        try {
            FileUtils.deleteDirectory(this.dir);
        }
        catch (IOException ex) {
            throw new ActionException(this, "Can't rollback dir creation: " + ex.getMessage(), ex);
        }
    }
}

