/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.loom.actions;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.jboss.loom.actions.AbstractStatefulAction;
import org.jboss.loom.actions.IMigrationAction;
import org.jboss.loom.ex.ActionException;
import org.jboss.loom.ex.MigrationException;
import org.jboss.loom.spi.IMigrator;

public abstract class FileAbstractAction
extends AbstractStatefulAction {
    protected File src;
    protected File dest;
    protected boolean failIfNotExist = true;
    private File temp;

    @Override
    public String toDescription() {
        return this.verb() + " file, " + this.addToDescription() + (this.failIfNotExist ? "" : "don't ") + "fail if exists," + "\n    from " + this.src.getPath() + "\n      to " + this.dest.getPath();
    }

    protected abstract String verb();

    protected String addToDescription() {
        return "";
    }

    public FileAbstractAction(Class<? extends IMigrator> fromMigrator, File src, File dest) {
        super(fromMigrator);
        this.src = src;
        this.dest = dest;
    }

    public FileAbstractAction(Class<? extends IMigrator> fromMigrator, File src, File dest, boolean failIfNotExist) {
        super(fromMigrator);
        this.src = src;
        this.dest = dest;
        this.failIfNotExist = failIfNotExist;
    }

    @Override
    public void preValidate() throws MigrationException {
        if (!this.src.exists() && this.failIfNotExist) {
            throw new ActionException((IMigrationAction)this, "File to " + this.verb().toLowerCase() + " doesn't exist: " + this.src.getPath());
        }
    }

    @Override
    public void rollback() throws MigrationException {
        if (!this.isAfterPerform()) {
            return;
        }
        FileUtils.deleteQuietly(this.dest);
        if (this.temp != null) {
            try {
                FileUtils.moveFile(this.temp, this.dest);
            }
            catch (IOException ex) {
                throw new ActionException(this, "Restoring the previous file failed: " + ex.getMessage(), ex);
            }
        }
        this.setState(IMigrationAction.State.ROLLED_BACK);
    }

    @Override
    public void postValidate() throws MigrationException {
    }

    @Override
    public void backup() throws MigrationException {
        if (!this.dest.exists()) {
            return;
        }
        try {
            this.temp = File.createTempFile(this.dest.getName(), null);
            FileUtils.copyFile(this.dest, this.temp);
        }
        catch (IOException ex) {
            throw new ActionException(this, "Creating a backup file failed: " + ex.getMessage(), ex);
        }
        this.setState(IMigrationAction.State.BACKED_UP);
    }

    @Override
    public void cleanBackup() {
        if (this.temp == null) {
            return;
        }
        if (this.temp.exists()) {
            FileUtils.deleteQuietly(this.temp);
        }
        this.setState(IMigrationAction.State.FINISHED);
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.src);
        hash = 67 * hash + Objects.hashCode(this.dest);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileAbstractAction other = (FileAbstractAction)obj;
        if (!Objects.equals(this.src, other.src)) {
            return false;
        }
        return Objects.equals(this.dest, other.dest);
    }

    public File getSrc() {
        return this.src;
    }

    public File getDest() {
        return this.dest;
    }
}

