/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.loom.actions;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.loom.actions.AbstractStatefulAction;
import org.jboss.loom.actions.IMigrationAction;
import org.jboss.loom.conf.Configuration;
import org.jboss.loom.ex.ActionException;
import org.jboss.loom.ex.MigrationException;
import org.jboss.loom.spi.IMigrator;
import org.jboss.loom.utils.AS7ModuleUtils;
import org.jboss.loom.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class ModuleCreationAction
extends AbstractStatefulAction {
    private static final Logger log = LoggerFactory.getLogger(ModuleCreationAction.class);
    private static final String MODULE_XML_FNAME = "module.xml";
    File jarFile;
    String moduleName;
    String[] deps;
    Configuration.IfExists ifExists;
    private File moduleDir;
    private File backupDir;

    public ModuleCreationAction(Class<? extends IMigrator> fromMigrator, String moduleName, String[] deps, File jar, Configuration.IfExists ifExists) {
        super(fromMigrator);
        this.jarFile = jar;
        this.moduleName = moduleName;
        this.deps = deps;
        this.ifExists = ifExists;
    }

    @Override
    public String toDescription() {
        return "Create an AS 7 module '" + this.moduleName + "' from .jar " + this.jarFile.getPath() + ", deps: " + StringUtils.join((Object[])this.deps, " ");
    }

    @Override
    public void preValidate() throws MigrationException {
        if (!this.jarFile.exists()) {
            throw new ActionException((IMigrationAction)this, "Module source jar doesn't exist: " + this.jarFile.getPath());
        }
        File dir = this.getModuleDir();
        if (dir.exists()) {
            switch (this.ifExists) {
                case FAIL: {
                    throw new ActionException((IMigrationAction)this, "Module dir already exists in AS 7, overwrite not allowed: " + dir.getAbsolutePath());
                }
                case ASK: 
                case MERGE: {
                    throw new UnsupportedOperationException("ASK and MERGE are not supported for " + this.getClass().getSimpleName());
                }
                case WARN: {
                    log.warn("Module directory for " + this.moduleName + " already exists: " + this.moduleDir);
                    break;
                }
                case SKIP: {
                    log.debug("Module directory for " + this.moduleName + " already exists, skipping: " + this.moduleDir);
                }
            }
        }
    }

    @Override
    public void perform() throws MigrationException {
        try {
            File dir = this.getModuleDir();
            FileUtils.copyFileToDirectory(this.jarFile, dir);
            File moduleXmlFile = new File(dir, MODULE_XML_FNAME);
            if (moduleXmlFile.exists() && this.ifExists != Configuration.IfExists.OVERWRITE) {
                throw new ActionException((IMigrationAction)this, "module.xml already exists: " + moduleXmlFile.getPath());
            }
            Document doc = AS7ModuleUtils.createModuleXML(this.moduleName, this.jarFile.getName(), this.deps);
            Utils.transformDocToFile(doc, moduleXmlFile);
            this.moduleDir = dir;
        }
        catch (IOException ex) {
            throw new ActionException(this, "Copying failed: " + ex.getMessage(), ex);
        }
        catch (TransformerException ex) {
            throw new ActionException(this, "Creation of module.xml failed: " + ex.getMessage(), ex);
        }
        catch (ParserConfigurationException ex) {
            throw new ActionException(this, "Creation of module.xml failed: " + ex.getMessage(), ex);
        }
        this.setState(IMigrationAction.State.DONE);
    }

    @Override
    public void rollback() throws MigrationException {
        if (this.isAfterPerform()) {
            FileUtils.deleteQuietly(this.moduleDir);
        }
        if (this.backupDir != null) {
            try {
                FileUtils.moveDirectory(this.backupDir, this.moduleDir);
            }
            catch (IOException ex) {
                throw new ActionException((IMigrationAction)this, "Can't move " + this.backupDir + " to " + this.moduleDir);
            }
        }
        this.setState(IMigrationAction.State.ROLLED_BACK);
    }

    @Override
    public void postValidate() throws MigrationException {
    }

    @Override
    public void backup() throws MigrationException {
        Path tmpDir;
        try {
            tmpDir = Files.createTempDirectory("JBossAS-migr-backup-" + this.moduleName, new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new ActionException(this, "Failed creating a backup dir. " + ex.getMessage(), ex);
        }
        if (this.getModuleDir().exists()) {
            try {
                FileUtils.copyDirectory(this.getModuleDir(), tmpDir.toFile());
            }
            catch (IOException ex) {
                throw new ActionException(this, "Failed copying to the backup dir " + tmpDir + " : " + ex.getMessage(), ex);
            }
        }
        this.backupDir = tmpDir.toFile();
        this.setState(IMigrationAction.State.BACKED_UP);
    }

    @Override
    public void cleanBackup() {
        this.setState(IMigrationAction.State.FINISHED);
    }

    private File getModuleDir() {
        return new File(this.getMigrationContext().getAs7Config().getModulesDir(), this.moduleName.replace('.', '/') + "/main");
    }
}

