/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.loom.actions;

import java.io.File;
import java.io.IOException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FileUtils;
import org.jboss.loom.actions.AbstractStatefulAction;
import org.jboss.loom.actions.IMigrationAction;
import org.jboss.loom.ex.ActionException;
import org.jboss.loom.ex.MigrationException;
import org.jboss.loom.spi.IMigrator;
import org.jboss.loom.utils.Utils;
import org.w3c.dom.Document;

public class ModuleCreationOldAction
extends AbstractStatefulAction {
    private static final String MODULE_XML_FNAME = "module.xml";
    File src;
    File dest;
    Document moduleDoc;
    File moduleXml;
    boolean overwrite;

    public ModuleCreationOldAction(Class<? extends IMigrator> fromMigrator, File jar, File dest, Document moduleDoc, boolean overwrite) {
        super(fromMigrator);
        this.src = jar;
        this.dest = dest;
        this.moduleDoc = moduleDoc;
        this.overwrite = overwrite;
    }

    @Override
    public String toDescription() {
        return "Create an AS 7 module from .jar " + this.src.getPath() + " into " + this.dest.getParent();
    }

    @Override
    public void preValidate() throws MigrationException {
        if (!this.src.exists()) {
            throw new ActionException((IMigrationAction)this, "Module source jar doesn't exist: " + this.src.getPath());
        }
        if (this.dest.exists() && !this.overwrite) {
            throw new ActionException((IMigrationAction)this, "Module jar exists in AS 7, overwrite not allowed: " + this.dest.getAbsolutePath());
        }
    }

    @Override
    public void perform() throws MigrationException {
        try {
            FileUtils.copyFile(this.src, this.dest);
            File moduleXml = new File(this.dest.getParentFile(), MODULE_XML_FNAME);
            if (moduleXml.exists() && !this.overwrite) {
                throw new ActionException((IMigrationAction)this, "module.xml already exists: " + moduleXml.getPath());
            }
            Utils.transformDocToFile(this.moduleDoc, moduleXml);
            this.moduleXml = moduleXml;
        }
        catch (IOException ex) {
            throw new ActionException(this, "Copying failed: " + ex.getMessage(), ex);
        }
        catch (TransformerException e) {
            throw new ActionException(this, "Creation of module.xml failed: " + e.getMessage(), e);
        }
        this.setState(IMigrationAction.State.DONE);
    }

    @Override
    public void rollback() throws MigrationException {
        if (this.isAfterPerform()) {
            FileUtils.deleteQuietly(this.dest.getParentFile());
        }
        this.setState(IMigrationAction.State.ROLLED_BACK);
    }

    @Override
    public void postValidate() throws MigrationException {
    }

    @Override
    public void backup() throws MigrationException {
        this.setState(IMigrationAction.State.BACKED_UP);
    }

    @Override
    public void cleanBackup() {
        this.setState(IMigrationAction.State.FINISHED);
    }
}

