/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.loom.migrators.deploymentScanner;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jboss.loom.actions.AbstractStatefulAction;
import org.jboss.loom.actions.IMigrationAction;
import org.jboss.loom.ex.MigrationException;
import org.jboss.loom.migrators.deploymentScanner.jaxb.StandaloneDeploymentScannerType;
import org.jboss.loom.utils.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StandaloneDeploymentScannerAction
extends AbstractStatefulAction {
    List<StandaloneDeploymentScannerType> dList = new ArrayList<StandaloneDeploymentScannerType>();
    File destFile;
    Document destDoc;
    Document rootNodeBackup = null;

    public StandaloneDeploymentScannerAction(File destFile, Document destDoc) {
        this.destFile = destFile;
        this.destDoc = destDoc;
    }

    public void addStandaloneDeploymentScannerType(StandaloneDeploymentScannerType sType) {
        this.dList.add(sType);
    }

    public List<StandaloneDeploymentScannerType> getStandaloneDeploymentScannerTypeList() {
        return this.dList;
    }

    @Override
    public void preValidate() throws MigrationException {
        if (this.destFile == null || !this.destFile.exists()) {
            throw new MigrationException("Destination configuration file " + (this.destFile == null ? "name is NULL." : this.destFile.getAbsolutePath() + " is not found."));
        }
        if (!this.destFile.canWrite()) {
            throw new MigrationException("No write permissions for file " + this.destFile.getAbsolutePath());
        }
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            String exp = "/server/profile/subsystem/deployment-scanner";
            NodeList nList = (NodeList)xpath.evaluate(exp, this.destDoc, XPathConstants.NODESET);
            if (nList.getLength() == 0) {
                throw new MigrationException("deployment-scanner subsystem not found in file: " + this.destDoc.getBaseURI());
            }
        }
        catch (XPathExpressionException e) {
            throw new MigrationException(e);
        }
    }

    @Override
    public void perform() throws MigrationException {
        try {
            DocumentBuilder docBuilder = Utils.createXmlDocumentBuilder();
            XPath xpath = XPathFactory.newInstance().newXPath();
            String exp = "/server/profile/subsystem/deployment-scanner";
            NodeList nList = (NodeList)xpath.evaluate(exp, this.destDoc, XPathConstants.NODESET);
            if (nList.getLength() > 0) {
                JAXBContext jaxbCtx = JAXBContext.newInstance((Class[])new Class[]{StandaloneDeploymentScannerType.class});
                Marshaller marshaller = jaxbCtx.createMarshaller();
                for (StandaloneDeploymentScannerType sType : this.dList) {
                    Document tmpDoc = docBuilder.newDocument();
                    marshaller.marshal((Object)sType, (Node)tmpDoc);
                    Node newChild = this.destDoc.adoptNode(tmpDoc.getDocumentElement().cloneNode(true));
                    nList.item(0).appendChild(newChild);
                }
            } else {
                throw new MigrationException("deployment-scanner subsystem  element not found in file: " + this.destDoc.getBaseURI());
            }
            this.setState(IMigrationAction.State.DONE);
        }
        catch (JAXBException e) {
            throw new MigrationException(e);
        }
        catch (XPathExpressionException xee) {
            throw new MigrationException(xee);
        }
    }

    @Override
    public void rollback() throws MigrationException {
        if (this.rootNodeBackup == null) {
            throw new MigrationException("No backup data to rollback to.");
        }
        this.destDoc = this.rootNodeBackup;
        this.setState(IMigrationAction.State.ROLLED_BACK);
    }

    @Override
    public void postValidate() throws MigrationException {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            String exp = "/server/profile/subsystem/deployment-scanner";
            NodeList nList = (NodeList)xpath.evaluate(exp, this.destDoc, XPathConstants.NODESET);
            if (nList.getLength() < this.dList.size()) {
                throw new MigrationException("new deployment-scanner elements not successfully added to the subsystem.");
            }
        }
        catch (XPathExpressionException xee) {
            throw new MigrationException(xee);
        }
    }

    @Override
    public void backup() throws MigrationException {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource xmlDomSource = new DOMSource(this.destDoc);
            DOMResult domResult = new DOMResult();
            transformer.transform(xmlDomSource, domResult);
            this.rootNodeBackup = (Document)domResult.getNode();
            this.setState(IMigrationAction.State.BACKED_UP);
        }
        catch (TransformerConfigurationException e) {
            System.out.println(e);
        }
        catch (TransformerException te) {
            System.out.println(te);
        }
    }

    @Override
    public void cleanBackup() {
        this.setState(IMigrationAction.State.FINISHED);
    }

    @Override
    public String toDescription() {
        return "";
    }
}

