/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.loom.migrators.deploymentScanner;

import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jboss.loom.actions.AbstractStatefulAction;
import org.jboss.loom.actions.IMigrationAction;
import org.jboss.loom.ex.MigrationException;
import org.jboss.loom.migrators.deploymentScanner.jaxb.Subsystem;
import org.jboss.loom.utils.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SubsystemAction
extends AbstractStatefulAction {
    File destFile;
    Document destDoc;
    Subsystem subsystem;
    Node rootNodeBackup = null;

    public SubsystemAction() {
    }

    public SubsystemAction(Subsystem subsystem, File destFile, Document destDoc) {
        this.subsystem = subsystem;
        this.destFile = destFile;
        this.destDoc = destDoc;
    }

    @Override
    public void preValidate() throws MigrationException {
        if (this.destFile == null || !this.destFile.exists()) {
            throw new MigrationException("Destination configuration file " + (this.destFile == null ? "name is NULL." : this.destFile.getAbsolutePath() + " is not found."));
        }
        if (!this.destFile.canWrite()) {
            throw new MigrationException("No write permissions for file " + this.destFile.getAbsolutePath());
        }
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            String exp = "/server/profile";
            NodeList pList = (NodeList)xpath.evaluate(exp, this.destDoc, XPathConstants.NODESET);
            if (pList.getLength() == 0) {
                throw new MigrationException("profile element not found in file: " + this.destDoc.getBaseURI());
            }
        }
        catch (XPathExpressionException e) {
            throw new MigrationException(e);
        }
    }

    @Override
    public void perform() throws MigrationException {
        try {
            DocumentBuilder docBuilder = Utils.createXmlDocumentBuilder();
            XPath xpath = XPathFactory.newInstance().newXPath();
            String exp = "/server/profile";
            NodeList pList = (NodeList)xpath.evaluate(exp, this.destDoc, XPathConstants.NODESET);
            if (pList.getLength() <= 0) {
                throw new MigrationException("profile element not found in file: " + this.destDoc.getBaseURI());
            }
            JAXBContext jaxbCtx = JAXBContext.newInstance((Class[])new Class[]{Subsystem.class});
            Marshaller marshaller = jaxbCtx.createMarshaller();
            Document tmpDoc = docBuilder.newDocument();
            marshaller.marshal((Object)this.subsystem, (Node)tmpDoc);
            Node newChild = this.destDoc.adoptNode(tmpDoc.getDocumentElement().cloneNode(true));
            pList.item(0).appendChild(newChild);
            this.setState(IMigrationAction.State.DONE);
        }
        catch (JAXBException e) {
            throw new MigrationException(e);
        }
        catch (XPathExpressionException xee) {
            throw new MigrationException(xee);
        }
    }

    @Override
    public void rollback() throws MigrationException {
        if (this.rootNodeBackup == null) {
            throw new MigrationException("No backup data to rollback to.");
        }
        Document rootNode = this.destDoc;
        rootNode.replaceChild(this.rootNodeBackup, rootNode);
        this.setState(IMigrationAction.State.ROLLED_BACK);
    }

    @Override
    public void postValidate() throws MigrationException {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            String exp = "/server/profile/subsystem/deployment-scanner";
            NodeList pList = (NodeList)xpath.evaluate(exp, this.destDoc, XPathConstants.NODESET);
            if (pList.getLength() == 0) {
                throw new MigrationException("new deployment-scanner subsystem not successfully created");
            }
        }
        catch (XPathExpressionException xee) {
            throw new MigrationException(xee);
        }
    }

    @Override
    public void backup() throws MigrationException {
        this.rootNodeBackup = this.destDoc.cloneNode(true);
        this.setState(IMigrationAction.State.BACKED_UP);
    }

    @Override
    public void cleanBackup() {
        this.setState(IMigrationAction.State.FINISHED);
    }

    @Override
    public String toDescription() {
        return "Create a new deployment-scanner subsystem with a reference to the user defined AS5 deployment directory.";
    }
}

