/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.loom.migrators.logging;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.lang.StringUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.loom.CliAddScriptBuilder;
import org.jboss.loom.CliApiCommandBuilder;
import org.jboss.loom.MigrationContext;
import org.jboss.loom.MigrationData;
import org.jboss.loom.actions.CliCommandAction;
import org.jboss.loom.actions.IMigrationAction;
import org.jboss.loom.actions.ModuleCreationOldAction;
import org.jboss.loom.conf.Configuration;
import org.jboss.loom.conf.GlobalConfiguration;
import org.jboss.loom.ex.CliScriptException;
import org.jboss.loom.ex.LoadMigrationException;
import org.jboss.loom.ex.MigrationException;
import org.jboss.loom.migrators.AbstractMigrator;
import org.jboss.loom.migrators.logging.LoggingUtils;
import org.jboss.loom.migrators.logging.jaxb.AppenderBean;
import org.jboss.loom.migrators.logging.jaxb.AsyncHandlerBean;
import org.jboss.loom.migrators.logging.jaxb.CategoryBean;
import org.jboss.loom.migrators.logging.jaxb.ConsoleHandlerBean;
import org.jboss.loom.migrators.logging.jaxb.CustomHandlerBean;
import org.jboss.loom.migrators.logging.jaxb.FileHandlerBean;
import org.jboss.loom.migrators.logging.jaxb.LoggerBean;
import org.jboss.loom.migrators.logging.jaxb.LoggingAS5Bean;
import org.jboss.loom.migrators.logging.jaxb.ParameterBean;
import org.jboss.loom.migrators.logging.jaxb.PerRotFileHandlerBean;
import org.jboss.loom.migrators.logging.jaxb.PropertyBean;
import org.jboss.loom.migrators.logging.jaxb.RootLoggerAS5Bean;
import org.jboss.loom.migrators.logging.jaxb.RootLoggerAS7Bean;
import org.jboss.loom.migrators.logging.jaxb.SizeRotFileHandlerBean;
import org.jboss.loom.spi.IConfigFragment;
import org.jboss.loom.utils.AS7CliUtils;
import org.jboss.loom.utils.Utils;
import org.w3c.dom.Document;

public class LoggingMigrator
extends AbstractMigrator {
    private static final String CLI_PROP__LOG_DIR = "jboss.server.log.dir";
    private static final String AS5_PROP__LOG_TRESHOLD = "jboss.server.log.threshold";
    private String rootLoggerTreshold = "INFO";
    private int number = 1;

    @Override
    protected String getConfigPropertyModuleName() {
        return "logging";
    }

    private String getRootLoggerTreshold() {
        return this.rootLoggerTreshold;
    }

    @Override
    public int examineConfigProperty(Configuration.ModuleSpecificProperty prop) {
        if (!this.getConfigPropertyModuleName().equals(prop.getModuleId())) {
            return 0;
        }
        switch (prop.getPropName()) {
            case "rootLoggerTreshold": 
            case "jboss.server.log.threshold": {
                this.rootLoggerTreshold = prop.getValue();
                return 1;
            }
        }
        return 0;
    }

    public LoggingMigrator(GlobalConfiguration globalConfig, MultiValueMap config) {
        super(globalConfig, config);
    }

    @Override
    public void loadAS5Data(MigrationContext ctx) throws LoadMigrationException {
        try {
            File log4jConfFile = Utils.createPath(super.getGlobalConfig().getAS5Config().getDir(), "server", super.getGlobalConfig().getAS5Config().getProfileName(), "conf", "jboss-log4j.xml");
            XMLInputFactory xif = XMLInputFactory.newFactory();
            xif.setProperty("javax.xml.stream.supportDTD", false);
            XMLStreamReader xsr = xif.createXMLStreamReader(new StreamSource(log4jConfFile));
            Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{LoggingAS5Bean.class}).createUnmarshaller();
            LoggingAS5Bean loggingAS5 = (LoggingAS5Bean)unmarshaller.unmarshal(xsr);
            MigrationData mData = new MigrationData();
            if (loggingAS5.getCategories() != null) {
                mData.getConfigFragments().addAll(loggingAS5.getCategories());
            }
            if (loggingAS5.getLoggers() != null) {
                mData.getConfigFragments().addAll(loggingAS5.getLoggers());
            }
            mData.getConfigFragments().addAll(loggingAS5.getAppenders());
            mData.getConfigFragments().add(loggingAS5.getRootLoggerAS5());
            ctx.getMigrationData().put(LoggingMigrator.class, mData);
        }
        catch (JAXBException | XMLStreamException e) {
            throw new LoadMigrationException(e);
        }
    }

    @Override
    public void createActions(MigrationContext ctx) throws MigrationException {
        LinkedList<CustomHandlerBean> customHandlers = new LinkedList<CustomHandlerBean>();
        for (IConfigFragment fragment : ctx.getMigrationData().get(LoggingMigrator.class).getConfigFragments()) {
            if (fragment instanceof AppenderBean) {
                AppenderBean appender = (AppenderBean)fragment;
                CustomHandlerBean customHandler = this.processAppenderBean(appender, ctx);
                if (null == customHandler) continue;
                customHandlers.add(customHandler);
                continue;
            }
            if (fragment instanceof CategoryBean) {
                try {
                    CliCommandAction action = LoggingMigrator.createLoggerCliAction(ctx, LoggingMigrator.migrateCategory((CategoryBean)fragment), this.getIfExists());
                    ctx.getActions().add(action);
                    continue;
                }
                catch (CliScriptException e) {
                    throw new MigrationException("Migration of the Category failed: " + e.getMessage(), e);
                }
            }
            if (fragment instanceof RootLoggerAS5Bean) {
                RootLoggerAS5Bean root = (RootLoggerAS5Bean)fragment;
                continue;
            }
            throw new MigrationException("Config fragment unrecognized by " + this.getClass().getSimpleName() + ": " + fragment);
        }
        HashMap<File, String> tempModules = new HashMap<File, String>();
        for (CustomHandlerBean handler : customHandlers) {
            ctx.getActions().addAll(this.createCustomHandlerActions(handler, tempModules));
        }
    }

    private List<IMigrationAction> createCustomHandlerActions(CustomHandlerBean handler, HashMap<File, String> tempModules) throws MigrationException {
        File src;
        try {
            src = Utils.findJarFileWithClass(handler.getClassValue(), this.getGlobalConfig().getAS5Config().getDir(), this.getGlobalConfig().getAS5Config().getProfileName());
        }
        catch (IOException ex) {
            throw new MigrationException("Failed finding jar with class " + handler.getClassValue() + ": " + ex.getMessage(), ex);
        }
        LinkedList<IMigrationAction> actions = new LinkedList<IMigrationAction>();
        if (tempModules.containsKey(src)) {
            try {
                handler.setModule(tempModules.get(src));
                actions.add(LoggingMigrator.createCustomHandlerCliAction(handler));
            }
            catch (CliScriptException ex) {
                throw new MigrationException("Failed creating a CLI command for appeneder " + handler.getName() + ": " + ex.getMessage(), ex);
            }
            return actions;
        }
        try {
            handler.setModule("logging.customHandler" + this.number);
            tempModules.put(src, handler.getModule());
            actions.add(LoggingMigrator.createCustomHandlerCliAction(handler));
            File targetDir = Utils.createPath(this.getGlobalConfig().getAS7Config().getModulesDir().getPath(), "logging/customHandler" + this.number, "main", src.getName());
            Document doc = LoggingUtils.createLoggingModuleXML(handler.getModule(), src.getName());
            ModuleCreationOldAction moduleAction = new ModuleCreationOldAction(this.getClass(), src, targetDir, doc, false);
            actions.add(moduleAction);
            ++this.number;
        }
        catch (ParserConfigurationException e) {
            throw new MigrationException("Failed creating Custom-Handler module.xml: " + e.getMessage(), e);
        }
        catch (CliScriptException e) {
            throw new MigrationException("Migration of the appeneder " + handler.getName() + " failed (CLI command): " + e.getMessage(), e);
        }
        return actions;
    }

    private CustomHandlerBean processAppenderBean(AppenderBean appenderBean, MigrationContext ctx) throws MigrationException {
        String cls = appenderBean.getAppenderClass();
        if (!cls.startsWith("org.apache.log4j") && !cls.startsWith("org.jboss.logging.appender")) {
            return LoggingMigrator.createCustomHandler(appenderBean, true);
        }
        try {
            CliCommandAction action;
            String appenderType;
            switch (appenderType = StringUtils.substringAfterLast(cls, ".")) {
                case "DailyRollingFileAppender": {
                    PerRotFileHandlerBean handler = LoggingMigrator.createPerRotFileHandler(appenderBean, ctx);
                    action = LoggingMigrator.createPerRotHandlerCliAction(handler);
                    break;
                }
                case "RollingFileAppender": {
                    SizeRotFileHandlerBean handler = LoggingMigrator.createSizeRotFileHandler(appenderBean, ctx);
                    action = LoggingMigrator.createSizeRotHandlerCliAction(handler);
                    break;
                }
                case "ConsoleAppender": {
                    ConsoleHandlerBean handler = LoggingMigrator.createConsoleHandler(appenderBean);
                    action = LoggingMigrator.createConsoleHandlerCliAction(handler);
                    break;
                }
                case "AsyncAppender": {
                    AsyncHandlerBean handler = LoggingMigrator.createAsyncHandler(appenderBean);
                    action = LoggingMigrator.createAsyncHandleCliAction(handler);
                    break;
                }
                default: {
                    CustomHandlerBean handler = LoggingMigrator.createCustomHandler(appenderBean, false);
                    action = LoggingMigrator.createCustomHandlerCliAction(handler);
                }
            }
            ctx.getActions().add(action);
        }
        catch (CliScriptException e) {
            throw new MigrationException("Migration of the appender " + appenderBean.getAppenderName() + " failed: " + e.getMessage(), e);
        }
        return null;
    }

    private static LoggerBean migrateCategory(CategoryBean category) {
        LoggerBean logger2 = new LoggerBean();
        logger2.setLoggerCategory(category.getCategoryName());
        logger2.setLoggerLevelName(category.getCategoryValue());
        logger2.setHandlers(category.getAppenderRef());
        return logger2;
    }

    private RootLoggerAS7Bean migrateRootLogger(RootLoggerAS5Bean loggerAS5) {
        RootLoggerAS7Bean rootLoggerAS7 = new RootLoggerAS7Bean();
        if (loggerAS5.getRootPriorityValue().equals("${jboss.server.log.threshold}")) {
            rootLoggerAS7.setRootLoggerLevel(this.getRootLoggerTreshold());
        } else {
            rootLoggerAS7.setRootLoggerLevel(loggerAS5.getRootPriorityValue());
        }
        rootLoggerAS7.setRootLoggerHandlers(loggerAS5.getRootAppenderRefs());
        return rootLoggerAS7;
    }

    static PerRotFileHandlerBean createPerRotFileHandler(AppenderBean appender, MigrationContext ctx) {
        PerRotFileHandlerBean handler = new PerRotFileHandlerBean();
        handler.setName(appender.getAppenderName());
        if (appender.getParameters() != null) {
            for (ParameterBean parameter : appender.getParameters()) {
                if (parameter.getParamName().equalsIgnoreCase("Append")) {
                    handler.setAppend(parameter.getParamValue());
                    continue;
                }
                if (parameter.getParamName().equals("File")) {
                    String value = parameter.getParamValue();
                    handler.setRelativeTo(CLI_PROP__LOG_DIR);
                    handler.setPath(StringUtils.substringAfterLast(value, "/"));
                }
                if (parameter.getParamName().equalsIgnoreCase("DatePattern")) {
                    handler.setSuffix(parameter.getParamValue());
                    continue;
                }
                if (!parameter.getParamName().equalsIgnoreCase("Threshold")) continue;
                handler.setLevel(parameter.getParamValue());
            }
        }
        handler.setFormatter(appender.getLayoutParamValue());
        return handler;
    }

    static SizeRotFileHandlerBean createSizeRotFileHandler(AppenderBean appender, MigrationContext ctx) {
        SizeRotFileHandlerBean handler = new SizeRotFileHandlerBean();
        handler.setName(appender.getAppenderName());
        if (appender.getParameters() != null) {
            for (ParameterBean parameter : appender.getParameters()) {
                if (parameter.getParamName().equalsIgnoreCase("Append")) {
                    handler.setAppend(parameter.getParamValue());
                    continue;
                }
                if (parameter.getParamName().equals("File")) {
                    String value = parameter.getParamValue();
                    handler.setRelativeTo(CLI_PROP__LOG_DIR);
                    handler.setPath(StringUtils.substringAfterLast(value, "/"));
                    continue;
                }
                if (parameter.getParamName().equalsIgnoreCase("MaxFileSize")) {
                    handler.setRotateSize(parameter.getParamValue());
                    continue;
                }
                if (parameter.getParamName().equalsIgnoreCase("MaxBackupIndex")) {
                    handler.setMaxBackupIndex(parameter.getParamValue());
                    continue;
                }
                if (!parameter.getParamName().equalsIgnoreCase("Threshold")) continue;
                handler.setLevel(parameter.getParamValue());
            }
        }
        handler.setFormatter(appender.getLayoutParamValue());
        return handler;
    }

    static AsyncHandlerBean createAsyncHandler(AppenderBean appender) {
        AsyncHandlerBean handler = new AsyncHandlerBean();
        handler.setName(appender.getAppenderName());
        if (appender.getParameters() != null) {
            for (ParameterBean parameter : appender.getParameters()) {
                if (parameter.getParamName().equalsIgnoreCase("BufferSize")) {
                    handler.setQueueLength(parameter.getParamValue());
                    continue;
                }
                if (!parameter.getParamName().equalsIgnoreCase("Blocking")) continue;
                handler.setOverflowAction(parameter.getParamValue());
            }
        }
        HashSet<String> appendersRef = new HashSet<String>();
        for (String ref : appender.getAppenderRefs()) {
            appendersRef.add(ref);
        }
        handler.setSubhandlers(appendersRef);
        handler.setFormatter(appender.getLayoutParamValue());
        return handler;
    }

    static ConsoleHandlerBean createConsoleHandler(AppenderBean appender) {
        ConsoleHandlerBean handler = new ConsoleHandlerBean();
        handler.setName(appender.getAppenderName());
        if (appender.getParameters() != null) {
            for (ParameterBean parameter : appender.getParameters()) {
                if (parameter.getParamName().equalsIgnoreCase("Target")) {
                    handler.setTarget(parameter.getParamValue());
                    continue;
                }
                if (!parameter.getParamName().equalsIgnoreCase("Threshold")) continue;
                handler.setLevel(parameter.getParamValue());
            }
        }
        handler.setFormatter(appender.getLayoutParamValue());
        return handler;
    }

    static CustomHandlerBean createCustomHandler(AppenderBean appender, Boolean custom) {
        CustomHandlerBean handler = new CustomHandlerBean();
        handler.setName(appender.getAppenderName());
        handler.setClassValue(appender.getAppenderClass());
        if (!custom.booleanValue()) {
            handler.setModule("org.apache.log4j");
        }
        HashSet<PropertyBean> properties = new HashSet<PropertyBean>();
        if (appender.getParameters() != null) {
            for (ParameterBean parameter : appender.getParameters()) {
                if (parameter.getParamName().equalsIgnoreCase("Threshold")) {
                    handler.setLevel(parameter.getParamValue());
                    continue;
                }
                PropertyBean property = new PropertyBean();
                property.setName(parameter.getParamName());
                property.setValue(parameter.getParamValue());
                properties.add(property);
            }
        }
        handler.setProperties(properties);
        handler.setFormatter(appender.getLayoutParamValue());
        return handler;
    }

    static FileHandlerBean createFileHandler(AppenderBean appender) throws CliScriptException {
        return null;
    }

    static CliCommandAction createLoggerCliAction(MigrationContext ctx, LoggerBean logger2, Configuration.IfExists ifExists) throws CliScriptException {
        String errMsg = " in logger(Category in AS5) must be set.";
        Utils.throwIfBlank(logger2.getLoggerCategory(), errMsg, "Logger name");
        ModelNode loggerCmd = new ModelNode();
        loggerCmd.get("address").add("subsystem", "logging");
        loggerCmd.get("address").add("logger", logger2.getLoggerCategory());
        loggerCmd.get("operation").set("add");
        if (logger2.getHandlers() != null) {
            ModelNode handlersNode = new ModelNode();
            for (String handler : logger2.getHandlers()) {
                ModelNode handlerNode = new ModelNode();
                handlerNode.set(handler);
                handlersNode.add(handlerNode);
            }
            loggerCmd.get("handlers").set(handlersNode);
        }
        CliApiCommandBuilder builder = new CliApiCommandBuilder(loggerCmd);
        builder.addProperty("level", logger2.getLoggerLevelName());
        builder.addProperty("use-parent-handlers", logger2.getUseParentHandlers());
        return new CliCommandAction(LoggingMigrator.class, LoggingMigrator.createLoggerScript(logger2), builder.getCommand()).setIfExists(ifExists);
    }

    static CliCommandAction createPerRotHandlerCliAction(PerRotFileHandlerBean handler) throws CliScriptException {
        String errMsg = " in periodic-rotating-file-handler(Appender in AS5) must be set.";
        Utils.throwIfBlank(handler.getName(), errMsg, "Name");
        Utils.throwIfBlank(handler.getRelativeTo(), errMsg, "Relative-to");
        Utils.throwIfBlank(handler.getPath(), errMsg, "Path");
        Utils.throwIfBlank(handler.getSuffix(), errMsg, "Suffix");
        ModelNode handlerCmd = new ModelNode();
        handlerCmd.get("operation").set("add");
        handlerCmd.get("address").add("subsystem", "logging");
        handlerCmd.get("address").add("periodic-rotating-file-handler", handler.getName());
        ModelNode temp = new ModelNode();
        temp.get("relative-to").set(handler.getRelativeTo());
        temp.get("path").set(handler.getPath());
        handlerCmd.get("file").set(temp);
        CliApiCommandBuilder builder = new CliApiCommandBuilder(handlerCmd);
        builder.addProperty("suffix", handler.getSuffix());
        builder.addProperty("level", handler.getLevel());
        builder.addProperty("formatter", handler.getFormatter());
        builder.addProperty("autoflush", handler.getAutoflush());
        builder.addProperty("append", handler.getAppend());
        return new CliCommandAction(LoggingMigrator.class, LoggingMigrator.createPerHandlerScript(handler), builder.getCommand());
    }

    static CliCommandAction createSizeRotHandlerCliAction(SizeRotFileHandlerBean handler) throws CliScriptException {
        String errMsg = " in size-rotating-file-handler(Appender in AS5) must be set.";
        Utils.throwIfBlank(handler.getName(), errMsg, "Name");
        Utils.throwIfBlank(handler.getRelativeTo(), errMsg, "Relative-to");
        Utils.throwIfBlank(handler.getPath(), errMsg, "Path");
        ModelNode handlerCmd = new ModelNode();
        handlerCmd.get("operation").set("add");
        handlerCmd.get("address").add("subsystem", "logging");
        handlerCmd.get("address").add("size-rotating-file-handler", handler.getName());
        ModelNode temp = new ModelNode();
        temp.get("relative-to").set(handler.getRelativeTo());
        temp.get("path").set(handler.getPath());
        handlerCmd.get("file").set(temp);
        CliApiCommandBuilder builder = new CliApiCommandBuilder(handlerCmd);
        builder.addProperty("level", handler.getLevel());
        builder.addProperty("filter", handler.getFilter());
        builder.addProperty("formatter", handler.getFormatter());
        builder.addProperty("autoflush", handler.getAutoflush());
        builder.addProperty("append", handler.getAppend());
        builder.addProperty("rotate-size", handler.getRotateSize());
        builder.addProperty("max-backup-index", handler.getMaxBackupIndex());
        return new CliCommandAction(LoggingMigrator.class, LoggingMigrator.createSizeHandlerScript(handler), builder.getCommand());
    }

    static CliCommandAction createAsyncHandleCliAction(AsyncHandlerBean handler) throws CliScriptException {
        String errMsg = " in async-handler(Appender in AS5) must be set.";
        Utils.throwIfBlank(handler.getName(), errMsg, "Name");
        Utils.throwIfBlank(handler.getQueueLength(), errMsg, "Queue length");
        ModelNode handlerCmd = new ModelNode();
        handlerCmd.get("operation").set("add");
        handlerCmd.get("address").add("subsystem", "logging");
        handlerCmd.get("address").add("async-handler", handler.getName());
        if (handler.getSubhandlers() != null) {
            ModelNode handlersNode = new ModelNode();
            for (String subHandler : handler.getSubhandlers()) {
                ModelNode handlerNode = new ModelNode();
                handlerNode.set(subHandler);
                handlersNode.add(handlerNode);
            }
            handlerCmd.get("handlers").set(handlersNode);
        }
        CliApiCommandBuilder builder = new CliApiCommandBuilder(handlerCmd);
        builder.addProperty("queue-length", handler.getQueueLength());
        builder.addProperty("level", handler.getLevel());
        builder.addProperty("filter", handler.getFilter());
        builder.addProperty("formatter", handler.getFormatter());
        builder.addProperty("overflow-action", handler.getOverflowAction());
        return new CliCommandAction(LoggingMigrator.class, LoggingMigrator.createAsyncHandlerScript(handler), builder.getCommand());
    }

    static CliCommandAction createConsoleHandlerCliAction(ConsoleHandlerBean handler) throws CliScriptException {
        String errMsg = " in console-handler(Appender in AS5) must be set.";
        Utils.throwIfBlank(handler.getName(), errMsg, "Name");
        ModelNode handlerCmd = new ModelNode();
        handlerCmd.get("operation").set("add");
        handlerCmd.get("address").add("subsystem", "logging");
        handlerCmd.get("address").add("console-handler", handler.getName());
        CliApiCommandBuilder builder = new CliApiCommandBuilder(handlerCmd);
        builder.addProperty("level", handler.getLevel());
        builder.addProperty("filter", handler.getFilter());
        builder.addProperty("formatter", handler.getFormatter());
        builder.addProperty("autoflush", handler.getAutoflush());
        builder.addProperty("target", handler.getTarget());
        return new CliCommandAction(LoggingMigrator.class, LoggingMigrator.createConsoleHandlerScript(handler), builder.getCommand());
    }

    static CliCommandAction createCustomHandlerCliAction(CustomHandlerBean handler) throws CliScriptException {
        String errMsg = " in custom-handler must be set.";
        Utils.throwIfBlank(handler.getName(), errMsg, "Name");
        Utils.throwIfBlank(handler.getModule(), errMsg, "Module");
        Utils.throwIfBlank(handler.getClassValue(), errMsg, "Class-value");
        ModelNode handlerCmd = new ModelNode();
        handlerCmd.get("operation").set("add");
        handlerCmd.get("address").add("subsystem", "logging");
        handlerCmd.get("address").add("custom-handler", handler.getName());
        if (handler.getProperties() != null) {
            ModelNode propertyNode = new ModelNode();
            for (PropertyBean property : handler.getProperties()) {
                propertyNode.get(property.getName()).set(property.getValue());
            }
            handlerCmd.get("properties").set(propertyNode);
        }
        CliApiCommandBuilder builder = new CliApiCommandBuilder(handlerCmd);
        builder.addProperty("level", handler.getLevel());
        builder.addProperty("filter", handler.getFilter());
        builder.addProperty("formatter", handler.getFormatter());
        builder.addProperty("class", handler.getClassValue());
        builder.addProperty("module", handler.getModule());
        return new CliCommandAction(LoggingMigrator.class, LoggingMigrator.createCustomHandlerScript(handler), builder.getCommand());
    }

    static List<CliCommandAction> createRootLoggerCliAction(RootLoggerAS7Bean root) throws CliScriptException {
        return null;
    }

    static String createLoggerScript(LoggerBean logger2) throws CliScriptException {
        String handlersStr;
        String errMsg = " in logger(Category in AS5) must be set.";
        Utils.throwIfBlank(logger2.getLoggerCategory(), errMsg, "Logger name");
        StringBuilder resultScript = new StringBuilder("/subsystem=logging/logger=" + logger2.getLoggerCategory() + ":add(");
        CliAddScriptBuilder builder = new CliAddScriptBuilder();
        builder.addProperty("level", logger2.getLoggerLevelName());
        builder.addProperty("use-parent-handlers", logger2.getUseParentHandlers());
        resultScript.append(builder.asString());
        if (logger2.getHandlers() != null && !(handlersStr = AS7CliUtils.joinQuoted(logger2.getHandlers())).isEmpty()) {
            resultScript.append(", handlers=[").append(handlersStr).append("]");
        }
        resultScript.append(")");
        return resultScript.toString();
    }

    static String createPerHandlerScript(PerRotFileHandlerBean periodic) throws CliScriptException {
        String errMsg = " in periodic-rotating-file-handler(Appender in AS5) must be set.";
        Utils.throwIfBlank(periodic.getName(), errMsg, "Name");
        Utils.throwIfBlank(periodic.getRelativeTo(), errMsg, "Relative-to");
        Utils.throwIfBlank(periodic.getPath(), errMsg, "Path");
        Utils.throwIfBlank(periodic.getSuffix(), errMsg, "Suffix");
        StringBuilder resultScript = new StringBuilder("/subsystem=logging/periodic-rotating-file-handler=");
        resultScript.append(periodic.getName()).append(":add(");
        resultScript.append("file={\"relative-to\"=>\"").append(periodic.getRelativeTo()).append("\"");
        resultScript.append(", \"path\"=>\"").append(periodic.getPath()).append("\"}");
        resultScript.append(", suffix=").append(periodic.getSuffix()).append(", ");
        CliAddScriptBuilder builder = new CliAddScriptBuilder();
        builder.addProperty("level", periodic.getLevel());
        builder.addProperty("formatter", periodic.getFormatter());
        builder.addProperty("autoflush", periodic.getAutoflush());
        builder.addProperty("append", periodic.getAppend());
        resultScript.append(builder.asString()).append(")");
        return resultScript.toString();
    }

    static String createSizeHandlerScript(SizeRotFileHandlerBean sizeHandler) throws CliScriptException {
        String errMsg = " in size-rotating-file-handler(Appender in AS5) must be set.";
        Utils.throwIfBlank(sizeHandler.getName(), errMsg, "Name");
        Utils.throwIfBlank(sizeHandler.getRelativeTo(), errMsg, "Relative-to");
        Utils.throwIfBlank(sizeHandler.getPath(), errMsg, "Path");
        CliAddScriptBuilder builder = new CliAddScriptBuilder();
        StringBuilder resultScript = new StringBuilder("/subsystem=logging/size-rotating-file-handler=");
        resultScript.append(sizeHandler.getName()).append(":add(");
        resultScript.append("file={\"relative-to\"=>\"").append(sizeHandler.getRelativeTo()).append("\"");
        resultScript.append(", \"path\"=>\"").append(sizeHandler.getPath()).append("\"},");
        builder.addProperty("level", sizeHandler.getLevel());
        builder.addProperty("filter", sizeHandler.getFilter());
        builder.addProperty("formatter", sizeHandler.getFormatter());
        builder.addProperty("autoflush", sizeHandler.getAutoflush());
        builder.addProperty("append", sizeHandler.getAppend());
        builder.addProperty("rotate-size", sizeHandler.getRotateSize());
        builder.addProperty("max-backup-index", sizeHandler.getMaxBackupIndex());
        resultScript.append(builder.asString()).append(")");
        return resultScript.toString();
    }

    static String createAsyncHandlerScript(AsyncHandlerBean asyncHandler) throws CliScriptException {
        String errMsg = " in async-handler(Appender in AS5) must be set.";
        Utils.throwIfBlank(asyncHandler.getName(), errMsg, "Name");
        Utils.throwIfBlank(asyncHandler.getQueueLength(), errMsg, "Queue length");
        StringBuilder resultScript = new StringBuilder("/subsystem=logging/async-handler=");
        resultScript.append(asyncHandler.getName()).append(":add(");
        resultScript.append("queue-length=").append(asyncHandler.getQueueLength());
        CliAddScriptBuilder builder = new CliAddScriptBuilder();
        builder.addProperty("level", asyncHandler.getLevel());
        builder.addProperty("filter", asyncHandler.getFilter());
        builder.addProperty("formatter", asyncHandler.getFormatter());
        builder.addProperty("overflow-action", asyncHandler.getOverflowAction());
        resultScript.append(builder.asString());
        if (asyncHandler.getSubhandlers() != null) {
            StringBuilder handlersBuilder = new StringBuilder();
            for (String subHandler : asyncHandler.getSubhandlers()) {
                handlersBuilder.append(", \"").append(subHandler).append("\"");
            }
            String handlers = handlersBuilder.toString().replaceFirst(", ", "");
            if (!handlers.isEmpty()) {
                resultScript.append(", subhandlers=[").append(handlers).append("]");
            }
        }
        resultScript.append(")");
        return resultScript.toString();
    }

    static String createConsoleHandlerScript(ConsoleHandlerBean consoleHandler) throws CliScriptException {
        String errMsg = " in console-handler(Appender in AS5) must be set.";
        Utils.throwIfBlank(consoleHandler.getName(), errMsg, "Name");
        StringBuilder resultScript = new StringBuilder("/subsystem=logging/console-handler=");
        resultScript.append(consoleHandler.getName()).append(":add(");
        CliAddScriptBuilder builder = new CliAddScriptBuilder();
        builder.addProperty("level", consoleHandler.getLevel());
        builder.addProperty("filter", consoleHandler.getFilter());
        builder.addProperty("formatter", consoleHandler.getFormatter());
        builder.addProperty("autoflush", consoleHandler.getAutoflush());
        builder.addProperty("target", consoleHandler.getTarget());
        resultScript.append(builder.asString()).append(")");
        return resultScript.toString();
    }

    static String createCustomHandlerScript(CustomHandlerBean customHandler) throws CliScriptException {
        String errMsg = " in custom-handler must be set.";
        Utils.throwIfBlank(customHandler.getName(), errMsg, "Name");
        Utils.throwIfBlank(customHandler.getModule(), errMsg, "Module");
        Utils.throwIfBlank(customHandler.getClassValue(), errMsg, "Class-value");
        StringBuilder resultScript = new StringBuilder("/subsystem=logging/custom-handler=");
        resultScript.append(customHandler.getName()).append(":add(");
        CliAddScriptBuilder builder = new CliAddScriptBuilder();
        builder.addProperty("level", customHandler.getLevel());
        builder.addProperty("filter", customHandler.getFilter());
        builder.addProperty("formatter", customHandler.getFormatter());
        builder.addProperty("class", customHandler.getClassValue());
        builder.addProperty("module", customHandler.getModule());
        resultScript.append(builder.asString());
        if (customHandler.getProperties() != null && !customHandler.getProperties().isEmpty()) {
            StringBuilder propertiesBuilder = new StringBuilder();
            for (PropertyBean property : customHandler.getProperties()) {
                propertiesBuilder.append(", \"").append(property.getName()).append("\"=>");
                propertiesBuilder.append('\"').append(property.getValue()).append('\"');
            }
            String properties = propertiesBuilder.toString();
            properties = properties.replaceFirst(", ", "");
            resultScript.append(", properties={").append(properties).append('}');
        }
        resultScript.append(")");
        return resultScript.toString();
    }

    static String createRootLoggerScript(RootLoggerAS7Bean rootLogger) throws CliScriptException {
        String errMsg = " in root-logger must be set.";
        Utils.throwIfBlank(rootLogger.getRootLoggerLevel(), errMsg, "Level");
        CliAddScriptBuilder builder = new CliAddScriptBuilder();
        StringBuilder resultScript = new StringBuilder();
        if (rootLogger.getRootLogFilValue() != null) {
            resultScript.append("/subsystem=logging/root-logger=ROOT:write-attribute(");
            resultScript.append("name=filter, value=").append(rootLogger.getRootLogFilValue());
            resultScript.append(")\n");
        }
        resultScript.append("/subsystem=logging/root-logger=ROOT:write-attribute(");
        resultScript.append("name=level, value=").append(rootLogger.getRootLoggerLevel());
        resultScript.append(")\n");
        for (String handler : rootLogger.getRootLoggerHandlers()) {
            resultScript.append("/subsystem=logging/root-logger=ROOT:root-logger-assign-handler(name=");
            resultScript.append(handler).append(")\n");
        }
        return resultScript.toString();
    }
}

