/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.loom.migrators.security;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.lang.StringUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.loom.CliAddScriptBuilder;
import org.jboss.loom.CliApiCommandBuilder;
import org.jboss.loom.MigrationContext;
import org.jboss.loom.MigrationData;
import org.jboss.loom.actions.CliCommandAction;
import org.jboss.loom.actions.CopyFileAction;
import org.jboss.loom.conf.GlobalConfiguration;
import org.jboss.loom.ex.CliScriptException;
import org.jboss.loom.ex.CopyException;
import org.jboss.loom.ex.LoadMigrationException;
import org.jboss.loom.ex.MigrationException;
import org.jboss.loom.migrators.AbstractMigrator;
import org.jboss.loom.migrators.security.jaxb.ApplicationPolicyBean;
import org.jboss.loom.migrators.security.jaxb.LoginModuleAS5Bean;
import org.jboss.loom.migrators.security.jaxb.LoginModuleAS7Bean;
import org.jboss.loom.migrators.security.jaxb.ModuleOptionAS5Bean;
import org.jboss.loom.migrators.security.jaxb.ModuleOptionAS7Bean;
import org.jboss.loom.migrators.security.jaxb.SecurityAS5Bean;
import org.jboss.loom.migrators.security.jaxb.SecurityDomainBean;
import org.jboss.loom.spi.IConfigFragment;
import org.jboss.loom.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityMigrator
extends AbstractMigrator {
    private static final Logger log = LoggerFactory.getLogger(SecurityMigrator.class);
    private static final String AS7_CONFIG_DIR_PLACEHOLDER = "${jboss.server.config.dir}";
    private Set<String> fileNames = new HashSet<String>();
    private Set<CopyFileAction> copyActions;

    @Override
    protected String getConfigPropertyModuleName() {
        return "security";
    }

    public SecurityMigrator(GlobalConfiguration globalConfig, MultiValueMap config) {
        super(globalConfig, config);
    }

    @Override
    public void loadAS5Data(MigrationContext ctx) throws LoadMigrationException {
        try {
            File file = new File(this.getGlobalConfig().getAS5Config().getConfDir(), "login-config.xml");
            if (!file.canRead()) {
                throw new LoadMigrationException("Can't read: " + file.getAbsolutePath());
            }
            Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{SecurityAS5Bean.class}).createUnmarshaller();
            SecurityAS5Bean securityAS5 = (SecurityAS5Bean)unmarshaller.unmarshal(file);
            MigrationData mData = new MigrationData();
            mData.getConfigFragments().addAll(securityAS5.getApplicationPolicies());
            ctx.getMigrationData().put(SecurityMigrator.class, mData);
        }
        catch (JAXBException e) {
            throw new LoadMigrationException(e);
        }
    }

    @Override
    public void createActions(MigrationContext ctx) throws MigrationException {
        for (IConfigFragment fragment : ctx.getMigrationData().get(SecurityMigrator.class).getConfigFragments()) {
            if (fragment instanceof ApplicationPolicyBean) {
                try {
                    SecurityDomainBean appPolicy = this.migrateAppPolicy((ApplicationPolicyBean)fragment, ctx);
                    ctx.getActions().addAll(this.createSecurityDomainCliAction(appPolicy));
                    continue;
                }
                catch (CliScriptException e) {
                    throw new MigrationException("Migration of application-policy failed: " + e.getMessage(), e);
                }
            }
            throw new MigrationException("Config fragment unrecognized by " + this.getClass().getSimpleName() + ": " + fragment);
        }
        File as5profileDir = this.getGlobalConfig().getAS5Config().getProfileDir();
        String as7Dir = this.getGlobalConfig().getAS7Config().getDir();
        for (String fileName : this.fileNames) {
            File src;
            try {
                src = Utils.searchForFile(fileName, as5profileDir).iterator().next();
            }
            catch (CopyException ex) {
                log.warn("Couldn't find file referenced in AS 5 security config: " + fileName);
                continue;
            }
            File target = Utils.createPath(as7Dir, "standalone", "configuration", src.getName());
            CopyFileAction act = new CopyFileAction(this.getClass(), src, target, CopyFileAction.IfExists.WARN);
            ctx.getActions().add(act);
        }
    }

    public SecurityDomainBean migrateAppPolicy(ApplicationPolicyBean appPolicy, MigrationContext ctx) {
        HashSet<LoginModuleAS7Bean> loginModules = new HashSet<LoginModuleAS7Bean>();
        SecurityDomainBean securityDomain = new SecurityDomainBean();
        securityDomain.setSecurityDomainName(appPolicy.getApplicationPolicyName());
        securityDomain.setCacheType("default");
        if (appPolicy.getLoginModules() != null) {
            for (LoginModuleAS5Bean lmAS5 : appPolicy.getLoginModules()) {
                loginModules.add(this.createLoginModule(lmAS5, this.copyActions));
            }
        }
        securityDomain.setLoginModules(loginModules);
        return securityDomain;
    }

    private LoginModuleAS7Bean createLoginModule(LoginModuleAS5Bean lmAS5, Collection<CopyFileAction> filesToCopy) {
        LoginModuleAS7Bean lmAS7 = new LoginModuleAS7Bean();
        lmAS7.setLoginModuleFlag(lmAS5.getLoginModuleFlag());
        lmAS7.setLoginModuleCode(SecurityMigrator.deriveLoginModuleName(lmAS5.getLoginModule()));
        HashSet<ModuleOptionAS7Bean> moduleOptions = new HashSet<ModuleOptionAS7Bean>();
        lmAS7.setModuleOptions(moduleOptions);
        if (lmAS5.getModuleOptions() == null) {
            return lmAS7;
        }
        for (ModuleOptionAS5Bean moAS5 : lmAS5.getModuleOptions()) {
            String value;
            switch (moAS5.getModuleName()) {
                case "rolesProperties": 
                case "usersProperties": {
                    String fName = new File(moAS5.getModuleValue()).getName();
                    value = "${jboss.server.config.dir}/" + fName;
                    this.fileNames.add(fName);
                    break;
                }
                default: {
                    value = moAS5.getModuleValue();
                }
            }
            ModuleOptionAS7Bean moAS7 = new ModuleOptionAS7Bean(moAS5.getModuleName(), value);
            moduleOptions.add(moAS7);
        }
        return lmAS7;
    }

    private static String deriveLoginModuleName(String as5moduleName) {
        String type;
        switch (type = StringUtils.substringAfterLast(as5moduleName, ".")) {
            case "ClientLoginModule": {
                return "Client";
            }
            case "BaseCertLoginModule": {
                return "Certificate";
            }
            case "CertRolesLoginModule": {
                return "CertificateRoles";
            }
            case "DatabaseServerLoginModule": {
                return "Database";
            }
            case "DatabaseCertLoginModule": {
                return "DatabaseCertificate";
            }
            case "IdentityLoginModule": {
                return "Identity";
            }
            case "LdapLoginModule": {
                return "Ldap";
            }
            case "LdapExtLoginModule": {
                return "LdapExtended";
            }
            case "RoleMappingLoginModule": {
                return "RoleMapping";
            }
            case "RunAsLoginModule": {
                return "RunAs";
            }
            case "SimpleServerLoginModule": {
                return "Simple";
            }
            case "ConfiguredIdentityLoginModule": {
                return "ConfiguredIdentity";
            }
            case "SecureIdentityLoginModule": {
                return "SecureIdentity";
            }
            case "PropertiesUsersLoginModule": {
                return "PropertiesUsers";
            }
            case "SimpleUsersLoginModule": {
                return "SimpleUsers";
            }
            case "LdapUsersLoginModule": {
                return "LdapUsers";
            }
            case "Krb5loginModule": {
                return "Kerberos";
            }
            case "SPNEGOLoginModule": {
                return "SPNEGOUsers";
            }
            case "AdvancedLdapLoginModule": {
                return "AdvancedLdap";
            }
            case "AdvancedADLoginModule": {
                return "AdvancedADldap";
            }
            case "UsersRolesLoginModule": {
                return "UsersRoles";
            }
        }
        return as5moduleName;
    }

    public List<CliCommandAction> createSecurityDomainCliAction(SecurityDomainBean domain) throws CliScriptException {
        String errMsg = " in security-domain must be set.";
        Utils.throwIfBlank(domain.getSecurityDomainName(), errMsg, "Security name");
        LinkedList<CliCommandAction> actions = new LinkedList<CliCommandAction>();
        ModelNode domainCmd = new ModelNode();
        domainCmd.get("operation").set("add");
        domainCmd.get("address").add("subsystem", "security");
        domainCmd.get("address").add("security-domain", domain.getSecurityDomainName());
        CliCommandAction action = new CliCommandAction(SecurityMigrator.class, SecurityMigrator.createSecurityDomainScript(domain), domainCmd);
        action.setIfExists(this.getIfExists());
        actions.add(action);
        if (domain.getLoginModules() != null) {
            for (LoginModuleAS7Bean module : domain.getLoginModules()) {
                actions.add(SecurityMigrator.createLoginModuleCliAction(domain, module));
            }
        }
        return actions;
    }

    public static CliCommandAction createLoginModuleCliAction(SecurityDomainBean domain, LoginModuleAS7Bean module) {
        ModelNode request = new ModelNode();
        request.get("operation").set("add");
        request.get("address").add("subsystem", "security");
        request.get("address").add("security-domain", domain.getSecurityDomainName());
        request.get("address").add("authentication", "classic");
        ModelNode moduleNode = new ModelNode();
        ModelNode list = new ModelNode();
        if (module.getModuleOptions() != null) {
            ModelNode optionNode = new ModelNode();
            for (ModuleOptionAS7Bean option : module.getModuleOptions()) {
                optionNode.get(option.getModuleOptionName()).set(option.getModuleOptionValue());
            }
            moduleNode.get("module-options").set(optionNode);
        }
        CliApiCommandBuilder builder = new CliApiCommandBuilder(moduleNode);
        builder.addProperty("flag", module.getLoginModuleFlag());
        builder.addProperty("code", module.getLoginModuleCode());
        list.add(builder.getCommand());
        request.get("login-modules").set(list);
        return new CliCommandAction(SecurityMigrator.class, SecurityMigrator.createLoginModuleScript(domain, module), request);
    }

    private static String createSecurityDomainScript(SecurityDomainBean securityDomain) throws CliScriptException {
        String errMsg = " in security-domain must be set.";
        Utils.throwIfBlank(securityDomain.getSecurityDomainName(), errMsg, "Security name");
        CliAddScriptBuilder builder = new CliAddScriptBuilder();
        StringBuilder resultScript = new StringBuilder("/subsystem=security/security-domain=");
        resultScript.append(securityDomain.getSecurityDomainName()).append(":add(");
        builder.addProperty("cache-type", securityDomain.getCacheType());
        resultScript.append(builder.asString()).append(")");
        return resultScript.toString();
    }

    private static String createLoginModuleScript(SecurityDomainBean domain, LoginModuleAS7Bean module) {
        StringBuilder resultScript = new StringBuilder("/subsystem=security/security-domain=" + domain.getSecurityDomainName());
        resultScript.append("/authentication=classic:add(login-modules=[{");
        if (module.getLoginModuleCode() != null || !module.getLoginModuleCode().isEmpty()) {
            resultScript.append("\"code\"=>\"").append(module.getLoginModuleCode()).append("\"");
        }
        if (module.getLoginModuleFlag() != null || !module.getLoginModuleFlag().isEmpty()) {
            resultScript.append(", \"flag\"=>\"").append(module.getLoginModuleFlag()).append("\"");
        }
        if (module.getModuleOptions() != null || !module.getModuleOptions().isEmpty()) {
            StringBuilder modulesBuilder = new StringBuilder();
            for (ModuleOptionAS7Bean moduleOptionAS7 : module.getModuleOptions()) {
                modulesBuilder.append(", (\"").append(moduleOptionAS7.getModuleOptionName()).append("\"=>");
                modulesBuilder.append("\"").append(moduleOptionAS7.getModuleOptionValue()).append("\")");
            }
            String modules = modulesBuilder.toString().replaceFirst(",", "");
            if (!(modules = modules.replaceFirst(" ", "")).isEmpty()) {
                resultScript.append(", \"module-option\"=>[").append(modules).append("]");
            }
        }
        return resultScript.toString();
    }
}

