/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.loom.migrators.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.collections.map.MultiValueMap;
import org.jboss.dmr.ModelNode;
import org.jboss.loom.CliAddScriptBuilder;
import org.jboss.loom.CliApiCommandBuilder;
import org.jboss.loom.MigrationContext;
import org.jboss.loom.MigrationData;
import org.jboss.loom.actions.CliCommandAction;
import org.jboss.loom.conf.GlobalConfiguration;
import org.jboss.loom.ex.CliScriptException;
import org.jboss.loom.ex.LoadMigrationException;
import org.jboss.loom.ex.MigrationException;
import org.jboss.loom.ex.NodeGenerationException;
import org.jboss.loom.migrators.AbstractMigrator;
import org.jboss.loom.migrators.server.jaxb.ConnectorAS5Bean;
import org.jboss.loom.migrators.server.jaxb.ConnectorAS7Bean;
import org.jboss.loom.migrators.server.jaxb.EngineBean;
import org.jboss.loom.migrators.server.jaxb.ServerAS5Bean;
import org.jboss.loom.migrators.server.jaxb.ServiceBean;
import org.jboss.loom.migrators.server.jaxb.SocketBindingBean;
import org.jboss.loom.migrators.server.jaxb.VirtualServerBean;
import org.jboss.loom.spi.IConfigFragment;
import org.jboss.loom.utils.Utils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServerMigrator
extends AbstractMigrator {
    private Set<SocketBindingBean> socketTemp = new HashSet<SocketBindingBean>();
    private Set<SocketBindingBean> socketBindings = new HashSet<SocketBindingBean>();
    private Integer randomSocket = 1;
    private Integer randomConnector = 1;

    @Override
    protected String getConfigPropertyModuleName() {
        return "server";
    }

    public ServerMigrator(GlobalConfiguration globalConfig, MultiValueMap config) {
        super(globalConfig, config);
    }

    @Override
    public void loadAS5Data(MigrationContext ctx) throws LoadMigrationException {
        File file = Utils.createPath(super.getGlobalConfig().getAS5Config().getDir(), "server", super.getGlobalConfig().getAS5Config().getProfileName(), "deploy", "jbossweb.sar", "server.xml");
        if (!file.canRead()) {
            throw new LoadMigrationException("Cannot find/open file: " + file.getAbsolutePath(), new FileNotFoundException());
        }
        try {
            Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{ServerAS5Bean.class}).createUnmarshaller();
            ServerAS5Bean serverAS5 = (ServerAS5Bean)unmarshaller.unmarshal(file);
            MigrationData mData = new MigrationData();
            for (ServiceBean s : serverAS5.getServices()) {
                mData.getConfigFragments().add(s.getEngine());
                mData.getConfigFragments().addAll(s.getConnectorAS5s());
            }
            ctx.getMigrationData().put(ServerMigrator.class, mData);
        }
        catch (JAXBException e) {
            throw new LoadMigrationException("Failed parsing logging config file: " + file.getPath(), e);
        }
    }

    @Override
    public void createActions(MigrationContext ctx) throws MigrationException {
        try {
            this.createDefaultSockets(ctx);
        }
        catch (LoadMigrationException e) {
            throw new MigrationException("Migration of web server failed: " + e.getMessage(), e);
        }
        for (IConfigFragment fragment : ctx.getMigrationData().get(ServerMigrator.class).getConfigFragments()) {
            String what = null;
            try {
                if (fragment instanceof ConnectorAS5Bean) {
                    what = "connector";
                    ctx.getActions().addAll(ServerMigrator.createConnectorCliAction(this.migrateConnector((ConnectorAS5Bean)fragment, ctx)));
                    continue;
                }
                if (fragment instanceof EngineBean) {
                    what = "Engine (virtual-server)";
                    ctx.getActions().add(ServerMigrator.createVirtualServerCliAction(ServerMigrator.migrateEngine((EngineBean)fragment)));
                    continue;
                }
                throw new MigrationException("Config fragment unrecognized by " + this.getClass().getSimpleName() + ": " + fragment);
            }
            catch (CliScriptException | NodeGenerationException e) {
                throw new MigrationException("Migration of the " + what + " failed: " + e.getMessage(), e);
            }
        }
        for (SocketBindingBean sb : this.socketBindings) {
            try {
                ctx.getActions().add(ServerMigrator.createSocketBindingCliAction(sb));
            }
            catch (CliScriptException e) {
                throw new MigrationException("Creation of the new socket-binding failed: " + e.getMessage(), e);
            }
        }
    }

    public ConnectorAS7Bean migrateConnector(ConnectorAS5Bean connector, MigrationContext ctx) throws NodeGenerationException {
        ConnectorAS7Bean connAS7 = new ConnectorAS7Bean();
        connAS7.setEnabled("true");
        connAS7.setEnableLookups(connector.getEnableLookups());
        connAS7.setMaxPostSize(connector.getMaxPostSize());
        connAS7.setMaxSavePostSize(connector.getMaxSavePostSize());
        connAS7.setProtocol(connector.getProtocol());
        connAS7.setProxyName(connector.getProxyName());
        connAS7.setProxyPort(connector.getProxyPort());
        connAS7.setRedirectPort(connector.getRedirectPort());
        connAS7.setScheme("http");
        String protocol = null;
        protocol = connector.getProtocol().equals("HTTP/1.1") ? ("true".equalsIgnoreCase(connector.getSslEnabled()) ? "https" : "http") : "ajp";
        connAS7.setSocketBinding(this.createSocketBinding(connector.getPort(), protocol));
        connAS7.setConnectorName(protocol);
        if ("true".equalsIgnoreCase(connector.getSslEnabled())) {
            connAS7.setScheme("https");
            connAS7.setSecure(connector.getSecure());
            connAS7.setSslName("ssl");
            connAS7.setVerifyClient(connector.getClientAuth());
            connAS7.setCertifKeyFile(connector.getKeystoreFile());
            if (connector.getSslProtocol().equals("TLS") || connector.getSslProtocol() == null) {
                connAS7.setSslProtocol("TLSv1");
            }
            connAS7.setSslProtocol(connector.getSslProtocol());
            connAS7.setCiphers(connector.getCiphers());
            connAS7.setKeyAlias(connAS7.getKeyAlias());
            connAS7.setPassword(connector.getKeystorePass());
        }
        return connAS7;
    }

    public static VirtualServerBean migrateEngine(EngineBean engine) {
        VirtualServerBean virtualServer = new VirtualServerBean();
        virtualServer.setVirtualServerName(engine.getEngineName());
        virtualServer.setEnableWelcomeRoot("true");
        virtualServer.setAliasName(engine.getHostNames());
        if (engine.getAliases() != null) {
            virtualServer.getAliasName().addAll(engine.getAliases());
        }
        return virtualServer;
    }

    private void createDefaultSockets(MigrationContext ctx) throws LoadMigrationException {
        try {
            Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{SocketBindingBean.class}).createUnmarshaller();
            NodeList bindings = ctx.getAS7ConfigXmlDoc().getElementsByTagName("socket-binding");
            for (int i = 0; i < bindings.getLength(); ++i) {
                SocketBindingBean socketBinding;
                if (!(bindings.item(i) instanceof Element) || (socketBinding = (SocketBindingBean)unmarshaller.unmarshal(bindings.item(i))).getSocketName() == null && socketBinding.getSocketPort() == null) continue;
                this.socketTemp.add(socketBinding);
            }
        }
        catch (JAXBException e) {
            throw new LoadMigrationException("Parsing of socket-bindings in standalone file failed: " + e.getMessage(), e);
        }
    }

    private String createSocketBinding(String port, String name) throws NodeGenerationException {
        for (SocketBindingBean sb : this.socketTemp) {
            if (sb.getSocketPort().equals(port)) {
                return sb.getSocketName();
            }
            if (!sb.getSocketName().equals(name)) continue;
            name = "createdSocket";
        }
        SocketBindingBean socketBinding = new SocketBindingBean();
        for (SocketBindingBean sb : this.socketBindings) {
            if (!sb.getSocketPort().equals(port)) continue;
            return sb.getSocketName();
        }
        for (SocketBindingBean sb : this.socketBindings) {
            if (!sb.getSocketName().equals(name)) continue;
            name = name.concat(this.randomSocket.toString());
            ServerMigrator serverMigrator = this;
            Integer n = serverMigrator.randomSocket;
            Integer n2 = serverMigrator.randomSocket = Integer.valueOf(serverMigrator.randomSocket + 1);
        }
        socketBinding.setSocketName(name);
        socketBinding.setSocketPort(port);
        this.socketBindings.add(socketBinding);
        return name;
    }

    public static List<CliCommandAction> createConnectorCliAction(ConnectorAS7Bean connAS7) throws CliScriptException {
        String errMsg = " in connector must be set.";
        Utils.throwIfBlank(connAS7.getScheme(), errMsg, "Scheme");
        Utils.throwIfBlank(connAS7.getSocketBinding(), errMsg, "Socket-binding");
        Utils.throwIfBlank(connAS7.getConnectorName(), errMsg, "Connector name");
        Utils.throwIfBlank(connAS7.getProtocol(), errMsg, "Protocol");
        LinkedList<CliCommandAction> actions = new LinkedList<CliCommandAction>();
        actions.add(new CliCommandAction(ServerMigrator.class, ServerMigrator.createConnectorScript(connAS7), ServerMigrator.createConnectorModelNode(connAS7)));
        if (connAS7.getScheme().equals("https")) {
            actions.add(new CliCommandAction(ServerMigrator.class, ServerMigrator.createSSLConfScript(connAS7), ServerMigrator.createSSLConfModelNode(connAS7)));
        }
        return actions;
    }

    private static ModelNode createConnectorModelNode(ConnectorAS7Bean connAS7) {
        ModelNode connCmd = new ModelNode();
        connCmd.get("operation").set("add");
        connCmd.get("address").add("subsystem", "web");
        connCmd.get("address").add("connector", connAS7.getConnectorName());
        CliApiCommandBuilder builder = new CliApiCommandBuilder(connCmd);
        builder.addProperty("socket-binding", connAS7.getSocketBinding());
        builder.addProperty("enable-lookups", connAS7.getEnableLookups());
        builder.addProperty("max-post-size", connAS7.getMaxPostSize());
        builder.addProperty("max-save-post-size", connAS7.getMaxSavePostSize());
        builder.addProperty("max-connections", connAS7.getMaxConnections());
        builder.addProperty("protocol", connAS7.getProtocol());
        builder.addProperty("proxy-name", connAS7.getProxyName());
        builder.addProperty("proxy-port", connAS7.getProxyPort());
        builder.addProperty("redirect-port", connAS7.getRedirectPort());
        builder.addProperty("scheme", connAS7.getScheme());
        builder.addProperty("secure", connAS7.getSecure());
        builder.addProperty("enabled", connAS7.getEnabled());
        return builder.getCommand();
    }

    private static ModelNode createSSLConfModelNode(ConnectorAS7Bean connAS7) {
        ModelNode sslConf = new ModelNode();
        sslConf.get("operation").set("add");
        sslConf.get("address").add("subsystem", "web");
        sslConf.get("address").add("connector", connAS7.getConnectorName());
        sslConf.get("address").add("ssl", "configuration");
        CliApiCommandBuilder sslBuilder = new CliApiCommandBuilder(sslConf);
        sslBuilder.addProperty("name", connAS7.getSslName());
        sslBuilder.addProperty("verify-client", connAS7.getVerifyClient());
        sslBuilder.addProperty("verify-depth", connAS7.getVerifyDepth());
        sslBuilder.addProperty("certificate-key-file", connAS7.getCertifKeyFile());
        sslBuilder.addProperty("password", connAS7.getPassword());
        sslBuilder.addProperty("protocol", connAS7.getProtocol());
        sslBuilder.addProperty("ciphers", connAS7.getCiphers());
        sslBuilder.addProperty("key-alias", connAS7.getKeyAlias());
        sslBuilder.addProperty("ca-certificate-file", connAS7.getCaCertifFile());
        sslBuilder.addProperty("session-cache-size", connAS7.getSessionCacheSize());
        sslBuilder.addProperty("session-timeout", connAS7.getSessionTimeout());
        return sslBuilder.getCommand();
    }

    public static CliCommandAction createVirtualServerCliAction(VirtualServerBean server) throws CliScriptException {
        String errMsg = "in virtual-server (engine in AS5) must be set";
        Utils.throwIfBlank(server.getVirtualServerName(), errMsg, "Server name");
        ModelNode serverCmd = new ModelNode();
        serverCmd.get("operation").set("add");
        serverCmd.get("address").add("subsystem", "web");
        serverCmd.get("address").add("virtual-server", server.getVirtualServerName());
        if (server.getAliasName() != null) {
            ModelNode aliasesNode = new ModelNode();
            for (String alias : server.getAliasName()) {
                ModelNode aliasNode = new ModelNode();
                aliasNode.set(alias);
                aliasesNode.add(aliasNode);
            }
            serverCmd.get("alias").set(aliasesNode);
        }
        CliApiCommandBuilder builder = new CliApiCommandBuilder(serverCmd);
        builder.addProperty("enable-welcome-root", server.getEnableWelcomeRoot());
        builder.addProperty("default-web-module", server.getDefaultWebModule());
        return new CliCommandAction(ServerMigrator.class, ServerMigrator.createVirtualServerScript(server), builder.getCommand());
    }

    public static CliCommandAction createSocketBindingCliAction(SocketBindingBean socket) throws CliScriptException {
        String errMsg = " in socket-binding must be set.";
        Utils.throwIfBlank(socket.getSocketPort(), errMsg, "Port");
        Utils.throwIfBlank(socket.getSocketName(), errMsg, "Name");
        ModelNode serverCmd = new ModelNode();
        serverCmd.get("operation").set("add");
        serverCmd.get("address").add("socket-binding-group", "standard-sockets");
        serverCmd.get("address").add("socket-binding", socket.getSocketName());
        serverCmd.get("port").set(socket.getSocketPort());
        CliApiCommandBuilder builder = new CliApiCommandBuilder(serverCmd);
        builder.addProperty("interface", socket.getSocketInterface());
        return new CliCommandAction(ServerMigrator.class, ServerMigrator.createSocketBindingScript(socket), builder.getCommand());
    }

    private static String createConnectorScript(ConnectorAS7Bean connAS7) throws CliScriptException {
        String errMsg = " in connector must be set.";
        Utils.throwIfBlank(connAS7.getScheme(), errMsg, "Scheme");
        Utils.throwIfBlank(connAS7.getSocketBinding(), errMsg, "Socket-binding");
        Utils.throwIfBlank(connAS7.getConnectorName(), errMsg, "Connector name");
        Utils.throwIfBlank(connAS7.getProtocol(), errMsg, "Protocol");
        CliAddScriptBuilder builder = new CliAddScriptBuilder();
        StringBuilder resultScript = new StringBuilder("/subsystem=web/connector=");
        resultScript.append(connAS7.getConnectorName()).append(":add(");
        builder.addProperty("socket-binding", connAS7.getSocketBinding());
        builder.addProperty("enable-lookups", connAS7.getEnableLookups());
        builder.addProperty("max-post-size", connAS7.getMaxPostSize());
        builder.addProperty("max-save-post-size", connAS7.getMaxSavePostSize());
        builder.addProperty("max-connections", connAS7.getMaxConnections());
        builder.addProperty("protocol", connAS7.getProtocol());
        builder.addProperty("proxy-name", connAS7.getProxyName());
        builder.addProperty("proxy-port", connAS7.getProxyPort());
        builder.addProperty("redirect-port", connAS7.getRedirectPort());
        builder.addProperty("scheme", connAS7.getScheme());
        builder.addProperty("secure", connAS7.getSecure());
        builder.addProperty("enabled", connAS7.getEnabled());
        resultScript.append(builder.asString()).append(")");
        return resultScript.toString();
    }

    private static String createSSLConfScript(ConnectorAS7Bean connAS7) {
        CliAddScriptBuilder builder = new CliAddScriptBuilder();
        StringBuilder resultScript = new StringBuilder("/subsystem=web/connector=" + connAS7.getConnectorName());
        resultScript.append("/ssl=configuration:add(");
        builder.addProperty("name", connAS7.getSslName());
        builder.addProperty("verify-client", connAS7.getVerifyClient());
        builder.addProperty("verify-depth", connAS7.getVerifyDepth());
        builder.addProperty("certificate-key-file", connAS7.getCertifKeyFile());
        builder.addProperty("password", connAS7.getPassword());
        builder.addProperty("protocol", connAS7.getProtocol());
        builder.addProperty("ciphers", connAS7.getCiphers());
        builder.addProperty("key-alias", connAS7.getKeyAlias());
        builder.addProperty("ca-certificate-file", connAS7.getCaCertifFile());
        builder.addProperty("session-cache-size", connAS7.getSessionCacheSize());
        builder.addProperty("session-timeout", connAS7.getSessionTimeout());
        resultScript.append(builder.asString()).append(")");
        return resultScript.toString();
    }

    private static String createVirtualServerScript(VirtualServerBean virtualServer) throws CliScriptException {
        String errMsg = "in virtual-server (engine in AS5) must be set";
        Utils.throwIfBlank(virtualServer.getVirtualServerName(), errMsg, "Server name");
        CliAddScriptBuilder builder = new CliAddScriptBuilder();
        StringBuilder resultScript = new StringBuilder("/subsystem=web/virtual-server=");
        resultScript.append(virtualServer.getVirtualServerName()).append(":add(");
        builder.addProperty("enable-welcome-root", virtualServer.getEnableWelcomeRoot());
        builder.addProperty("default-web-module", virtualServer.getDefaultWebModule());
        String aliases = "";
        if (virtualServer.getAliasName() != null) {
            StringBuilder aliasBuilder = new StringBuilder();
            for (String alias : virtualServer.getAliasName()) {
                aliasBuilder.append(", \"").append(alias).append("\"");
            }
            aliases = aliasBuilder.toString();
            if (!(aliases = aliases.replaceFirst(", ", "")).isEmpty()) {
                aliases = ", alias=[" + aliases + "]";
            }
        }
        resultScript.append(builder.asString()).append(aliases).append(")");
        return resultScript.toString();
    }

    private static String createSocketBindingScript(SocketBindingBean socketBinding) throws CliScriptException {
        String errMsg = " in socket-binding must be set.";
        Utils.throwIfBlank(socketBinding.getSocketPort(), errMsg, "Port");
        Utils.throwIfBlank(socketBinding.getSocketName(), errMsg, "Name");
        CliAddScriptBuilder builder = new CliAddScriptBuilder();
        StringBuilder resultScript = new StringBuilder("/socket-binding-group=standard-sockets/socket-binding=");
        resultScript.append(socketBinding.getSocketName()).append(":add(");
        resultScript.append("port=").append(socketBinding.getSocketPort());
        builder.addProperty("interface", socketBinding.getSocketInterface());
        resultScript.append(builder.asString()).append(")");
        return resultScript.toString();
    }
}

