/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.loom.utils;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.loom.CliApiCommandBuilder;
import org.jboss.loom.conf.AS7Config;
import org.jboss.loom.ex.CliBatchException;
import org.jboss.loom.ex.MigrationException;
import org.jboss.loom.utils.as7.BatchFailure;

public class AS7CliUtils {
    private static final String OP_KEY_PREFIX = "Operation step-";

    public static void removeResourceIfExists(ModelNode loggerCmd, ModelControllerClient aS7Client) throws IOException, CliBatchException {
        if (!AS7CliUtils.exists(loggerCmd, aS7Client)) {
            return;
        }
        ModelNode res = aS7Client.execute(AS7CliUtils.createRemoveCommandForResource(loggerCmd));
        AS7CliUtils.throwIfFailure(res);
    }

    public static boolean exists(ModelNode resource, ModelControllerClient client) throws IOException {
        ModelNode query = new ModelNode();
        query.get("operation").set("read-resource");
        query.get("address").set(resource.get("address"));
        ModelNode res = client.execute(query);
        return AS7CliUtils.wasSuccess(res);
    }

    public static ModelNode createRemoveCommandForResource(ModelNode resource) {
        ModelNode query = new ModelNode();
        query.get("address").set(resource.get("address"));
        query.get("operation").set("remove");
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeRequest(ModelNode request, AS7Config as7config) throws IOException, CliBatchException {
        ModelControllerClient client = null;
        try {
            client = ModelControllerClient.Factory.create(as7config.getHost(), as7config.getManagementPort());
            ModelNode response = client.execute(new OperationBuilder(request).build());
            AS7CliUtils.throwIfFailure(response);
        }
        catch (IOException ex) {
            try {
                ModelNode response = client.execute(new OperationBuilder(request).build());
                AS7CliUtils.throwIfFailure(response);
            }
            catch (Throwable throwable) {
                AS7CliUtils.safeClose(client);
                throw throwable;
            }
            AS7CliUtils.safeClose(client);
        }
        AS7CliUtils.safeClose(client);
    }

    public static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void throwIfFailure(ModelNode node) throws CliBatchException {
        if (AS7CliUtils.wasSuccess(node)) {
            return;
        }
        String msg = node.hasDefined("failure-description") ? (node.hasDefined("operation") ? String.format("Operation '%s' at address '%s' failed: %s", node.get("operation"), node.get("address"), node.get("failure-description")) : String.format("Operation failed: %s", node.get("failure-description"))) : String.format("Operation failed: %s", node);
        throw new CliBatchException(msg, node);
    }

    private static boolean wasSuccess(ModelNode node) {
        return "success".equals(node.get("outcome").asString());
    }

    public static Integer parseFailedOperationIndex(ModelNode node) throws MigrationException {
        String key;
        if ("success".equals(node.get("outcome").asString())) {
            return 0;
        }
        if (!node.hasDefined("failure-description")) {
            return null;
        }
        ModelNode failDesc = node.get("failure-description");
        ModelNode compositeFailDesc = failDesc.get(key = failDesc.keys().iterator().next());
        Set<String> keys = compositeFailDesc.keys();
        String opKey = keys.iterator().next();
        if (!opKey.startsWith(OP_KEY_PREFIX)) {
            return null;
        }
        String opIndex = StringUtils.substring(opKey, OP_KEY_PREFIX.length());
        return Integer.parseInt(opIndex);
    }

    public static BatchFailure extractFailedOperationNode(ModelNode node) throws MigrationException {
        if ("success".equals(node.get("outcome").asString())) {
            return null;
        }
        if (!node.hasDefined("failure-description")) {
            return null;
        }
        ModelNode failDesc = node.get("failure-description");
        if (failDesc.getType() != ModelType.OBJECT) {
            return null;
        }
        String key = failDesc.keys().iterator().next();
        ModelNode compositeFailDesc = failDesc.get(key);
        Set<String> keys = compositeFailDesc.keys();
        String opKey = keys.iterator().next();
        if (!opKey.startsWith(OP_KEY_PREFIX)) {
            return null;
        }
        String opIndex = StringUtils.substring(opKey, OP_KEY_PREFIX.length());
        return new BatchFailure(Integer.parseInt(opIndex), compositeFailDesc.get(opKey).toString());
    }

    public static void copyProperties(Object source, CliApiCommandBuilder builder, String props) {
        String[] parts;
        for (String prop : parts = StringUtils.split(props)) {
            try {
                Method method = source.getClass().getMethod(AS7CliUtils.convertPropToMethodName(prop), new Class[0]);
                if (String.class != method.getReturnType()) continue;
                String val = (String)method.invoke(source, new Object[0]);
                builder.addProperty(prop, val);
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalArgumentException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static String convertPropToMethodName(String propName) {
        String[] parts;
        StringBuilder sb = new StringBuilder("get");
        for (String part : parts = StringUtils.split(propName, "-")) {
            sb.append(StringUtils.capitalize(part));
        }
        return sb.toString();
    }

    public static String joinQuoted(Collection<String> col) {
        if (col.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String item : col) {
            sb.append(",\"").append(item).append('\"');
        }
        String str = sb.toString();
        str = str.replaceFirst(",", "");
        return str;
    }

    public static String formatCommand(ModelNode command) {
        if (!command.has("operation")) {
            throw new IllegalArgumentException("'operation' not defined.");
        }
        if (command.get("operation").getType() != ModelType.STRING) {
            throw new IllegalArgumentException("'operation' must be a string.");
        }
        if (!command.has("address")) {
            throw new IllegalArgumentException("'address' not defined.");
        }
        if (command.get("address").getType() != ModelType.LIST) {
            throw new IllegalArgumentException("'address' must be a list.");
        }
        String op = command.get("operation").asString();
        ModelNode addr = command.get("address");
        StringBuilder sb = new StringBuilder("/");
        int i = 0;
        while (addr.has(i)) {
            ModelNode segment = addr.get(i);
            String key = segment.keys().iterator().next();
            sb.append(key).append('=').append(segment.get(key).asString()).append('/');
            ++i;
        }
        sb.append(':').append(op);
        boolean hasParams = false;
        Set<String> keys = command.keys();
        Iterator<String> i$ = keys.iterator();
        block8: while (i$.hasNext()) {
            String key;
            switch (key = i$.next()) {
                case "operation": 
                case "address": {
                    continue block8;
                }
            }
            sb.append(hasParams ? (char)',' : '(');
            hasParams = true;
            sb.append(key).append('=').append(command.get(key));
        }
        if (hasParams) {
            sb.append(')');
        }
        return sb.toString();
    }

    public static String queryServerPath(String path, ModelControllerClient client) throws MigrationException {
        ModelNode response;
        ModelNode query = new ModelNode();
        query.get("operation").set("read-attribute");
        query.get("address").add("path", path);
        query.get("name").set("path");
        try {
            response = client.execute(query);
            AS7CliUtils.throwIfFailure(response);
        }
        catch (IOException | CliBatchException ex) {
            throw new MigrationException("Failed querying for AS 7 directory.", ex);
        }
        ModelNode result = response.get("result");
        if (result.getType() == ModelType.UNDEFINED) {
            return null;
        }
        return result.asString();
    }

    public static String queryServerHomeDir(ModelControllerClient client) throws MigrationException {
        return AS7CliUtils.queryServerPath("jboss.home.dir", client);
    }

    public static String queryServerBaseDir(ModelControllerClient client) throws MigrationException {
        return AS7CliUtils.queryServerPath("jboss.server.base.dir", client);
    }

    public static String queryServerConfigDir(ModelControllerClient client) throws MigrationException {
        return AS7CliUtils.queryServerPath("jboss.server.config.dir", client);
    }

    public static String escapeAddressElement(String element) {
        element = element.replace(":", "\\:");
        element = element.replace("/", "\\/");
        element = element.replace("=", "\\=");
        element = element.replace(" ", "\\ ");
        return element;
    }
}

