/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.loom.utils;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AS7ModuleUtils {
    public static Document createModuleXML(String moduleName, String fileName, String[] deps) throws ParserConfigurationException {
        Document doc = AS7ModuleUtils.createDoc();
        Element root = doc.createElement("module");
        doc.appendChild(root);
        root.setAttribute("xmlns", "urn:jboss:module:1.1");
        root.setAttribute("name", moduleName);
        Element resources = doc.createElement("resources");
        root.appendChild(resources);
        Element resource = doc.createElement("resource-root");
        resource.setAttribute("path", fileName);
        resources.appendChild(resource);
        Element dependencies = doc.createElement("dependencies");
        boolean optional = false;
        for (String modName : deps) {
            if (modName == null) {
                optional = true;
                continue;
            }
            Element module = doc.createElement("module");
            module.setAttribute("name", modName);
            if (optional) {
                module.setAttribute("optional", "true");
            }
            dependencies.appendChild(module);
            optional = false;
        }
        root.appendChild(dependencies);
        return doc;
    }

    public static File transformDocToFile(Document doc, File file) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(new DOMSource(doc), new StreamResult(file));
        return file;
    }

    private static Document createDoc() throws ParserConfigurationException {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setIgnoringComments(true);
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        Document doc = builder.getDOMImplementation().createDocument(null, null, null);
        return doc;
    }
}

