/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.loom.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.jboss.loom.ex.CliScriptException;
import org.jboss.loom.ex.CopyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    public static void throwIfBlank(String string, String errMsg, String name) throws CliScriptException {
        if (string == null || string.isEmpty()) {
            throw new CliScriptException(name + errMsg);
        }
    }

    public static void writeHelp() {
        System.out.println();
        System.out.println(" Usage:");
        System.out.println();
        System.out.println("    java -jar AsMigrator.jar [<option>, ...] [as5.dir=]<as5.dir> [as7.dir=]<as7.dir>");
        System.out.println();
        System.out.println(" Options:");
        System.out.println();
        System.out.println("    as5.profile=<name>");
        System.out.println("        Path to AS 5 profile.");
        System.out.println("        Default: \"default\"");
        System.out.println();
        System.out.println("    as7.confPath=<path> ");
        System.out.println("        Path to AS 7 config file.");
        System.out.println("        Default: \"standalone/configuration/standalone.xml\"");
        System.out.println();
        System.out.println("    conf.<module>.<property>=<value> := Module-specific options.");
        System.out.println("        <module> := Name of one of modules. E.g. datasource, jaas, security, ...");
        System.out.println("        <property> := Name of the property to set. Specific per module. May occur multiple times.");
        System.out.println();
    }

    public static File findJarFileWithClass(String className, String dirAS5, String profileAS5) throws FileNotFoundException, IOException {
        String classFilePath = className.replace(".", "/");
        File dir = Utils.createPath(dirAS5, "server", profileAS5, "lib");
        File jar = Utils.lookForJarWithAClass(dir, classFilePath);
        if (jar != null) {
            return jar;
        }
        dir = Utils.createPath(dirAS5, "common", "lib");
        jar = Utils.lookForJarWithAClass(dir, classFilePath);
        if (jar != null) {
            return jar;
        }
        throw new FileNotFoundException("Cannot find jar file which contains class: " + className);
    }

    private static File lookForJarWithAClass(File dir, String classFilePath) throws IOException {
        log.debug("    Looking in " + dir.getPath() + " for a .jar with: " + classFilePath);
        if (!dir.isDirectory()) {
            log.trace("    Not a directory: " + dir.getPath());
            return null;
        }
        Collection<File> jarFiles = FileUtils.listFiles(dir, new String[]{"jar"}, true);
        log.trace("    Found .jar files: " + jarFiles.size());
        for (File file : jarFiles) {
            JarFile jarFile = new JarFile(file);
            Throwable throwable = null;
            try {
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (entry.isDirectory() || !entry.getName().contains(classFilePath)) continue;
                    File file2 = file;
                    return file2;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (jarFile == null) continue;
                if (throwable != null) {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                jarFile.close();
            }
        }
        return null;
    }

    public static Collection<File> searchForFile(String fileName, File dir) throws CopyException {
        NameFileFilter nff = new NameFileFilter(fileName);
        Collection<File> list = FileUtils.listFiles(dir, nff, FileFilterUtils.trueFileFilter());
        if (list.isEmpty()) {
            throw new CopyException("File '" + fileName + "' was not found in " + dir.getAbsolutePath());
        }
        return list;
    }

    public static File createPath(String parent, String child, String ... more) {
        File file = new File(parent, child);
        for (String component : more) {
            file = new File(file, component);
        }
        return file;
    }

    public static DocumentBuilder createXmlDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(false);
        try {
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Document parseFileToXmlDoc(File file) throws SAXException, IOException {
        DocumentBuilder db = Utils.createXmlDocumentBuilder();
        Document doc = db.parse(file);
        return doc;
    }

    public static Document createDoc() throws ParserConfigurationException {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setIgnoringComments(true);
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        Document doc = builder.getDOMImplementation().createDocument(null, null, null);
        return doc;
    }

    public static File transformDocToFile(Document doc, File file) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
        transformer.transform(new DOMSource(doc), new StreamResult(file));
        return file;
    }
}

