/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.fileio;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class DataOutputStream
extends java.io.DataOutputStream {
    private byte[] bytearr = null;

    public DataOutputStream(OutputStream out) {
        super(out);
    }

    public static int writeUTF(String str, DataOutput out) throws IOException {
        byte[] bytearr;
        char c;
        int strlen = str.length();
        int utflen = 0;
        int count = 0;
        int i = 0;
        while (i < strlen) {
            c = str.charAt(i);
            utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException("encoded string too long: " + utflen + " bytes");
        }
        if (out instanceof DataOutputStream) {
            DataOutputStream dos = (DataOutputStream)out;
            if (dos.bytearr == null || dos.bytearr.length < utflen + 2) {
                dos.bytearr = new byte[utflen * 2 + 2];
            }
            bytearr = dos.bytearr;
        } else {
            bytearr = new byte[utflen + 2];
        }
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen & 0xFF);
        int i2 = 0;
        while (i2 < strlen) {
            c = str.charAt(i2);
            if (c < '\u0001' || c > '\u007f') break;
            bytearr[count++] = (byte)c;
            ++i2;
        }
        while (i2 < strlen) {
            c = str.charAt(i2);
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c & 0x3F);
            }
            ++i2;
        }
        out.write(bytearr, 0, utflen + 2);
        return utflen + 2;
    }
}

