/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.fileio.xalib.txdirs.dir;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.LinkedList;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.commons.transaction.file.FileResourceManager;
import org.apache.commons.transaction.file.ResourceManagerException;
import org.apache.commons.transaction.util.LoggerFacade;
import org.apache.commons.transaction.util.PrintWriterLogger;
import org.jboss.jbossts.fileio.xalib.txdirs.dir.XADirFile;
import org.jboss.jbossts.fileio.xalib.txdirs.dir.XAFileResourceManager;
import org.jboss.jbossts.fileio.xalib.txdirs.exceptions.IncompleteTransactionsException;
import org.jboss.jbossts.fileio.xalib.txdirs.exceptions.NotDirectoryException;

public class XADir
implements Serializable,
Closeable {
    private String curTxId;
    private transient FileResourceManager freMngr;
    private long length;

    public XADir(File storeDir) throws IOException, ResourceManagerException {
        if (!storeDir.exists()) {
            storeDir.mkdir();
        } else if (!storeDir.isDirectory()) {
            throw new NotDirectoryException("The file given is not a directory.");
        }
        this.length = storeDir.list().length;
        String workDir = String.valueOf(storeDir.getCanonicalPath()) + "/" + "txDir_work";
        this.freMngr = new FileResourceManager(storeDir.getCanonicalPath(), workDir, false, (LoggerFacade)new PrintWriterLogger(new PrintWriter(System.out), XADirFile.class.getName(), false));
        this.freMngr.start();
    }

    public synchronized XADirFile[] listTXFiles() {
        File dir = new File(this.freMngr.getStoreDir());
        File[] files = dir.listFiles();
        LinkedList<XADirFile> xaDirFileList = new LinkedList<XADirFile>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (!f.isDirectory()) {
                xaDirFileList.add(new XADirFile(f, this));
            }
            ++n2;
        }
        XADirFile[] xaDirFiles = new XADirFile[xaDirFileList.size()];
        xaDirFileList.toArray(xaDirFiles);
        return xaDirFiles;
    }

    public synchronized void startTransactionOn(TransactionManager txnMngr) throws SystemException, RollbackException {
        this.curTxId = "txDir-" + this.freMngr.getWorkDir().replace('/', '_').replace('\\', '_').replace(':', '_') + "_" + Thread.currentThread().getId() + "!" + System.nanoTime();
        XAFileResourceManager xafre = new XAFileResourceManager(this.freMngr, this.curTxId);
        Transaction tx = txnMngr.getTransaction();
        tx.enlistResource((XAResource)xafre);
    }

    protected FileResourceManager getFreMngr() {
        return this.freMngr;
    }

    protected String getCurTxId() {
        return this.curTxId;
    }

    protected void increaseLength() {
        ++this.length;
    }

    protected void decreaseLength() {
        --this.length;
    }

    public long length() {
        return this.length;
    }

    @Override
    public void close() throws IOException {
        File store = new File(this.freMngr.getWorkDir());
        if (store.list().length != 0) {
            throw new IncompleteTransactionsException();
        }
        store.delete();
        this.freMngr = null;
    }
}

