/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.fileio.xalib.txfiles.file;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.jbossts.fileio.xalib.txfiles.file.DataRecord;
import org.jboss.jbossts.fileio.xalib.txfiles.file.XAFile;
import org.jboss.jbossts.fileio.xalib.txfiles.logging.LogEntry;
import org.jboss.jbossts.fileio.xalib.txfiles.logging.RecordsLogger;

public class XAResourceManager
implements XAResource,
Serializable {
    private Xid currentXid;
    private int timeout;
    private XAFile xaFile;
    private RecordsLogger log;
    private long th_id;
    private final transient int DEFAULT_TIMEOUT = 60;
    private boolean recovers;
    private transient Hashtable<Long, Integer> updatedBytes;

    protected XAResourceManager(XAFile xaFile, RecordsLogger log, long th_id) throws IOException {
        this.xaFile = xaFile;
        this.log = log;
        this.th_id = th_id;
        this.timeout = 60;
        this.recovers = false;
        this.updatedBytes = new Hashtable(89);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        System.out.println("XAResourceManager.prepare(Xid=" + xid + "), th_id=" + this.th_id);
        try {
            this.log.flush();
            this.log.close();
        }
        catch (IOException e) {
            throw new XAException("Unable to flush data to the log file <" + this.log.getFilename() + ">.");
        }
        return 0;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        System.out.println("XAResourceManager.commit(Xid=" + xid + ", onePhase=" + onePhase + "), th_id=" + this.th_id);
        if (!xid.equals(this.currentXid)) {
            System.out.println("XAResourceManager.commit - wrong Xid!");
        }
        try {
            this.commitChanges();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new XAException("Commit failed! Possibly an I/O error occurd while using the log file <" + this.log.getFilename() + ">");
        }
        this.log.delete();
        System.out.println("Original File Updated Successfully.");
        this.currentXid = null;
    }

    @Override
    public void end(Xid xid, int flags) {
        System.out.println("XAResourceManager.end(Xid=" + xid + ", flags=" + flags + "), th_id=" + this.th_id);
    }

    @Override
    public void forget(Xid xid) {
        System.out.println("XAResourceManager.forget(Xid=" + xid + ")");
        if (!xid.equals(this.currentXid)) {
            System.out.println("XAResourceManager.forget - wrong Xid!");
        }
        this.currentXid = null;
    }

    @Override
    public int getTransactionTimeout() {
        System.out.println("XAResourceManager.getTransactionTimeout() [returning " + this.timeout + "]");
        return this.timeout;
    }

    @Override
    public boolean isSameRM(XAResource xares) {
        System.out.println("XAResourceManager.isSameRM(xares=" + xares + ")");
        return false;
    }

    @Override
    public Xid[] recover(int flag) {
        System.out.println("XAResourceManager.recover(flag=" + flag + ")");
        return new Xid[0];
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        System.out.println("XAResourceManager.rollback(Xid=" + xid + "), th_id=" + this.th_id);
        long th_id = -100L;
        if (!xid.equals(this.currentXid)) {
            System.out.println("XAResourceManager.rollback - wrong Xid!");
        }
        if (!this.recovers) {
            th_id = this.th_id;
            this.updatedBytes.clear();
        }
        try {
            this.xaFile.removeTransaction(this.currentXid, this.recovers);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new XAException("Rollback failed. Could not disassociate the current thread " + th_id + "from the transaction with xid=<" + xid);
        }
        this.log.close();
        this.log.delete();
        this.currentXid = null;
    }

    @Override
    public boolean setTransactionTimeout(int seconds) {
        System.out.println("XAResourceManager.setTransactionTimeout(timeout=" + seconds + ")");
        if (seconds >= 0) {
            this.timeout = seconds;
            if (this.timeout == 0) {
                this.timeout = 60;
            }
            return true;
        }
        return false;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        System.out.println("XAResourceManager.start(Xid=" + xid + ", flags=" + flags + "), th_id=" + this.th_id);
        if (this.currentXid != null) {
            System.out.println("XAResourceManager.start - wrong Xid!");
            throw new XAException("Current Transaction is: <" + this.currentXid + ">\nCannot start the new Transaction.");
        }
        this.currentXid = xid;
    }

    private void commitChanges() throws IOException {
        long th_id = this.th_id;
        if (this.recovers) {
            th_id = -100L;
        }
        LinkedList<DataRecord> records = this.retrieveRecords();
        for (DataRecord dr : records) {
            this.xaFile.commitUpdates(dr.getStartPosition(), dr.getRecordLength(), dr.getRecordBytes(), th_id);
        }
        this.xaFile.sync();
        if (!this.recovers) {
            this.updatedBytes.clear();
        }
        this.xaFile.removeTransaction(this.currentXid, this.recovers);
    }

    private LinkedList<DataRecord> retrieveRecords() throws IOException {
        LinkedList<DataRecord> records = new LinkedList<DataRecord>();
        if (this.recovers) {
            LinkedList<LogEntry> logRecords = this.log.readAllRecords();
            for (LogEntry entry : logRecords) {
                try {
                    DataRecord dr = new DataRecord(entry.getPosition(), entry.getRecordLength(), XAFile.getIntsFromBytes(entry.getData()));
                    records.add(dr);
                }
                catch (Exception ioe) {
                    ioe.printStackTrace();
                }
            }
        } else {
            Set<Map.Entry<Long, Integer>> set = this.updatedBytes.entrySet();
            Iterator<Map.Entry<Long, Integer>> it = set.iterator();
            while (it.hasNext()) {
                int[] bs = new int[set.size()];
                Map.Entry<Long, Integer> kvPair = it.next();
                long position = kvPair.getKey();
                int b = kvPair.getValue();
                int index = bs.length - 1;
                bs[index] = b;
                while (it.hasNext()) {
                    kvPair = it.next();
                    if (position - kvPair.getKey() != 1L) break;
                    bs[--index] = kvPair.getValue();
                    position = kvPair.getKey();
                }
                int[] bytes = new int[bs.length - index];
                System.arraycopy(bs, 0, bytes, 0, bytes.length);
                records.add(new DataRecord(position - (long)index, bytes.length, bytes));
            }
        }
        return records;
    }

    protected void add2Log(DataRecord dr) throws IOException {
        LogEntry le = new LogEntry(dr.getStartPosition(), dr.getRecordLength(), dr.getRecordBytes());
        this.log.addInfo(le);
    }

    protected Xid getXid() {
        return this.currentXid;
    }

    protected Hashtable<Long, Integer> getUpdatedBytes() {
        return this.updatedBytes;
    }

    protected void addUpdatedBytes(long startPosition, int[] bytes) {
        int[] nArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            int b = nArray[n2];
            this.updatedBytes.put(startPosition++, b);
            ++n2;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.recovers = true;
        this.xaFile.initRAF();
        this.xaFile.initLocksHeld();
    }
}

