/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.fileio.xalib.txfiles.locking;

import java.io.Serializable;
import java.util.Hashtable;
import javax.transaction.xa.Xid;

public class XALock
implements Serializable,
Comparable<XALock> {
    private Xid xid;
    private long startPosition;
    private long lockLength;
    private Hashtable<Long, Integer> byteModes;

    public XALock(Xid xid, int mode, long startPosition, long lockLength) {
        this.xid = xid;
        this.startPosition = startPosition;
        this.lockLength = lockLength;
        this.initModes(mode);
    }

    private void initModes(int mode) {
        this.byteModes = new Hashtable(89);
        long sp = this.startPosition;
        while (sp < this.getEndPosition()) {
            this.byteModes.put(sp++, mode);
        }
    }

    protected Xid getXid() {
        return this.xid;
    }

    private void setModeAt(long position, int newMode) {
        this.byteModes.put(position, newMode);
    }

    private void setModeStartingAt(long position, long len, int newMode) {
        long ps = position;
        while (ps < len + position) {
            this.setModeAt(ps++, newMode);
        }
    }

    private long getStartPosition() {
        return this.startPosition;
    }

    private void setStartPosition(long startPosition) {
        long len_difference = this.startPosition - startPosition;
        this.lockLength += len_difference;
        this.startPosition = startPosition;
    }

    private long getLockLength() {
        return this.lockLength;
    }

    private void setLockLength(long lockLength) {
        this.lockLength = lockLength;
    }

    private long getEndPosition() {
        return this.getStartPosition() + this.getLockLength();
    }

    private boolean containsMode(int mode) {
        return this.byteModes.containsValue(mode);
    }

    private boolean containsModeBetween(long sp, long ep, int mode) {
        long p = sp;
        while (p < ep) {
            if (this.byteModes.get(sp) == mode) {
                return true;
            }
            ++p;
        }
        return false;
    }

    private boolean conflictsWith(XALock newLock) {
        return newLock == null || this.wraps(newLock) || this.isWrappedBy(newLock) || this.equals(newLock) || this.intersectedFromLeft(newLock) || this.intersectedFromRight(newLock);
    }

    protected int adjustWith(XALock neighLock) {
        boolean R_M = false;
        boolean W_M = true;
        int result = -100;
        if (neighLock != null && neighLock.conflictsWith(this)) {
            if (neighLock.getXid() == this.getXid()) {
                if (this.equals(neighLock) || neighLock.wraps(this)) {
                    if (!this.containsMode(1)) {
                        result = 100;
                    }
                    if (!this.containsMode(0)) {
                        neighLock.setModeStartingAt(this.getStartPosition(), this.getLockLength(), 1);
                        result = 50;
                    }
                } else if (neighLock.intersectedFromLeft(this)) {
                    long neighSP = neighLock.getStartPosition();
                    long conflict_length = this.getEndPosition() - neighSP;
                    if (!this.containsMode(0)) {
                        neighLock.setModeStartingAt(neighSP, conflict_length, 1);
                    }
                    this.setLockLength(this.getLockLength() - conflict_length);
                    result = 200;
                } else if (neighLock.intersectedFromRight(this)) {
                    long neighEP = neighLock.getEndPosition();
                    long conflict_length = neighEP - this.getStartPosition();
                    if (!this.containsMode(0)) {
                        neighLock.setModeStartingAt(this.getStartPosition(), conflict_length, 1);
                    }
                    this.setStartPosition(neighEP);
                    result = 200;
                } else if (neighLock.isWrappedBy(this) && !this.containsMode(0)) {
                    neighLock.setStartPosition(this.getStartPosition());
                    neighLock.setLockLength(this.getLockLength());
                    neighLock.initModes(1);
                    result = 50;
                }
            } else if (this.containsMode(1) || neighLock.containsMode(1)) {
                result = -100;
            } else if (neighLock.intersectedFromLeft(this)) {
                if (!this.containsMode(1)) {
                    result = neighLock.containsModeBetween(neighLock.getStartPosition(), this.getEndPosition(), 0) ? 100 : -100;
                }
            } else if (neighLock.intersectedFromRight(this) && !this.containsMode(1)) {
                result = neighLock.containsModeBetween(this.getStartPosition(), neighLock.getEndPosition(), 0) ? 100 : -100;
            }
        } else {
            return 1;
        }
        return result;
    }

    private boolean wraps(XALock newLock) {
        return this.getStartPosition() <= newLock.getStartPosition() && this.getEndPosition() > newLock.getEndPosition() || this.getStartPosition() < newLock.getStartPosition() && this.getEndPosition() >= newLock.getEndPosition();
    }

    private boolean isWrappedBy(XALock newLock) {
        return this.getStartPosition() >= newLock.getStartPosition() && this.getEndPosition() < newLock.getEndPosition() || this.getStartPosition() > newLock.getStartPosition() && this.getEndPosition() <= newLock.getEndPosition();
    }

    private boolean intersectedFromLeft(XALock newLock) {
        return newLock.getStartPosition() < this.getStartPosition() && newLock.getEndPosition() <= this.getEndPosition();
    }

    private boolean intersectedFromRight(XALock newLock) {
        return newLock.getStartPosition() >= this.getStartPosition() && newLock.getEndPosition() > this.getEndPosition();
    }

    @Override
    public int compareTo(XALock newXALock) {
        if (this.getStartPosition() < newXALock.getStartPosition()) {
            return 1;
        }
        if (this.getStartPosition() > newXALock.getStartPosition()) {
            return -1;
        }
        return 0;
    }

    private boolean equals(XALock newLock) {
        return this.compareTo(newLock) == 0 && this.getLockLength() == newLock.getLockLength();
    }
}

