/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.fileio.xalib.txfiles.locking;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedList;
import javax.transaction.xa.Xid;
import org.jboss.jbossts.fileio.ObjectOutputStreamAppend;
import org.jboss.jbossts.fileio.xalib.txfiles.locking.XALock;

public class XALockManager
implements Serializable {
    private String filename = "Locks/";
    private transient LinkedList<XALock> heldLocks;

    public XALockManager(String xaFilename) {
        this.filename = String.valueOf(this.filename) + this.getProcessedName(xaFilename);
        this.heldLocks = new LinkedList();
        try {
            File f = new File(this.filename);
            if (f.exists()) {
                this.obtainHeldLocksWith(null);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private String getProcessedName(String xaFilename) {
        xaFilename = xaFilename.replace('/', '_');
        xaFilename = xaFilename.replace('\\', '_');
        return xaFilename.concat("_locks.log");
    }

    public synchronized LinkedList<XALock> obtainHeldLocksWith(Xid xid) throws IOException {
        File file = new File(this.filename);
        if (file.exists()) {
            FileInputStream fIn = new FileInputStream(this.filename);
            ObjectInputStream in = new ObjectInputStream(fIn);
            boolean eof = false;
            do {
                try {
                    Object obj = in.readObject();
                    XALock xaLock = (XALock)obj;
                    if (xaLock.getXid() != xid && xid != null) continue;
                    this.insertLockAt(this.binarySearch(xaLock), xaLock);
                }
                catch (EOFException eofe) {
                    eof = true;
                }
                catch (ClassNotFoundException cnfe) {
                    cnfe.printStackTrace();
                }
            } while (!eof);
            in.close();
            fIn.close();
        }
        return this.heldLocks;
    }

    private synchronized void syncLocks() {
        try {
            FileOutputStream fOut = new FileOutputStream(this.filename);
            ObjectOutputStream out = new ObjectOutputStream(fOut);
            for (XALock lock : this.heldLocks) {
                out.writeObject(lock);
            }
            out.close();
            fOut.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public synchronized int tryLock(XALock lock) throws IOException {
        int index;
        int vResult;
        if (lock != null && (vResult = this.manageLocks(index = this.binarySearch(lock), lock)) != -100) {
            if (vResult == 1 || vResult == 200) {
                ObjectOutputStream out;
                FileOutputStream fOut;
                if (vResult == 200) {
                    this.syncLocks();
                }
                this.insertLockAt(index, lock);
                File lockFile = new File(this.filename);
                if (lockFile.exists()) {
                    fOut = new FileOutputStream(this.filename, true);
                    out = new ObjectOutputStreamAppend(fOut);
                } else {
                    fOut = new FileOutputStream(this.filename);
                    out = new ObjectOutputStream(fOut);
                }
                out.writeObject(lock);
                out.close();
                fOut.close();
            } else if (vResult == 50) {
                this.syncLocks();
            }
            return 0;
        }
        return 1;
    }

    private int binarySearch(XALock newLock) {
        int res = 0;
        int low = 0;
        int high = this.heldLocks.size() - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            XALock curLock = this.heldLocks.get(mid);
            int compRes = curLock.compareTo(newLock);
            if (compRes > 0) {
                low = mid + 1;
                res = mid + 1;
                continue;
            }
            if (compRes < 0) {
                high = mid - 1;
                res = mid;
                continue;
            }
            return mid;
        }
        return res;
    }

    private void insertLockAt(int index, XALock newLock) {
        if (index >= 0) {
            this.heldLocks.add(index, newLock);
        }
    }

    private int manageLocks(int it, XALock xaLock) {
        if (xaLock.getXid() != null) {
            XALock leftLock = null;
            XALock rightLock = null;
            if (it > 0) {
                leftLock = this.heldLocks.get(it - 1);
            }
            if (it < this.heldLocks.size()) {
                rightLock = this.heldLocks.get(it);
            }
            if (leftLock != null && rightLock != null) {
                int leftResult = xaLock.adjustWith(leftLock);
                int rightResult = xaLock.adjustWith(rightLock);
                if (leftResult == -100 || rightResult == -100) {
                    return -100;
                }
                if (leftResult == 200 || rightResult == 200) {
                    return 200;
                }
                if (leftResult == 50 || rightResult == 50) {
                    return 50;
                }
                if (leftResult == 1 || rightResult == 1) {
                    return 1;
                }
            } else {
                if (leftLock == null && rightLock == null) {
                    return 1;
                }
                if (leftLock == null) {
                    return xaLock.adjustWith(rightLock);
                }
                return xaLock.adjustWith(leftLock);
            }
        }
        return -100;
    }

    public void releaseLocks(Xid xid) {
        XALock[] locks = new XALock[this.heldLocks.size()];
        this.heldLocks.toArray(locks);
        XALock[] xALockArray = locks;
        int n = locks.length;
        int n2 = 0;
        while (n2 < n) {
            XALock lock = xALockArray[n2];
            if (lock.getXid() == xid) {
                this.heldLocks.remove(lock);
            }
            ++n2;
        }
        this.syncLocks();
    }

    public LinkedList<XALock> getHeldLocks() {
        return this.heldLocks;
    }

    public void deleteFile() {
        File f = new File(this.filename);
        if (f.exists()) {
            f.delete();
        }
    }
}

