/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.xml;

import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import org.jboss.osgi.common.log.LogServiceTracker;
import org.jboss.osgi.xml.internal.XMLParserActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class XMLParserActivatorExt
extends XMLParserActivator {
    public static final String PARSER_XINCLUDEAWARE = "parser.xincludeAware";
    private LogService log;

    public void start(BundleContext context) throws Exception {
        this.log = new LogServiceTracker(context);
        super.start(context);
        this.logSAXParserFactory(context);
        this.logDOMParserFactory(context);
    }

    public void setDOMProperties(DocumentBuilderFactory factory, Hashtable props) {
        boolean validating = true;
        factory.setValidating(true);
        factory.setNamespaceAware(false);
        try {
            factory.newDocumentBuilder();
        }
        catch (Exception pce_val) {
            validating = false;
        }
        boolean namespaceaware = true;
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            factory.newDocumentBuilder();
        }
        catch (Exception pce_nsa) {
            namespaceaware = false;
        }
        boolean xinclude = true;
        factory.setValidating(validating);
        factory.setNamespaceAware(namespaceaware);
        factory.setXIncludeAware(true);
        try {
            factory.newDocumentBuilder();
        }
        catch (Exception pce_inc) {
            xinclude = false;
        }
        factory.setValidating(validating);
        factory.setNamespaceAware(namespaceaware);
        factory.setXIncludeAware(xinclude);
        props.put("parser.validating", new Boolean(validating));
        props.put("parser.namespaceAware", new Boolean(namespaceaware));
        props.put(PARSER_XINCLUDEAWARE, new Boolean(xinclude));
    }

    public void setSAXProperties(SAXParserFactory factory, Hashtable props) {
        boolean validating = true;
        factory.setValidating(true);
        factory.setNamespaceAware(false);
        try {
            factory.newSAXParser();
        }
        catch (Exception pce_val) {
            validating = false;
        }
        boolean namespaceaware = true;
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            factory.newSAXParser();
        }
        catch (Exception pce_nsa) {
            namespaceaware = false;
        }
        boolean xinclude = true;
        factory.setValidating(validating);
        factory.setNamespaceAware(namespaceaware);
        factory.setXIncludeAware(true);
        try {
            factory.newSAXParser();
        }
        catch (Exception pce_inc) {
            xinclude = false;
        }
        factory.setValidating(validating);
        factory.setNamespaceAware(namespaceaware);
        factory.setXIncludeAware(xinclude);
        props.put("parser.namespaceAware", new Boolean(namespaceaware));
        props.put("parser.validating", new Boolean(validating));
        props.put(PARSER_XINCLUDEAWARE, new Boolean(xinclude));
    }

    private void logSAXParserFactory(BundleContext context) {
        ServiceReference saxRef = context.getServiceReference(SAXParserFactory.class.getName());
        if (saxRef != null) {
            Object factory = context.getService(saxRef);
            this.log.log(4, "SAXParserFactory: " + factory.getClass().getName());
            for (String key : saxRef.getPropertyKeys()) {
                Object value = saxRef.getProperty(key);
                this.log.log(4, "   " + key + "=" + value);
            }
        } else {
            this.log.log(2, "No SAXParserFactory registered");
        }
    }

    private void logDOMParserFactory(BundleContext context) {
        ServiceReference domRef = context.getServiceReference(DocumentBuilderFactory.class.getName());
        if (domRef != null) {
            Object factory = context.getService(domRef);
            this.log.log(4, "DocumentBuilderFactory: " + factory.getClass().getName());
            for (String key : domRef.getPropertyKeys()) {
                Object value = domRef.getProperty(key);
                this.log.log(4, "   " + key + "=" + value);
            }
        } else {
            this.log.log(2, "No DocumentBuilderFactory registered");
        }
    }
}

