/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.apache.xerces.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.SAXParserFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLParserActivatorExt
implements BundleActivator,
ServiceFactory {
    private BundleContext context;
    public static final String SAXFACTORYNAME = "javax.xml.parsers.SAXParserFactory";
    public static final String DOMFACTORYNAME = "javax.xml.parsers.DocumentBuilderFactory";
    private static final String PARSERCLASSFILEPATH = "/META-INF/services/";
    public static final String SAXCLASSFILE = "/META-INF/services/javax.xml.parsers.SAXParserFactory";
    public static final String DOMCLASSFILE = "/META-INF/services/javax.xml.parsers.DocumentBuilderFactory";
    private static final String SAXFACTORYDESCRIPTION = "A JAXP Compliant SAX Parser";
    private static final String DOMFACTORYDESCRIPTION = "A JAXP Compliant DOM Parser";
    public static final String PARSER_VALIDATING = "parser.validating";
    public static final String PARSER_NAMESPACEAWARE = "parser.namespaceAware";
    public static final String PARSER_XINCLUDEAWARE = "parser.xincludeAware";
    private static final String FACTORYNAMEKEY = "parser.factoryname";

    public void start(BundleContext context) throws Exception {
        this.context = context;
        Bundle parserBundle = context.getBundle();
        try {
            this.registerSAXParsers(this.getParserFactoryClassNames(parserBundle.getResource(SAXCLASSFILE)));
            this.registerDOMParsers(this.getParserFactoryClassNames(parserBundle.getResource(DOMCLASSFILE)));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new FactoryConfigurationError(ioe);
        }
    }

    public void stop(BundleContext context) throws Exception {
    }

    private Vector<String> getParserFactoryClassNames(URL parserUrl) throws IOException {
        Vector<String> v = new Vector<String>(1);
        if (parserUrl != null) {
            String parserFactoryClassName = null;
            InputStream is = parserUrl.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((parserFactoryClassName = br.readLine()) != null) {
                int commentIdx;
                String pfcName = parserFactoryClassName.trim();
                if (pfcName.length() == 0 || (commentIdx = pfcName.indexOf("#")) == 0) continue;
                if (commentIdx < 0) {
                    v.addElement(pfcName);
                    continue;
                }
                v.addElement(pfcName.substring(0, commentIdx).trim());
            }
            return v;
        }
        return null;
    }

    private void registerSAXParsers(Vector<String> parserFactoryClassNames) throws FactoryConfigurationError {
        if (parserFactoryClassNames != null) {
            Enumeration<String> e = parserFactoryClassNames.elements();
            int index = 0;
            while (e.hasMoreElements()) {
                String parserFactoryClassName = e.nextElement();
                SAXParserFactory factory = (SAXParserFactory)this.getFactory(parserFactoryClassName);
                Hashtable<String, Object> properties = new Hashtable<String, Object>(7);
                this.setDefaultSAXProperties(factory, properties, index);
                properties.put(FACTORYNAMEKEY, parserFactoryClassName);
                factory = null;
                this.context.registerService(SAXFACTORYNAME, (Object)this, properties);
                ++index;
            }
        }
    }

    private void setDefaultSAXProperties(SAXParserFactory factory, Hashtable<String, Object> props, int index) {
        props.put("service.description", SAXFACTORYDESCRIPTION);
        props.put("service.pid", "javax.xml.parsers.SAXParserFactory." + this.context.getBundle().getBundleId() + "." + index);
        this.setSAXProperties(factory, props);
    }

    public void setSAXProperties(SAXParserFactory factory, Hashtable<String, Object> props) {
        boolean validating = true;
        factory.setValidating(true);
        factory.setNamespaceAware(false);
        try {
            factory.newSAXParser();
        }
        catch (Exception pce_val) {
            validating = false;
        }
        boolean namespaceaware = true;
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            factory.newSAXParser();
        }
        catch (Exception pce_nsa) {
            namespaceaware = false;
        }
        boolean xinclude = true;
        factory.setValidating(validating);
        factory.setNamespaceAware(namespaceaware);
        factory.setXIncludeAware(true);
        try {
            factory.newSAXParser();
        }
        catch (Exception pce_inc) {
            xinclude = false;
        }
        factory.setValidating(validating);
        factory.setNamespaceAware(namespaceaware);
        factory.setXIncludeAware(xinclude);
        props.put(PARSER_NAMESPACEAWARE, new Boolean(namespaceaware));
        props.put(PARSER_VALIDATING, new Boolean(validating));
        props.put(PARSER_XINCLUDEAWARE, new Boolean(xinclude));
    }

    private void registerDOMParsers(Vector<String> parserFactoryClassNames) throws FactoryConfigurationError {
        if (parserFactoryClassNames != null) {
            Enumeration<String> e = parserFactoryClassNames.elements();
            int index = 0;
            while (e.hasMoreElements()) {
                String parserFactoryClassName = e.nextElement();
                DocumentBuilderFactory factory = (DocumentBuilderFactory)this.getFactory(parserFactoryClassName);
                Hashtable<String, Object> properties = new Hashtable<String, Object>(7);
                this.setDefaultDOMProperties(factory, properties, index);
                properties.put(FACTORYNAMEKEY, parserFactoryClassName);
                factory = null;
                this.context.registerService(DOMFACTORYNAME, (Object)this, properties);
                ++index;
            }
        }
    }

    private void setDefaultDOMProperties(DocumentBuilderFactory factory, Hashtable<String, Object> props, int index) {
        props.put("service.description", DOMFACTORYDESCRIPTION);
        props.put("service.pid", "javax.xml.parsers.DocumentBuilderFactory." + this.context.getBundle().getBundleId() + "." + index);
        this.setDOMProperties(factory, props);
    }

    public void setDOMProperties(DocumentBuilderFactory factory, Hashtable<String, Object> props) {
        boolean validating = true;
        factory.setValidating(true);
        factory.setNamespaceAware(false);
        try {
            factory.newDocumentBuilder();
        }
        catch (Exception pce_val) {
            validating = false;
        }
        boolean namespaceaware = true;
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            factory.newDocumentBuilder();
        }
        catch (Exception pce_nsa) {
            namespaceaware = false;
        }
        boolean xinclude = true;
        factory.setValidating(validating);
        factory.setNamespaceAware(namespaceaware);
        factory.setXIncludeAware(true);
        try {
            factory.newDocumentBuilder();
        }
        catch (Exception pce_inc) {
            xinclude = false;
        }
        factory.setValidating(validating);
        factory.setNamespaceAware(namespaceaware);
        factory.setXIncludeAware(xinclude);
        props.put(PARSER_VALIDATING, new Boolean(validating));
        props.put(PARSER_NAMESPACEAWARE, new Boolean(namespaceaware));
        props.put(PARSER_XINCLUDEAWARE, new Boolean(xinclude));
    }

    private Object getFactory(String parserFactoryClassName) throws FactoryConfigurationError {
        ReflectiveOperationException e = null;
        try {
            return Class.forName(parserFactoryClassName).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            e = cnfe;
        }
        catch (InstantiationException ie) {
            e = ie;
        }
        catch (IllegalAccessException iae) {
            e = iae;
        }
        throw new FactoryConfigurationError(e);
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        ServiceReference sref = registration.getReference();
        String parserFactoryClassName = (String)sref.getProperty(FACTORYNAMEKEY);
        try {
            Object factory = this.getFactory(parserFactoryClassName);
            if (factory instanceof SAXParserFactory) {
                ((SAXParserFactory)factory).setValidating((Boolean)sref.getProperty(PARSER_VALIDATING));
                ((SAXParserFactory)factory).setNamespaceAware((Boolean)sref.getProperty(PARSER_NAMESPACEAWARE));
            } else if (factory instanceof DocumentBuilderFactory) {
                ((DocumentBuilderFactory)factory).setValidating((Boolean)sref.getProperty(PARSER_VALIDATING));
                ((DocumentBuilderFactory)factory).setNamespaceAware((Boolean)sref.getProperty(PARSER_NAMESPACEAWARE));
            }
            return factory;
        }
        catch (FactoryConfigurationError fce) {
            fce.printStackTrace();
            return null;
        }
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
    }
}

