/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.apache.xerces.internal;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import org.jboss.osgi.apache.xerces.internal.XMLParserActivatorExt;
import org.jboss.osgi.common.log.LogServiceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class XercesParserActivator
extends XMLParserActivatorExt {
    private LogService log;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.log = new LogServiceTracker(context);
        this.logSAXParserFactory(context);
        this.logDOMParserFactory(context);
    }

    private void logSAXParserFactory(BundleContext context) {
        ServiceReference saxRef = context.getServiceReference(SAXParserFactory.class.getName());
        if (saxRef != null) {
            Object factory = context.getService(saxRef);
            this.log.log(4, "SAXParserFactory: " + factory.getClass().getName());
            for (String key : saxRef.getPropertyKeys()) {
                Object value = saxRef.getProperty(key);
                this.log.log(4, "   " + key + "=" + value);
            }
        } else {
            this.log.log(2, "No SAXParserFactory registered");
        }
    }

    private void logDOMParserFactory(BundleContext context) {
        ServiceReference domRef = context.getServiceReference(DocumentBuilderFactory.class.getName());
        if (domRef != null) {
            Object factory = context.getService(domRef);
            this.log.log(4, "DocumentBuilderFactory: " + factory.getClass().getName());
            for (String key : domRef.getPropertyKeys()) {
                Object value = domRef.getProperty(key);
                this.log.log(4, "   " + key + "=" + value);
            }
        } else {
            this.log.log(2, "No DocumentBuilderFactory registered");
        }
    }
}

