/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.common.internal;

import java.util.Dictionary;
import java.util.Properties;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.StandardMBean;
import org.jboss.osgi.common.internal.DeployerServiceDelegate;
import org.jboss.osgi.common.internal.DeploymentRegistryServiceImpl;
import org.jboss.osgi.common.internal.LoggingLogListener;
import org.jboss.osgi.common.internal.SystemDeployerService;
import org.jboss.osgi.spi.service.DeployerService;
import org.jboss.osgi.spi.service.DeploymentRegistryService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.util.tracker.ServiceTracker;

public abstract class AbstractCommonServicesActivator {
    protected ServiceTracker trackLogReaderService(BundleContext context) {
        ServiceTracker logTracker = new ServiceTracker(context, LogReaderService.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                LogReaderService logReader = (LogReaderService)super.addingService(reference);
                logReader.addLogListener((LogListener)new LoggingLogListener());
                return logReader;
            }
        };
        return logTracker;
    }

    protected DeployerService registerDeployerServices(BundleContext context) {
        DeploymentRegistryServiceImpl registry = new DeploymentRegistryServiceImpl(context);
        context.registerService(DeploymentRegistryService.class.getName(), (Object)registry, null);
        Properties props = new Properties();
        props.put("provider", "system");
        SystemDeployerService systemDeployer = new SystemDeployerService(context);
        context.registerService(DeployerService.class.getName(), (Object)systemDeployer, (Dictionary)props);
        props = new Properties();
        props.put("service.ranking", (Object)Integer.MAX_VALUE);
        DeployerServiceDelegate deployerDelegate = new DeployerServiceDelegate(context);
        context.registerService(DeployerService.class.getName(), (Object)deployerDelegate, (Dictionary)props);
        return deployerDelegate;
    }

    protected void registerDeployerServiceMBean(MBeanServer mbeanServer, DeployerService delegate) {
        try {
            StandardMBean mbean = new StandardMBean(delegate, DeployerService.class);
            mbeanServer.registerMBean(mbean, DeployerService.MBEAN_DEPLOYER_SERVICE);
        }
        catch (JMException ex) {
            throw new IllegalStateException("Cannot register DeployerService MBean", ex);
        }
    }

    protected void unregisterDeployerServiceMBean(MBeanServer mbeanServer) {
        try {
            if (mbeanServer.isRegistered(DeployerService.MBEAN_DEPLOYER_SERVICE)) {
                mbeanServer.unregisterMBean(DeployerService.MBEAN_DEPLOYER_SERVICE);
            }
        }
        catch (JMException ex) {
            this.logError("Cannot unregister DeployerService MBean", ex);
        }
    }

    protected abstract void logError(String var1, Exception var2);
}

