/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.common.internal;

import javax.management.MBeanServer;
import org.jboss.osgi.common.internal.AbstractCommonServicesActivator;
import org.jboss.osgi.common.log.LogServiceTracker;
import org.jboss.osgi.spi.service.DeployerService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class CommonServicesActivator
extends AbstractCommonServicesActivator
implements BundleActivator {
    private LogServiceTracker logServiceTracker;
    private ServiceTracker logReaderTracker;

    protected void logError(String message, Exception ex) {
        this.logServiceTracker.log(1, message, ex);
    }

    public void start(BundleContext context) {
        this.logServiceTracker = new LogServiceTracker(context);
        this.logReaderTracker = this.trackLogReaderService(context);
        this.logReaderTracker.open();
        DeployerService deployer = this.registerDeployerServices(context);
        this.trackMBeanServer(context, deployer);
    }

    public void stop(BundleContext context) {
        ServiceReference sref;
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
        }
        if (this.logReaderTracker != null) {
            this.logReaderTracker.close();
        }
        if ((sref = context.getServiceReference(MBeanServer.class.getName())) != null) {
            MBeanServer mbeanServer = (MBeanServer)context.getService(sref);
            this.unregisterDeployerServiceMBean(mbeanServer);
        }
    }

    private void trackMBeanServer(BundleContext context, final DeployerService deployer) {
        ServiceTracker jmxTracker = new ServiceTracker(context, MBeanServer.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                MBeanServer mbeanServer = (MBeanServer)super.addingService(reference);
                CommonServicesActivator.this.registerDeployerServiceMBean(mbeanServer, deployer);
                return mbeanServer;
            }

            public void removedService(ServiceReference reference, Object service) {
                MBeanServer mbeanServer = (MBeanServer)service;
                CommonServicesActivator.this.unregisterDeployerServiceMBean(mbeanServer);
                super.removedService(reference, service);
            }
        };
        jmxTracker.open();
    }
}

