/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.common.internal;

import java.net.URL;
import org.jboss.osgi.spi.service.DeployerService;
import org.jboss.osgi.spi.util.BundleDeployment;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class DeployerServiceDelegate
implements DeployerService {
    private BundleContext context;

    public DeployerServiceDelegate(BundleContext context) {
        this.context = context;
    }

    public void deploy(BundleDeployment[] bundles) throws BundleException {
        DeployerService service = this.getDefaultDeployerService();
        service.deploy(bundles);
    }

    public void deploy(URL url) throws BundleException {
        DeployerService service = this.getDefaultDeployerService();
        service.deploy(url);
    }

    public void undeploy(BundleDeployment[] bundles) throws BundleException {
        for (BundleDeployment info : bundles) {
            this.undeploy(info.getLocation());
        }
    }

    public boolean undeploy(URL url) throws BundleException {
        boolean undeployed = false;
        DeployerService service = this.getMicrocontainerDeployerService();
        if (service != null) {
            undeployed = service.undeploy(url);
        }
        if (!undeployed) {
            service = this.getSystemDeployerService();
            undeployed = service.undeploy(url);
        }
        return undeployed;
    }

    private DeployerService getDefaultDeployerService() {
        DeployerService service = this.getMicrocontainerDeployerService();
        if (service == null) {
            service = this.getSystemDeployerService();
        }
        return service;
    }

    private DeployerService getMicrocontainerDeployerService() {
        DeployerService service = null;
        try {
            String filter = "(provider=microcontainer)";
            String serviceName = DeployerService.class.getName();
            ServiceReference[] srefs = this.context.getServiceReferences(serviceName, filter);
            if (srefs != null) {
                service = (DeployerService)this.context.getService(srefs[0]);
            }
        }
        catch (InvalidSyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
        return service;
    }

    private DeployerService getSystemDeployerService() {
        DeployerService service = null;
        try {
            String filter = "(provider=system)";
            String serviceName = DeployerService.class.getName();
            ServiceReference[] srefs = this.context.getServiceReferences(serviceName, filter);
            if (srefs != null) {
                service = (DeployerService)this.context.getService(srefs[0]);
            }
        }
        catch (InvalidSyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
        if (service == null) {
            throw new IllegalStateException("Cannot obtain system DeployerService");
        }
        return service;
    }
}

