/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.common.internal;

import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.jboss.osgi.spi.service.DeploymentRegistryService;
import org.jboss.osgi.spi.util.BundleDeployment;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class DeploymentRegistryServiceImpl
implements DeploymentRegistryService {
    private Set<BundleDeployment> deployments = new HashSet<BundleDeployment>();

    public DeploymentRegistryServiceImpl(BundleContext context) {
    }

    public void registerBundleDeployment(BundleDeployment dep) {
        this.deployments.add(dep);
    }

    public void unregisterBundleDeployment(BundleDeployment dep) {
        this.deployments.remove(dep);
    }

    public BundleDeployment getBundleDeployment(String symbolicName, Version version) {
        if (symbolicName == null) {
            throw new IllegalArgumentException("Cannot obtain bundle deployment for null symbolic name");
        }
        BundleDeployment dep = null;
        for (BundleDeployment auxDep : this.deployments) {
            String auxName = auxDep.getSymbolicName();
            String auxVersion = auxDep.getVersion();
            if (!symbolicName.equals(auxName) || !version.equals((Object)auxVersion)) continue;
            dep = auxDep;
            break;
        }
        return dep;
    }

    public BundleDeployment getBundleDeployment(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Cannot obtain bundle deployment for: null");
        }
        BundleDeployment dep = null;
        for (BundleDeployment auxDep : this.deployments) {
            if (!url.equals(auxDep.getLocation())) continue;
            dep = auxDep;
            break;
        }
        return dep;
    }
}

