/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.common.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jboss.osgi.common.log.LogServiceTracker;
import org.jboss.osgi.spi.logging.ExportedPackageHelper;
import org.jboss.osgi.spi.management.ManagedBundleService;
import org.jboss.osgi.spi.service.DeployerService;
import org.jboss.osgi.spi.service.DeploymentRegistryService;
import org.jboss.osgi.spi.util.BundleDeployment;
import org.jboss.osgi.spi.util.BundleDeploymentFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;

public class SystemDeployerService
implements DeployerService {
    private LogServiceTracker log;
    private BundleContext context;
    private ServiceTracker registryTracker;
    private ServiceTracker startLevelTracker;

    public SystemDeployerService(BundleContext context) {
        this.log = new LogServiceTracker(context);
        this.context = context;
    }

    public void deploy(BundleDeployment[] depArr) throws BundleException {
        DeploymentRegistryService registry = this.getDeploymentRegistry();
        ArrayList<Bundle> resolvableBundles = new ArrayList<Bundle>();
        HashMap<BundleDeployment, Bundle> bundleMap = new HashMap<BundleDeployment, Bundle>();
        for (BundleDeployment dep : depArr) {
            try {
                String location = dep.getLocation().toExternalForm();
                Bundle bundle = this.context.installBundle(location);
                this.log.log(3, "Installed: " + bundle);
                this.registerManagedBundle(bundle);
                bundleMap.put(dep, bundle);
                if (dep.isAutoStart()) {
                    resolvableBundles.add(bundle);
                }
                registry.registerBundleDeployment(dep);
            }
            catch (BundleException ex) {
                this.log.log(1, "Cannot install bundle: " + dep, ex);
            }
        }
        ServiceReference packageAdminRef = this.context.getServiceReference(PackageAdmin.class.getName());
        if (packageAdminRef != null && !resolvableBundles.isEmpty()) {
            PackageAdmin packageAdmin = (PackageAdmin)this.context.getService(packageAdminRef);
            Bundle[] resolvableBundleArr = new Bundle[resolvableBundles.size()];
            resolvableBundles.toArray(resolvableBundleArr);
            packageAdmin.resolveBundles(resolvableBundleArr);
        }
        for (Map.Entry entry : bundleMap.entrySet()) {
            int state;
            BundleDeployment dep;
            dep = (BundleDeployment)entry.getKey();
            Bundle bundle = (Bundle)entry.getValue();
            StartLevel startLevel = this.getStartLevel();
            if (dep.getStartLevel() > 0) {
                startLevel.setBundleStartLevel(bundle, dep.getStartLevel());
            }
            if (!dep.isAutoStart() || (state = bundle.getState()) != 4 && packageAdminRef != null) continue;
            try {
                this.log.log(4, "Start: " + bundle);
                bundle.start();
                this.log.log(3, "Started: " + bundle);
                ExportedPackageHelper packageHelper = new ExportedPackageHelper(this.context);
                packageHelper.logExportedPackages(bundle);
            }
            catch (BundleException ex) {
                this.log.log(1, "Cannot start bundle: " + bundle, ex);
            }
        }
    }

    public void undeploy(BundleDeployment[] depArr) throws BundleException {
        DeploymentRegistryService registry = this.getDeploymentRegistry();
        for (BundleDeployment dep : depArr) {
            Bundle bundle = this.getBundle(dep);
            if (bundle != null) {
                registry.unregisterBundleDeployment(dep);
                this.unregisterManagedBundle(bundle);
                bundle.uninstall();
                this.log.log(3, "Uninstalled: " + bundle);
                continue;
            }
            this.log.log(2, "Cannot obtain bundle for: " + dep);
        }
    }

    public void deploy(URL url) throws BundleException {
        BundleDeployment dep = BundleDeploymentFactory.createBundleDeployment((URL)url);
        this.deploy(new BundleDeployment[]{dep});
    }

    public boolean undeploy(URL url) throws BundleException {
        DeploymentRegistryService registry = this.getDeploymentRegistry();
        BundleDeployment dep = registry.getBundleDeployment(url);
        if (dep != null) {
            this.undeploy(new BundleDeployment[]{dep});
            return true;
        }
        this.log.log(2, "Cannot find deployment for: " + url);
        return false;
    }

    private Bundle getBundle(BundleDeployment dep) {
        String symbolicName = dep.getSymbolicName();
        Version version = Version.parseVersion((String)dep.getVersion());
        Bundle bundle = null;
        for (Bundle aux : this.context.getBundles()) {
            Version auxVersion;
            if (!aux.getSymbolicName().equals(symbolicName) || !version.equals((Object)(auxVersion = aux.getVersion()))) continue;
            bundle = aux;
            break;
        }
        return bundle;
    }

    private void registerManagedBundle(Bundle bundle) {
        ServiceReference sref = this.context.getServiceReference(ManagedBundleService.class.getName());
        if (sref != null) {
            ManagedBundleService service = (ManagedBundleService)this.context.getService(sref);
            service.register(bundle);
        } else {
            this.log.log(4, "No ManagedBundleService. Cannot register managed bundle: " + bundle);
        }
    }

    private void unregisterManagedBundle(Bundle bundle) {
        ServiceReference sref = this.context.getServiceReference(ManagedBundleService.class.getName());
        if (sref != null) {
            ManagedBundleService service = (ManagedBundleService)this.context.getService(sref);
            service.unregister(bundle);
        } else {
            this.log.log(4, "No ManagedBundleService. Cannot unregister managed bundle: " + bundle);
        }
    }

    private DeploymentRegistryService getDeploymentRegistry() {
        if (this.registryTracker == null) {
            this.registryTracker = new ServiceTracker(this.context, DeploymentRegistryService.class.getName(), null);
            this.registryTracker.open();
        }
        return (DeploymentRegistryService)this.registryTracker.getService();
    }

    private StartLevel getStartLevel() {
        if (this.startLevelTracker == null) {
            this.startLevelTracker = new ServiceTracker(this.context, StartLevel.class.getName(), null);
            this.startLevelTracker.open();
        }
        return (StartLevel)this.startLevelTracker.getService();
    }
}

