/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.husky.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.osgi.husky.Request;
import org.jboss.osgi.husky.Response;
import org.jboss.osgi.husky.internal.BasicFailure;
import org.jboss.osgi.husky.internal.BasicResponse;
import org.jboss.osgi.husky.runtime.Connector;
import org.jboss.osgi.husky.runtime.PackageListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConnector
implements Connector {
    private List<PackageListener> listeners = new ArrayList<PackageListener>();

    @Override
    public void addPackageListener(PackageListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public List<PackageListener> getPackageListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    @Override
    public void removePackageListener(PackageListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Response process(Request req) throws ClassNotFoundException {
        String testClass = req.getClassName();
        for (PackageListener listener : this.listeners) {
            if (!listener.match(req)) continue;
            return listener.runTests(req);
        }
        throw new IllegalStateException("Cannot find listener to handle: " + testClass + ", we have " + this.listeners);
    }

    protected InputStream process(InputStream reqStream) {
        Request request = null;
        Response response = null;
        try {
            ObjectInputStream ois = new ObjectInputStream(reqStream);
            request = (Request)ois.readObject();
            response = this.process(request);
        }
        catch (Exception ex) {
            response = new BasicResponse();
            BasicFailure failure = new BasicFailure(ex.getMessage(), ex);
            if (request != null) {
                failure.setClassName(request.getClassName());
                failure.setMethodName(request.getMethodName());
            }
            response.addFailure(failure);
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(response);
            oos.close();
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot marshall response", ex);
        }
    }
}

