/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.husky.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.osgi.husky.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicContext
implements Context {
    private Map<Context.Key, Object> attachments = new HashMap<Context.Key, Object>();

    public BasicContext() {
    }

    public BasicContext(Context att) {
        if (att != null) {
            for (Context.Key key : att.getAttachmentKeys()) {
                Object value = att.getAttachment(key.getClassPart(), key.getNamePart());
                this.attachments.put(key, value);
            }
        }
    }

    @Override
    public Collection<Context.Key> getAttachmentKeys() {
        return this.attachments.keySet();
    }

    @Override
    public <T> T getAttachment(Class<T> clazz) {
        return (T)this.attachments.get(new Context.Key(clazz, null));
    }

    @Override
    public <T> T getAttachment(Class<T> clazz, String name) {
        return (T)this.attachments.get(new Context.Key(clazz, name));
    }

    @Override
    public Object getAttachment(String name) {
        return this.attachments.get(new Context.Key(null, name));
    }

    @Override
    public <T> T addAttachment(Class<T> clazz, Object obj) {
        return (T)this.attachments.put(new Context.Key(clazz, null), obj);
    }

    @Override
    public <T> T addAttachment(Class<T> clazz, String name, Object obj) {
        return (T)this.attachments.put(new Context.Key(clazz, name), obj);
    }

    @Override
    public Object addAttachment(String name, Object obj) {
        return this.attachments.put(new Context.Key(null, name), obj);
    }

    @Override
    public <T> T removeAttachment(Class<T> clazz) {
        return (T)this.attachments.remove(new Context.Key(clazz, null));
    }

    @Override
    public <T> T removeAttachment(Class<T> clazz, String name) {
        return (T)this.attachments.remove(new Context.Key(clazz, name));
    }

    @Override
    public Object removeAttachment(String name) {
        return this.attachments.remove(new Context.Key(null, name));
    }

    public String toString() {
        return this.attachments.toString();
    }
}

