/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.husky.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.jboss.osgi.husky.Request;
import org.jboss.osgi.husky.Response;
import org.jboss.osgi.husky.internal.Util;
import org.jboss.osgi.husky.runtime.osgi.SocketConnector;

public class SocketInvocation {
    public static boolean isRemoteConnection() {
        return SocketInvocation.getHost() != null && SocketInvocation.getPort() != null;
    }

    private static String getPort() {
        String port = System.getProperty(SocketConnector.PROP_SOCKET_CONNECTOR_PORT);
        return port;
    }

    private static String getHost() {
        String host = System.getProperty(SocketConnector.PROP_SOCKET_CONNECTOR_HOST);
        return host;
    }

    public Response invoke(Request req) throws Exception {
        Socket socket = new Socket(InetAddress.getByName(SocketInvocation.getHost()), (int)new Integer(SocketInvocation.getPort()));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(req);
        oos.close();
        ByteArrayInputStream reqBytes = new ByteArrayInputStream(baos.toByteArray());
        Util.copyStream(reqBytes, socket.getOutputStream());
        ObjectInputStream ois = new ObjectInputStream(socket.getInputStream());
        Response response = (Response)ois.readObject();
        return response;
    }
}

